//========================================
// MotifInterface.H
// 
// Ugly hack to turn the Motif interface 
// into a X11-only interface. This is
// really awfull, and doesn't work anyway.
// 
// ZNibbles
// Vincent Mallet 1997
//========================================

// $Id: X11Interface.H,v 1.7 1999/05/11 02:20:44 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __H_X11INTERFACE__
#define __H_X11INTERFACE__

#include "BaseInterface.H"

#include "Common.H"
#include "Trame.H"

#include "NibblesArea.H"

#include "DLList.h"

#include <X11/Xlib.h>


class X11Interface : public BaseInterface {
public:
  inline X11Interface(World& wr) : BaseInterface(wr), nibblesarea(*this),
      display_name(NULL), border_width(4), x(0), y(0), 
      sent(0), _two_key(0)
  { }
  
  void init(int argc, char *argv[]);
  void run();
  void end() { }
  
  
  void set_own_player(Player& p) { void *q = &p; q = q;}
  
  void add_player(Player& p);
  void kill_player(Player& p, int reason);
  
  void display_message(Player& from, char *msg, int priv);
  void display_system_message(char *msg, Player *p = NULL, int color = 0);


  void send_direction(Direction direction = 0);
  
  void pause_request(int pause_type);
  void init_messages(char *filename);
  void send_predefined_message(int num);

  void join_game();

  void display_version();             // display version number (long format)
  void display_version_short();       // display version number (short format)
  void display_help(char *name);      // display help
  void display_play_help();           // display key help


protected:
  Trame t;
  Trame tx;

  int socket_client;

  static int dead_server; // bon, en attendant de resoudre le pb

  static void pipe_handler(int sig);
    
  NibblesArea nibblesarea;


  // For X11
  Display *display;
  char    *display_name;

  int     screen;

  Window win;                          // window descriptor

  int display_width, display_height;   // taille de l'ecran (root window) 
  int width, height;                   // taille de la fenetre 
  unsigned int border_width;           // largeur de la bordure 
  int x, y;                            // position de la fenetre 

  GC                gc;                // ID du contexte graphique 


  char            * predefined_messages[10];
  
  int               sent;

  int               _two_key;          // boolean: two-key mode
  int               _stdin_input;      // boolean: check for data on stdin ?

  DLList<Direction> dirs;

  char            * own_name;          // this player name


  void X11Init(int argc, char **argv);

  void handle_Xevent();

  void send_direction0(Direction direction, int do_append);


}; // class X11Interface




#endif // __H_X11INTERFACE__







