/*
 * abslist.C
 *
 * abstract Motif selection list
 *
 * Vincent Mallet 1997 - vmallet@clio.unice.fr
 */

// $Id: abslist.C,v 1.2 1998/11/17 08:42:58 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <X11/cursorfont.h>

#include <Xm/Xm.h>
#include <Xm/List.h>
#include <Xm/ScrollBar.h>

#include <stdio.h>

#include "motifutil.H"
#include "abslist.H"


void AbsList:: add_entry(char *name)
  // rajoute une entree dans la liste
{
  XmListAddItem(widget, XmStringCreateLtoR(name, XmSTRING_DEFAULT_CHARSET), 0);
}


void AbsList:: set_current(int index)
  // positionne le curseur sur l'entree 'index',
  // et repositionne la liste pour le rendre visible
  // (si necessaire)
{
  int top, visible;

  index++; // on va de 1 a n

  XtVaGetValues(widget, XmNtopItemPosition, &top,
		        XmNvisibleItemCount, &visible,
		NULL);

  if (index < top)
    XmListSetPos(widget, index);
  else if (index > top + visible)
    XmListSetBottomPos(widget, index);

  XmListSelectPos(widget, index, False);
}


void AbsList:: clear(void)
  // Purge la liste de toutes ses entrees
{
  XmListDeleteAllItems(widget);
}


void AbsList:: nice_cursor(int shape)
  // change le curseur de la liste
{
  :: nice_cursor(widget, shape);
}






