/*
 * textearea.C
 *
 * Petite classe pour gerer la textarea dans ZNibbles
 * pue pas mal. 
 *
 * Vincent Mallet 1997 - vmallet@clio.unice.fr
 */

// $Id: textarea.C,v 1.2 1998/11/17 08:42:50 vmallet Exp $

/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <Xm/Xm.h>
#include <Xm/ScrollBar.h>
#include <Xm/Text.h>

#include <iostream.h>
#include "string.h"

#include "motifutil.H"

#include "textarea.H"



// Construction, destruction
TextArea::TextArea() : widget(0), bbuf(NULL) { }

TextArea::~TextArea() { if (bbuf) delete[] bbuf; }

// initialisation
void TextArea::make(Widget parent)
/* Creates the text widget to hold the data being viewed */
{
  Widget hsb;

  widget = XmCreateScrolledText(parent, "TextArea", NULL, 0);
  XtManageChild(widget);

  XtVaGetValues(XtParent(widget), XmNhorizontalScrollBar, &hsb, NULL);
  if (hsb)
    XtUnmanageChild(hsb);
	    
  length = 0;
  bbuf = new char[10000];
  *bbuf = '\0';
}


// set de tout le texte
void TextArea::set_text(char *text)
{
  if (text)
    XmTextSetString(widget, text);
  else
    XmTextSetString(widget, "There's a bug somewhere :))");

  length = strlen(text);
}


// rajout d'une ligne au texte
void TextArea::add_line(char *line)
{
  if (!line)
    line = "Oulalalala un bug!";
  
  strcat(bbuf, line);
  
  length = strlen(bbuf);

  set_text(bbuf);
  XmTextSetCursorPosition(widget, XmTextGetLastPosition(widget));
  XmTextShowPosition(widget, XmTextGetLastPosition(widget));
  if (length > 9500) {
    cout << "textarea warning!" << endl;
    bbuf[0] = '\0';
  }
}


void TextArea:: nice_cursor(int shape)
{
  :: nice_cursor(widget, shape);
}



