/* ZNibbles - a small multiplayer game
 * Copyright (C) 1997, 1998 Vincent Mallet - vmallet@enst.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/* Fonction de creation et d'attachement d'une socket INTERNET.
   1er parametre  : type de la socket (SOCK_STREAM ou SOCK_DGRAM) 
   2eme parametre : un pointeur sur un entier (numero de port)
   3eme parametre : un pointeur sur sockaddr_in
   La socket sera attache a l'adresse machine IADDR_ANY */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "creer_socket.h"

static struct sockaddr_in adresse;

int creer_socket(int type, int *p_port, struct sockaddr_in *p_adresse)
{
  int desc;                                  /* descripteur de la socket */
  int longueur = sizeof(struct sockaddr_in); /* taille de l'adresse */

  /* 1) Creation de la socket */
  if ((desc=socket(AF_INET,type, 0)) == -1) {
    perror("Unable to create socket");
    return -1;
  }

  /* 2) Preparation de l'adresse d'attachement */
  adresse.sin_family      = AF_INET;
  adresse.sin_addr.s_addr = htonl(INADDR_ANY);
  adresse.sin_port        = htons(*p_port); 

  /* 3) Demande d'attachement de la socket */
  if(bind(desc, (struct sockaddr *) &adresse, longueur) == -1) {
    perror("Unable to attach socket");
    close(desc); /* => fermeture de la socket */
    return(-1);
  }
  
  /* 4) Recuperation de l'adresse effective d'attachement (p_adresse)
     a partir du desc et grace a getsockname(...). */
  if(p_adresse != NULL)
    getsockname(desc, (struct sockaddr *) p_adresse, &longueur); 

  return desc;                             
}


