/*
 * tclCompileDecls.h --
 *
 *	This file contains the declarations for all unsupported
 *	functions that are exported by the Tcl library.  These
 *	interfaces are not guaranteed to remain the same between
 *	versions.  Use at your own risk.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclCompileDecls.h,v 1.17 1999/08/10 02:42:14 welch Exp $
 */

#ifndef _TCLCOMPILEDECLS
#define _TCLCOMPILEDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tclInt.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN void		TclCleanupByteCode _ANSI_ARGS_((ByteCode * codePtr));
/* 1 */
EXTERN int		TclCompileCmdWord _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Token * tokenPtr, int count, 
				CompileEnv * envPtr));
/* 2 */
EXTERN int		TclCompileExpr _ANSI_ARGS_((Tcl_Interp * interp, 
				char * script, int numBytes, 
				CompileEnv * envPtr));
/* 3 */
EXTERN int		TclCompileExprWords _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Token * tokenPtr, int numWords, 
				CompileEnv * envPtr));
/* 4 */
EXTERN int		TclCompileScript _ANSI_ARGS_((Tcl_Interp * interp, 
				char * script, int numBytes, int nested, 
				CompileEnv * envPtr));
/* 5 */
EXTERN int		TclCompileTokens _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Token * tokenPtr, int count, 
				CompileEnv * envPtr));
/* 6 */
EXTERN int		TclCreateAuxData _ANSI_ARGS_((ClientData clientData, 
				AuxDataType * typePtr, CompileEnv * envPtr));
/* 7 */
EXTERN int		TclCreateExceptRange _ANSI_ARGS_((
				ExceptionRangeType type, CompileEnv * envPtr));
/* 8 */
EXTERN ExecEnv *	TclCreateExecEnv _ANSI_ARGS_((Tcl_Interp * interp));
/* 9 */
EXTERN void		TclDeleteExecEnv _ANSI_ARGS_((ExecEnv * eePtr));
/* 10 */
EXTERN void		TclDeleteLiteralTable _ANSI_ARGS_((
				Tcl_Interp * interp, LiteralTable * tablePtr));
/* 11 */
EXTERN void		TclEmitForwardJump _ANSI_ARGS_((CompileEnv * envPtr, 
				TclJumpType jumpType, 
				JumpFixup * jumpFixupPtr));
/* 12 */
EXTERN InstructionDesc * TclGetInstructionTable _ANSI_ARGS_((void));
/* 13 */
EXTERN int		TclExecuteByteCode _ANSI_ARGS_((Tcl_Interp * interp, 
				ByteCode * codePtr));
/* 14 */
EXTERN void		TclExpandCodeArray _ANSI_ARGS_((CompileEnv * envPtr));
/* 15 */
EXTERN void		TclExpandJumpFixupArray _ANSI_ARGS_((
				JumpFixupArray * fixupArrayPtr));
/* 16 */
EXTERN void		TclFinalizeAuxDataTypeTable _ANSI_ARGS_((void));
/* 17 */
EXTERN int		TclFindCompiledLocal _ANSI_ARGS_((char * name, 
				int nameChars, int create, int flags, 
				Proc * procPtr));
/* 18 */
EXTERN LiteralEntry *	TclLookupLiteralEntry _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * objPtr));
/* 19 */
EXTERN int		TclFixupForwardJump _ANSI_ARGS_((CompileEnv * envPtr, 
				JumpFixup * jumpFixupPtr, int jumpDist, 
				int distThreshold));
/* 20 */
EXTERN void		TclFreeCompileEnv _ANSI_ARGS_((CompileEnv * envPtr));
/* 21 */
EXTERN void		TclFreeJumpFixupArray _ANSI_ARGS_((
				JumpFixupArray * fixupArrayPtr));
/* 22 */
EXTERN void		TclInitAuxDataTypeTable _ANSI_ARGS_((void));
/* 23 */
EXTERN void		TclInitByteCodeObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				CompileEnv * envPtr));
/* 24 */
EXTERN void		TclInitCompileEnv _ANSI_ARGS_((Tcl_Interp * interp, 
				CompileEnv * envPtr, char * string, 
				int numBytes));
/* 25 */
EXTERN void		TclInitJumpFixupArray _ANSI_ARGS_((
				JumpFixupArray * fixupArrayPtr));
/* 26 */
EXTERN void		TclInitLiteralTable _ANSI_ARGS_((
				LiteralTable * tablePtr));
/* 27 */
EXTERN int		TclPrintInstruction _ANSI_ARGS_((ByteCode* codePtr, 
				unsigned char * pc));
/* 28 */
EXTERN void		TclRegisterAuxDataType _ANSI_ARGS_((
				AuxDataType * typePtr));
/* 29 */
EXTERN int		TclRegisterLiteral _ANSI_ARGS_((CompileEnv * envPtr, 
				char * bytes, int length, int onHeap));
/* 30 */
EXTERN void		TclReleaseLiteral _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr));
/* 31 */
EXTERN void		TclSetCmdNameObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, Command * cmdPtr));

typedef struct TclCompileStubs {
    int magic;
    struct TclCompileStubHooks *hooks;

    void (*tclCleanupByteCode) _ANSI_ARGS_((ByteCode * codePtr)); /* 0 */
    int (*tclCompileCmdWord) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Token * tokenPtr, int count, CompileEnv * envPtr)); /* 1 */
    int (*tclCompileExpr) _ANSI_ARGS_((Tcl_Interp * interp, char * script, int numBytes, CompileEnv * envPtr)); /* 2 */
    int (*tclCompileExprWords) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Token * tokenPtr, int numWords, CompileEnv * envPtr)); /* 3 */
    int (*tclCompileScript) _ANSI_ARGS_((Tcl_Interp * interp, char * script, int numBytes, int nested, CompileEnv * envPtr)); /* 4 */
    int (*tclCompileTokens) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Token * tokenPtr, int count, CompileEnv * envPtr)); /* 5 */
    int (*tclCreateAuxData) _ANSI_ARGS_((ClientData clientData, AuxDataType * typePtr, CompileEnv * envPtr)); /* 6 */
    int (*tclCreateExceptRange) _ANSI_ARGS_((ExceptionRangeType type, CompileEnv * envPtr)); /* 7 */
    ExecEnv * (*tclCreateExecEnv) _ANSI_ARGS_((Tcl_Interp * interp)); /* 8 */
    void (*tclDeleteExecEnv) _ANSI_ARGS_((ExecEnv * eePtr)); /* 9 */
    void (*tclDeleteLiteralTable) _ANSI_ARGS_((Tcl_Interp * interp, LiteralTable * tablePtr)); /* 10 */
    void (*tclEmitForwardJump) _ANSI_ARGS_((CompileEnv * envPtr, TclJumpType jumpType, JumpFixup * jumpFixupPtr)); /* 11 */
    InstructionDesc * (*tclGetInstructionTable) _ANSI_ARGS_((void)); /* 12 */
    int (*tclExecuteByteCode) _ANSI_ARGS_((Tcl_Interp * interp, ByteCode * codePtr)); /* 13 */
    void (*tclExpandCodeArray) _ANSI_ARGS_((CompileEnv * envPtr)); /* 14 */
    void (*tclExpandJumpFixupArray) _ANSI_ARGS_((JumpFixupArray * fixupArrayPtr)); /* 15 */
    void (*tclFinalizeAuxDataTypeTable) _ANSI_ARGS_((void)); /* 16 */
    int (*tclFindCompiledLocal) _ANSI_ARGS_((char * name, int nameChars, int create, int flags, Proc * procPtr)); /* 17 */
    LiteralEntry * (*tclLookupLiteralEntry) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr)); /* 18 */
    int (*tclFixupForwardJump) _ANSI_ARGS_((CompileEnv * envPtr, JumpFixup * jumpFixupPtr, int jumpDist, int distThreshold)); /* 19 */
    void (*tclFreeCompileEnv) _ANSI_ARGS_((CompileEnv * envPtr)); /* 20 */
    void (*tclFreeJumpFixupArray) _ANSI_ARGS_((JumpFixupArray * fixupArrayPtr)); /* 21 */
    void (*tclInitAuxDataTypeTable) _ANSI_ARGS_((void)); /* 22 */
    void (*tclInitByteCodeObj) _ANSI_ARGS_((Tcl_Obj * objPtr, CompileEnv * envPtr)); /* 23 */
    void (*tclInitCompileEnv) _ANSI_ARGS_((Tcl_Interp * interp, CompileEnv * envPtr, char * string, int numBytes)); /* 24 */
    void (*tclInitJumpFixupArray) _ANSI_ARGS_((JumpFixupArray * fixupArrayPtr)); /* 25 */
    void (*tclInitLiteralTable) _ANSI_ARGS_((LiteralTable * tablePtr)); /* 26 */
    int (*tclPrintInstruction) _ANSI_ARGS_((ByteCode* codePtr, unsigned char * pc)); /* 27 */
    void (*tclRegisterAuxDataType) _ANSI_ARGS_((AuxDataType * typePtr)); /* 28 */
    int (*tclRegisterLiteral) _ANSI_ARGS_((CompileEnv * envPtr, char * bytes, int length, int onHeap)); /* 29 */
    void (*tclReleaseLiteral) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr)); /* 30 */
    void (*tclSetCmdNameObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, Command * cmdPtr)); /* 31 */
} TclCompileStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern TclCompileStubs *tclCompileStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef TclCleanupByteCode
#define TclCleanupByteCode \
	(tclCompileStubsPtr->tclCleanupByteCode) /* 0 */
#endif
#ifndef TclCompileCmdWord
#define TclCompileCmdWord \
	(tclCompileStubsPtr->tclCompileCmdWord) /* 1 */
#endif
#ifndef TclCompileExpr
#define TclCompileExpr \
	(tclCompileStubsPtr->tclCompileExpr) /* 2 */
#endif
#ifndef TclCompileExprWords
#define TclCompileExprWords \
	(tclCompileStubsPtr->tclCompileExprWords) /* 3 */
#endif
#ifndef TclCompileScript
#define TclCompileScript \
	(tclCompileStubsPtr->tclCompileScript) /* 4 */
#endif
#ifndef TclCompileTokens
#define TclCompileTokens \
	(tclCompileStubsPtr->tclCompileTokens) /* 5 */
#endif
#ifndef TclCreateAuxData
#define TclCreateAuxData \
	(tclCompileStubsPtr->tclCreateAuxData) /* 6 */
#endif
#ifndef TclCreateExceptRange
#define TclCreateExceptRange \
	(tclCompileStubsPtr->tclCreateExceptRange) /* 7 */
#endif
#ifndef TclCreateExecEnv
#define TclCreateExecEnv \
	(tclCompileStubsPtr->tclCreateExecEnv) /* 8 */
#endif
#ifndef TclDeleteExecEnv
#define TclDeleteExecEnv \
	(tclCompileStubsPtr->tclDeleteExecEnv) /* 9 */
#endif
#ifndef TclDeleteLiteralTable
#define TclDeleteLiteralTable \
	(tclCompileStubsPtr->tclDeleteLiteralTable) /* 10 */
#endif
#ifndef TclEmitForwardJump
#define TclEmitForwardJump \
	(tclCompileStubsPtr->tclEmitForwardJump) /* 11 */
#endif
#ifndef TclGetInstructionTable
#define TclGetInstructionTable \
	(tclCompileStubsPtr->tclGetInstructionTable) /* 12 */
#endif
#ifndef TclExecuteByteCode
#define TclExecuteByteCode \
	(tclCompileStubsPtr->tclExecuteByteCode) /* 13 */
#endif
#ifndef TclExpandCodeArray
#define TclExpandCodeArray \
	(tclCompileStubsPtr->tclExpandCodeArray) /* 14 */
#endif
#ifndef TclExpandJumpFixupArray
#define TclExpandJumpFixupArray \
	(tclCompileStubsPtr->tclExpandJumpFixupArray) /* 15 */
#endif
#ifndef TclFinalizeAuxDataTypeTable
#define TclFinalizeAuxDataTypeTable \
	(tclCompileStubsPtr->tclFinalizeAuxDataTypeTable) /* 16 */
#endif
#ifndef TclFindCompiledLocal
#define TclFindCompiledLocal \
	(tclCompileStubsPtr->tclFindCompiledLocal) /* 17 */
#endif
#ifndef TclLookupLiteralEntry
#define TclLookupLiteralEntry \
	(tclCompileStubsPtr->tclLookupLiteralEntry) /* 18 */
#endif
#ifndef TclFixupForwardJump
#define TclFixupForwardJump \
	(tclCompileStubsPtr->tclFixupForwardJump) /* 19 */
#endif
#ifndef TclFreeCompileEnv
#define TclFreeCompileEnv \
	(tclCompileStubsPtr->tclFreeCompileEnv) /* 20 */
#endif
#ifndef TclFreeJumpFixupArray
#define TclFreeJumpFixupArray \
	(tclCompileStubsPtr->tclFreeJumpFixupArray) /* 21 */
#endif
#ifndef TclInitAuxDataTypeTable
#define TclInitAuxDataTypeTable \
	(tclCompileStubsPtr->tclInitAuxDataTypeTable) /* 22 */
#endif
#ifndef TclInitByteCodeObj
#define TclInitByteCodeObj \
	(tclCompileStubsPtr->tclInitByteCodeObj) /* 23 */
#endif
#ifndef TclInitCompileEnv
#define TclInitCompileEnv \
	(tclCompileStubsPtr->tclInitCompileEnv) /* 24 */
#endif
#ifndef TclInitJumpFixupArray
#define TclInitJumpFixupArray \
	(tclCompileStubsPtr->tclInitJumpFixupArray) /* 25 */
#endif
#ifndef TclInitLiteralTable
#define TclInitLiteralTable \
	(tclCompileStubsPtr->tclInitLiteralTable) /* 26 */
#endif
#ifndef TclPrintInstruction
#define TclPrintInstruction \
	(tclCompileStubsPtr->tclPrintInstruction) /* 27 */
#endif
#ifndef TclRegisterAuxDataType
#define TclRegisterAuxDataType \
	(tclCompileStubsPtr->tclRegisterAuxDataType) /* 28 */
#endif
#ifndef TclRegisterLiteral
#define TclRegisterLiteral \
	(tclCompileStubsPtr->tclRegisterLiteral) /* 29 */
#endif
#ifndef TclReleaseLiteral
#define TclReleaseLiteral \
	(tclCompileStubsPtr->tclReleaseLiteral) /* 30 */
#endif
#ifndef TclSetCmdNameObj
#define TclSetCmdNameObj \
	(tclCompileStubsPtr->tclSetCmdNameObj) /* 31 */
#endif

#endif /* defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _TCLINTDECLS */
