#!/bin/sh
case $1 in
start)
	if [ -f /usr/local/libexec/rskkserv ]; then
		echo -n ' rskkserv: '
		/usr/local/libexec/rskkserv --verbose
	fi
	;;
stop)
	pidfile=/var/run/rskkserv.pid
	if [ -f $pidfile ]; then
	    kill `cat $pidfile` && echo -n ' rskkserv'
	    /bin/rm $pidfile
	else
	    echo ' rskkserv: not running'
	fi
	;;
*)
	echo "usage: $0 {start|stop}" 1>&2
	;;
esac
