/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class MatrixViewer
extends Frame
implements ScrollBoss {
    boolean fComponentsAdjusted = false;
    SETISupport boss;
    MtxCanvas maincanvas;
    MenuBar mainMenuBar;
    Menu menu1;
    MenuItem miExportCSV;
    MenuItem miExportTAB;
    MenuItem miExportHTM;
    MenuItem miExit;
    MenuItem miAllCondOff;
    MenuItem miHide;
    MenuItem miSortAsc;
    MenuItem miSortDes;
    MenuItem miTitleRight;
    MenuItem miTitleLeft;
    MenuItem miCutOff;
    MenuItem miEditCond;
    PopupMenu pmenu;
    Menu show_sub;
    FileDialog exportFileDialog;
    CondInputDialog cdipDialog;
    GScroll hbar;
    GScroll vbar;
    boolean startUpFlag = true;
    MxPrefValue pref = FileAnalyzer.readMxPrefs();

    public MatrixViewer(SETISupport sETISupport) {
        this.boss = sETISupport;
        this.initLayout();
        this.setData();
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
    }

    public void setData() {
        Vector vector = new Vector();
        this.boss.setMxData(vector);
        this.maincanvas.setData(vector);
    }

    public void initLayout() {
        this.setTitle("SETI@Support Data Table");
        Rectangle rectangle = this.pref.getBound();
        int n = rectangle.width;
        int n2 = rectangle.height;
        ((Component)this).setLocation(rectangle.x, rectangle.y);
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        ((Component)this).setSize(n, n2);
        this.maincanvas = new MtxCanvas(this, this.pref);
        this.add("Center", this.maincanvas);
        this.hbar = new GScroll(this, 0);
        this.hbar.setUnitIncrement(1);
        this.vbar = new GScroll(this, 1);
        this.vbar.setUnitIncrement(1);
        this.add("East", this.vbar);
        this.add("South", this.hbar);
        this.mainMenuBar = new MenuBar();
        this.menu1 = new Menu("File");
        Menu menu = new Menu("Export  FIle..", true);
        this.miExportCSV = new MenuItem("CSV");
        menu.add(this.miExportCSV);
        this.miExportTAB = new MenuItem("Tab separator");
        menu.add(this.miExportTAB);
        this.miExportHTM = new MenuItem("HTML");
        menu.add(this.miExportHTM);
        this.menu1.add(menu);
        this.menu1.addSeparator();
        this.miExit = new MenuItem("Close");
        this.menu1.add(this.miExit);
        Menu menu2 = new Menu("Setting");
        this.show_sub = new Menu("Show..");
        menu2.add(this.show_sub);
        this.updateShowMenu();
        this.miAllCondOff = new MenuItem("Turn All Condition off");
        menu2.add(this.miAllCondOff);
        this.mainMenuBar.add(this.menu1);
        this.mainMenuBar.add(menu2);
        this.setMenuBar(this.mainMenuBar);
        this.pmenu = new PopupMenu();
        this.miHide = new MenuItem("Hide");
        this.miSortAsc = new MenuItem("Sort Asc");
        this.miSortDes = new MenuItem("Sort Des");
        this.miTitleRight = new MenuItem("Move Title Right");
        this.miTitleLeft = new MenuItem("Move Title Left");
        this.miCutOff = new MenuItem("nodata");
        this.miEditCond = new MenuItem("Edit Condition..");
        this.pmenu.add(this.miHide);
        this.pmenu.add(this.miTitleRight);
        this.pmenu.add(this.miTitleLeft);
        this.pmenu.add(this.miSortAsc);
        this.pmenu.add(this.miSortDes);
        this.pmenu.add(this.miEditCond);
        this.pmenu.add(this.miCutOff);
        this.maincanvas.add(this.pmenu);
        SymAction symAction = new SymAction();
        this.miExit.addActionListener(symAction);
        this.miAllCondOff.addActionListener(symAction);
        this.miHide.addActionListener(symAction);
        this.miSortAsc.addActionListener(symAction);
        this.miSortDes.addActionListener(symAction);
        this.miTitleRight.addActionListener(symAction);
        this.miTitleLeft.addActionListener(symAction);
        this.miExportCSV.addActionListener(symAction);
        this.miExportTAB.addActionListener(symAction);
        this.miExportHTM.addActionListener(symAction);
        this.miCutOff.addActionListener(symAction);
        this.miEditCond.addActionListener(symAction);
        this.exportFileDialog = new FileDialog((Frame)this, "Please specify file name", 1);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + dimension.width, this.getInsets().top + this.getInsets().bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    void miEditCond_Action(ActionEvent actionEvent) {
        TitleData titleData = this.maincanvas.getSelectedTd();
        String string = this.miCutOff.getLabel();
        if (this.getCutOffState()) {
            string = string.substring(1);
        }
        this.cdipDialog = titleData.getTitle().equals("No") ? new CondInputDialog(this, "Input Condition", string, this.getCutOffState(), false) : new CondInputDialog(this, "Input Condition", string, this.getCutOffState(), true);
        Dimension dimension = this.getSize();
        ((Component)this.cdipDialog).setLocation(dimension.width / 3, dimension.height / 3);
        this.cdipDialog.show();
    }

    private void miCutOff_Action(ActionEvent actionEvent) {
        boolean bl = this.getCutOffState();
        boolean bl2 = !bl;
        this.setCutOffState(bl2);
        this.maincanvas.setCutCondState(bl2);
    }

    private boolean getCutOffState() {
        String string = this.miCutOff.getLabel();
        return string.charAt(0) == '*';
    }

    private void setCutOffState(boolean bl) {
        boolean bl2 = this.getCutOffState();
        if (bl == bl2) {
            return;
        }
        String string = this.miCutOff.getLabel();
        string = bl ? "*" + string : string.substring(1);
        this.miCutOff.setLabel(string);
    }

    void setCondition(int n, String string, boolean bl) {
        this.maincanvas.setCondition(new CutCond(n, string, bl));
    }

    void delCondition() {
        this.maincanvas.delCondition();
    }

    void miShow_Action(MenuItem menuItem) {
        this.maincanvas.showTitle(menuItem.getLabel());
        this.updateShowMenu();
    }

    void miAllCondOff_Action(ActionEvent actionEvent) {
        this.maincanvas.disableAllConditions();
    }

    void miExit_Action(ActionEvent actionEvent) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    void miHide_Action(ActionEvent actionEvent) {
        this.maincanvas.hideCurrentTitle();
        this.updateShowMenu();
    }

    void miSort_Action(ActionEvent actionEvent, int n) {
        this.maincanvas.miSortData(n);
    }

    void miTitleMove_Action(int n) {
        this.maincanvas.moveTitle(n);
    }

    void miExport_Action(int n) {
        int n2 = this.exportFileDialog.getMode();
        String string = this.exportFileDialog.getTitle();
        String string2 = this.exportFileDialog.getDirectory();
        String string3 = "";
        if (n == 0) {
            string3 = "tst_data.csv";
        } else if (n == 1) {
            string3 = "tst_data.txt";
        } else if (n == 2) {
            string3 = "tst_data.htm";
        }
        this.exportFileDialog = new FileDialog((Frame)this, string, n2);
        this.exportFileDialog.setDirectory(string2);
        this.exportFileDialog.setFile(string3);
        this.exportFileDialog.show();
        String string4 = this.exportFileDialog.getDirectory();
        String string5 = this.exportFileDialog.getFile();
        if (string4 == null || string5 == null) {
            return;
        }
        this.maincanvas.exportCSVFile(String.valueOf(string4) + string5, n);
    }

    private void updateShowMenu() {
        Vector vector = new Vector();
        this.maincanvas.listHiddenTitle(vector);
        this.show_sub.removeAll();
        SymAction symAction = new SymAction();
        int n = 0;
        while (n < vector.size()) {
            TitleData titleData = (TitleData)vector.elementAt(n);
            MenuItem menuItem = new MenuItem(titleData.getTitle());
            menuItem.addActionListener(symAction);
            this.show_sub.add(menuItem);
            ++n;
        }
    }

    public void popupmenu(Point point, TitleData titleData) {
        this.pmenu.removeAll();
        String string = titleData.getTitle();
        if (!string.equals(GLBX.TITLE[1]) && !string.equals("No")) {
            this.pmenu.add(this.miSortDes);
            this.pmenu.add(this.miSortAsc);
            this.pmenu.addSeparator();
        }
        if (!string.equals("No")) {
            this.pmenu.add(this.miHide);
            this.miHide.setLabel("Hide '" + titleData.getTitle() + "'");
        }
        if (!string.equals("No")) {
            if (this.maincanvas.titleMoveEligible(0)) {
                this.pmenu.add(this.miTitleRight);
            }
            if (this.maincanvas.titleMoveEligible(1)) {
                this.pmenu.add(this.miTitleLeft);
            }
        }
        if (string.equals(GLBX.TITLE[0]) || string.equals(GLBX.TITLE[2]) || string.equals(GLBX.TITLE[5]) || string.equals(GLBX.TITLE[6]) || string.equals(GLBX.TITLE[7]) || string.equals(GLBX.TITLE[8]) || string.equals(GLBX.TITLE[9]) || string.equals(GLBX.TITLE[10]) || string.equals(GLBX.TITLE[11]) || string.equals("No")) {
            CutCond cutCond;
            if (this.pmenu.getItemCount() > 0) {
                this.pmenu.addSeparator();
            }
            if ((cutCond = titleData.getCutCond()) == null) {
                this.miEditCond.setLabel("Add condition..");
            } else {
                this.miEditCond.setLabel("Edit condition..");
                String string2 = cutCond.getStr();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string3 = String.valueOf(stringTokenizer.nextToken()) + " " + stringTokenizer.nextToken() + " " + stringTokenizer.nextToken();
                this.miCutOff.setLabel(string3);
                this.setCutOffState(cutCond.getState());
                this.pmenu.add(this.miCutOff);
            }
            this.pmenu.add(this.miEditCond);
        }
        this.pmenu.show(this.maincanvas, point.x, point.y);
    }

    void MatrixViewer_WindowClosing(WindowEvent windowEvent) {
        this.maincanvas.setBoundPref(this.getBounds());
        this.maincanvas.fileOutPref();
        this.maincanvas.clearData();
        this.setVisible(false);
        this.dispose();
        this.boss.clearMx();
    }

    public void changeScroll(int n, int n2) {
        if (n2 == 0) {
            this.maincanvas.setTIndex(n);
        } else {
            this.maincanvas.setDIndex(n);
        }
    }

    public void update(boolean bl) {
        if (bl) {
            this.maincanvas.setSortRequiredFlag(true);
        }
        this.maincanvas.repaint();
    }

    public void updateWithScroll() {
        this.maincanvas.setToSelectedData();
        this.maincanvas.repaint();
    }

    void MatrixViewer_WindowDeactivated(WindowEvent windowEvent) {
        this.boss.SETISupport_WindowDeactivated(null);
    }

    public void selectFromMx(MxData mxData) {
        this.boss.selectFromOutside(mxData.getRd(), false);
    }

    public void resetScrollBar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.maincanvas.getHFinishFlag()) {
            this.remove(this.hbar);
        } else {
            this.add("South", this.hbar);
            this.hbar.setValues(n, n2, n3, n4);
        }
        if (this.maincanvas.getVFinishFlag()) {
            this.remove(this.vbar);
        } else {
            this.add("East", this.vbar);
            this.vbar.setValues(n5, n6, n7, n8);
        }
        this.validate();
        this.doLayout();
    }

    void MatrixViewer_ComponentShown(ComponentEvent componentEvent) {
        if (this.startUpFlag) {
            this.startUpFlag = false;
            Rectangle rectangle = this.pref.getBound();
            if (rectangle.width != 0 && rectangle.height != 0) {
                ((Component)this).setSize(new Dimension(rectangle.width, rectangle.height));
                ((Component)this).setLocation(rectangle.x, rectangle.y);
            } else {
                ((Component)this).setLocation(80, 80);
                ((Component)this).setSize(new Dimension(600, 200));
            }
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MatrixViewer.this.miExit) {
                MatrixViewer.this.MatrixViewer_WindowClosing(null);
            } else if (object == MatrixViewer.this.miHide) {
                MatrixViewer.this.miHide_Action(actionEvent);
            } else if (object == MatrixViewer.this.miAllCondOff) {
                MatrixViewer.this.miAllCondOff_Action(actionEvent);
            } else if (object == MatrixViewer.this.miSortAsc) {
                MatrixViewer.this.miSort_Action(actionEvent, 0);
            } else if (object == MatrixViewer.this.miSortDes) {
                MatrixViewer.this.miSort_Action(actionEvent, 1);
            } else if (object == MatrixViewer.this.miTitleRight) {
                MatrixViewer.this.miTitleMove_Action(0);
            } else if (object == MatrixViewer.this.miTitleLeft) {
                MatrixViewer.this.miTitleMove_Action(1);
            } else if (object == MatrixViewer.this.miExportCSV) {
                MatrixViewer.this.miExport_Action(0);
            } else if (object == MatrixViewer.this.miExportTAB) {
                MatrixViewer.this.miExport_Action(1);
            } else if (object == MatrixViewer.this.miExportHTM) {
                MatrixViewer.this.miExport_Action(2);
            } else if (object == MatrixViewer.this.miEditCond) {
                MatrixViewer.this.miEditCond_Action(actionEvent);
            } else if (object == MatrixViewer.this.miCutOff) {
                MatrixViewer.this.miCutOff_Action(actionEvent);
            } else {
                int n = 0;
                while (n < MatrixViewer.this.show_sub.getItemCount()) {
                    MenuItem menuItem = MatrixViewer.this.show_sub.getItem(n);
                    if (object == menuItem) {
                        MatrixViewer.this.miShow_Action(menuItem);
                    }
                    ++n;
                }
            }
        }

        SymAction() {
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
        }

        SymItem() {
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowDeactivated(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == MatrixViewer.this) {
                MatrixViewer.this.MatrixViewer_WindowDeactivated(windowEvent);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == MatrixViewer.this) {
                MatrixViewer.this.MatrixViewer_WindowClosing(windowEvent);
            }
        }

        SymWindow() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentShown(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == MatrixViewer.this) {
                MatrixViewer.this.MatrixViewer_ComponentShown(componentEvent);
            }
        }

        SymComponent() {
        }
    }
}

