#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2001 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langengl.tcl
#  Last change:  22 November 2001
#
# French language file by Valre Robin (valere.robin@wanadoo.fr)
#  Last change by him:  11 November 2001
#  last input from him inserted:  22 November 2001
#

# file langengl.tcl is consulted first; no need for duplicating entries here

# only 3 chars long names; check also ALLMONTH in file gpsman
set MONTHNAMES "Jan Fev Mar Avr Mai Jun Jul Aou Sep Oct Nov Dec"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) km/h
set DLUNIT(KM,area) "km2"
set DLUNIT(NAUTMILE,dist) "mn"
set DLUNIT(NAUTMILE,area) "mn2"
set DLUNIT(NAUTMILE,speed) noeud

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)

set MESS(RTcomp) "#\tWP\t\t$DTUNIT\tdeg\m"
set MESS(TRcomp) "#\t$DTUNIT\t$DTUNIT\tm\th:m:s\t$SPUNIT\tdeg"
set MESS(WPNearest) "WP\t\t$DTUNIT\tdeg"

array set MESS {
    notleap   "YEAR0 dfinie comme %d n'est pas une anne bissextile"
    badscale   "Valeur errone pour l'chelle de la carte"
    oktoexit   "Ok pour quitter (les donnes non sauves vont tre perdues)"
    okclrmap   "Ok pour effacer la carte"
    namelgth   "Le nom ne doit pas dpasser %d caractres"
    cmmtlgth   "=== Un commentaire ne peut dpasser %d caractres"
    namevoid   "Le nom ne peut tre vide"
    baddate   "Mauvais date"
    badhdg   "Mauvais en-tte %s: doit tre %s ou +/-"
    badcoord   "Mauvais format ou interval de coordonnes: \"%s\" doit tre %s"
    outofrng   "Nombre non valide"
    UTMZN   "Doit tre une lettre parmi A..H, J..N, ou P..Z"
    badstrg "Caractre(s) erron(s)"
    strgvoid   "Une chine de caractre ne peut tre vide"
    nan   "\"%s\" n'est pas un nombre"
    written   "Ecrit par"
    undefWP   "L'itinraire %s a des points (WPs) non dfinis; non sauv ou export"
    bigRT   "Itinraire %s > nombre max; non export"
    unkndatum   "Donne inconnue"
    nogrids   "Grilles non implmentes"
    badcommdWP   "Mauvaise commande en chargeant les WPs; ligne"
    notabsWP   "Mauvaise dfinition d'un point d'itinraire; pas de tabulation, ligne"
    undefWP   "Rfrence  un point d'itinraire inconnu: %s; ligne %d"
    nofieldsWP   "Mauvais point d'itinraire, pas assez de champs; ligne"
    excfieldsWP  "Mauvais point d'itinraire, trop de champs; ligne"
    badWPsRT   "Route avec une liste de points d'itinraire errone; ligne"
    toomuchWPs   "Warning: plus de %d points dans l'itinraire"
    badcommdTP   "Mauvaise commande lors du chargement de TPs; ligne"
    badTP    "Mauvais point dans la trace; ligne"
    badTPsTR   "Trace avec une liste errone de points; ligne"
    noheader   "Le fichier ne commence pas par un en-tte"
    loaderr   "Erreur lors du chargement du fichier; ligne"
    unkncommd   "Commande errone lors du chargement du fichier; ligne"
    noformat   "Le fichier ne commence pas par une ligne Format"
    badformat   "Mauvaise ligne format"
    badRT   "Mauvaise dfinition de route; ligne"
    badRTargs   "Argument de route erron; ligne"
    badTR   "Mauvaise dfinition de trace; ligne"
    fileact   "%s le fichier de %s?"
    filexists   "Le fichier existe!"
    GPSok   "Connexion correcte"
    toomany   "Trop de %ss (> %d)"
    cantfgt   "Oubli impossible %s: appartient  un item de la carte"
    cantfgted   "Oubli impossible %s: en cours d'dition"
    cantmapRTunkn   "La route n'est pas sur la carte; pas d'info sur point d'itinraire"
    cantmapRTed   "La route n'est pas sur la carte; point d'itinraire en cours d'dition"
    cantrun   "Excution impossible"
    inprogr   "Operation en cours"
    cantread   "Lecture du fichier auxilliaire impossible"
    cantwrtopt   "Ecriture du fichier de prfrence impossible"
    voidRT   "La route ne contient pas de points"
    activeRT   "La route 0 est active; continuer?"
    voidTR   "La trace ne contient pas de points"
    idinuse   "Identificateur dj utilis"
    cantunmap  "Impossible d'liminer %s de la carte: appartient  un item de la carte"
    askrevert   "Retour aux donnes initiales?"
    askforget   "Oubli de ce %s?"
    notimpl   "Non implment"
    forgetall   "Oubli de tous les lments %s de la liste?"
    counted   "Il y a %d %ss defini(e)s"
    notlisted   "Item non list"
    wrgval   "Valeur errone pour"
    voidGR   "Le groupe n'a pas d'lment."
    initselfGR   "Le groupe se contient lui mme par"
    GRelout   "La commande pour GR est hors d'une dfinition; ligne"
    badGRels   "Groupe avec une mauvaise liste d'lments; ligne"
    badcommdGRel   "Commande errone lors du chargement d'lments GR; ligne"
    notypeforGRel   "Elment sans type; ligne"
    badGRel   "Mauvaise dfinition d'lment; ligne"
    check   "Connexion en cours de vrification"
    toomanyerr   "Erreurs trop nombreuses; abandon..."
    getWP   "Acquisition des points d'itinraire"
    getRT   "Acquisition des routes"
    getTR   "Acquisition des traces"
    putWP   "Chargement des points d'itinraire"
    putRT   "Chargement des poutes"
    putTR   "Chargement des traces"
    fillbuffWP  "Chargement des buffers de point d'itinraire"
    fillbuffRT  "Chargement des buffers de RT"
    noACKNAK  "Rception d'un paquet au lieu de ACK/NAK; vrifier la connexion GPS"
    badplatform   "Pas de port d'entre/sortie"
    badserial "Ouverture du port srie %s impossible"
    nodata    "Pas de %ss dans le rcepteur"
    badimage "Fichier image erron"
    mapaskWPs "Choisir les %d points d'itinraire  placer sur la carte"
    mapadjust "Placer les points d'itinraire sur la carte puis cliquer sur Ok"
    duplicate "%s est dj slectionn"
    clrcurrmap "Effacement de la carte courante?"
    cantfix "%d point sont ncessaires pour fixer la carte; commencer par charger ou dfinir des points d'itinraire"
    mbkbaddatum "Donnes absentes ou inconnues"
    mbkbadscale "L'chelle ne doit pas tre ngative"
    mbkbadat "Arguments errons"
    edityourrisk "Editez  vos risques!"
    okclrbkmap   "Ok pour effacer le fond de carte"
    okclrbkim    "Ok pour effacer l'image "
    badWPfield "Champs optionnel erron"
    badWPattr "Nom de champs optionnel inconnu"
    badSYMBOLcode "Code de symbole erron"
    badDISPOPTcode "Code d'option d'affichage erron"
    goingdown "Prfrences sauvegardes; redmarrer"
    putwhat "Ecriture de quel type d'item?"
    readwhat "Lecture de quel type d'item?"
    noWPinx "Trop de points d'itinraire pour le rcepteur"
    noICinx "Trops d'icnes pour le rcepteur"
    getIC "Rception des icones"
    serial1 "Prambule de l'en-tte erron"
    serial2 "Commande incorrecte"
    checksum1 "Checksum de l'en-tte erron"
    checksum2 "Checksum sur les donnes erron"
    receiver "Pas de liaison srie!"
    importonly1 "Importation d'une seule sorte de donnes"
    exportonly1 "Exportation d'une seule sorte de donnes"
    outdatedprefs "Fichier des prfrences prim ;  vrifier maintenant"
    mustchoose1type "Il faut slectionner une seule sorte d'item"
    nosuchitems "Pas d'lment correspondant  la description"
    resultsin "Rsultats de recherche dans le groupe"
    badWP "point d'itinraire non dfini ou absent"
    badangle "L'angle doit tre compris entre 0 et 360 degrs"
    georefhow  "Mthode de go-rfrencement"
    cantsolve  "Rsolution de l'quation impossible"
    transfcantscale "Echelle absente dans la transformation courante"
    oldfilefmt "Format de fichier prim ; merci de sauver dans le nouveau format de fichier"
    unknProj "Projection de la carte inconnue"
    unknTransf "Transformation de la carte inconnue"
    badProjargs "Arguments de la projection errons"
    badTransfargs "Arguments de la transformation errones"
    badfield "Mauvaise paire d'attribut-valeur"
    badattr "Mauvais nom d'attribut"
    missattrs "Argument manquant"
    mbkbadproj "Projection de la carte errone"
    mbkbadtransf "Transformation de la carte errone"
    notUTMproj "Information sauvegarde pour l'UTM; continuer avec la projection"
    projchg    "Merci de confirmer les paramtres de la projection"
    badparam "Valeur errone pour %s"
    connectedto "Connect  %s"
    recnotsuppd "Modle du rcepteur non support"
    gotprots "Dfinition du protocole reue"
    badprots "Dfinition du protocole erron"
    defprots "Utilisation de la table du protocole"
    nohidden "Suppression des donnes caches?"
    badRS "Itinraire en dehors de la route dfinie; ligne"
    badWPsRSs "Itinraire avant le premier ou aprs le dernier WP; ligne"
    windowdestr "La fentre at dtruite!"
    badhidden "Format errone pour les donnes caches"
    replname "Remplacer \"%s\" par un nom ayant au plus %d caractres parmis \"%s\""
    badalt "Valeur errone pour l'altitude"
    baddistunit "Unit de distance errone pour l'chelle de la carte dans le fichier de prfrences"
    badgridzone "Zone de grille errone"
    outofgrid "Position en dehors du domaine de la grille"
    timeoffnotint "La valeur de temps doit tre un entier"
    cantchkprot "Vrification impossible avec le protocole courant"
    mustconn1st "Connection avec le rcepteur  vrifier"
    rltmnotsupp "Journalisation en temps rel non supporte par ce rcepteur"
    createdir "Crer un rpertoire %s et redmarrer"
    oktomkdir "Accord pour crer le rpertoire %s?"
    projnameabbr "Donner un nom et un nom court  la nouvelle projection"
    abbrevinuse "Nom court dj pris"
    nameinuse "Nom dj pris"
    projinuse "La projection est dj utilise; les modifications vont tre perdues"
    gridneedsdatum "Dfinition de grille errone pour %s; donne non saisie"
    badgriddatum "La donne pour la grille %s doit tre %s"
    cantchggriddatum "La grille ncessite la donne %s"
    gridinuse "Grille utilise par %s, ne peut pas tre dtruite; continuer?"
    gridinusenochg "Grille utilise par %s; modification non prise en compte"
    cantwrtprgr "Ecriture impossible du fichier des projections utilisateur"
    cantwrtdtel "Ecriture impossible du fichier des donnes utilisateur"
    movingWP "Placer %s avec le bouton gauche\nAbandonner avec le bouton droit"
    missingdata "Pas assez de donnes!"
    needs1wp "L'itinraire doit contenir au moins un point"
    emptypos "Position avec des champs vides"
    cantwrtsstate "Ecriture impossible du fichier de sauvegarde d'tat: %s"
    cantrdsstate "Lecture impossible du fichier de sauvegarde d'tat: %s"
    corruptsstate "Fichier de sauvegarde d'tat corrompu: %s"
    editrisk "Editez  vos risques!"
    savestate "Sauvegarde de l'tat courant?"
    delsstate "Destruction des fichiers de sauvegarde d'tat?"
    badmapinfo "Mauvais fichier de paramtres de carte"
    badMHloc "Localisation Maidenhead errone"
    areais "L'aire du polygone (ne se recoupant pas) est %.3f%s"
    areatoosmall "L'aire est trop petite (<0.001 km2)"
    projarea "Calcul de l'aire projete"
    selfintsct "Rptition d'un point : la route ne peut pas se recouper!"
    badinvmdist "Erreur d'approximation dans l'inversion de la distance mridienne"
    badinvproj "Erreur d'approximation dans l'inversion de la projection %s"
    negdlatlong "Interval lat/long erron : ne peut tre negative!"
    allundef "Dfinitions manquantes pour les points du groupe"
}

set TXT(RTcompflds) "# WP {$DTUNIT} deg m stage label"
set TXT(TRcompflds) "TP {$DTUNIT} {$DTUNIT} m h:m:s {$SPUNIT} deg"
set TXT(starttoend) "Dpart: vers la fin %s $DTUNIT;"
set TXT(startmax) "max %s $DTUNIT;"
set TXT(WPnearflds) "WP {$DTUNIT} deg"
set TXT(within) "Parmi (${DTUNIT}s)"
set TXT(between) "Entre (${DTUNIT}s)"

array set TXT {
    GMtit   "GPS Manager - version"
    exit   Fin
    map   Carte
    load   Chargement
    loadfrm   "Chargement depuis"
    save   Sauvegarde
    saveels "Sauvegarde des lments"
    saveto   "Sauvegarde vers"
    clear   Effacement
    clearall   "Effacement complet"
    newWP   "Nouveau point d'itinraire"
    newRT   "Nouvelle route"
    newTR   "Nouvelle trace"
    newGR   "Nouveau groupe"
    import   Importation
    importfrm   "Importation depuis"
    export   Exportation
    exportels "Exportation depuis"
    exportto   "Exportation vers"
    count   Comptage
    trueN   "Nord vrai"
    automagn   "Auto Magnetique"
    usrdef   "Dfini par l'utilisateur"
    nameWP   Point
    nameRT   Route
    nameTR   Trace
    nameGR   Groupe
    namePlot Plot
    nameMap  Carte
    nameRTComp   "Calcul de route"
    nameTRComp   "Calcul de trace"
    GPSrec   "Rcepteur GPS"
    turnoff   "Arrt"
    get   Prendre
    put   Mettre
    all   Tout
    select   Slectionner
    selection   Slection
    options   Options
    DMS   DMS
    DMM   DMM
    DDD   DDD
    UTM/UPS   UTM/UPS
    message   Message
    cancel   Abandon
    file   Fichier
    ovwrt   Ecraser
    app   Ajout
    onligne   "en ligne"
    offligne  "hors ligne"
    check   Vrifier
    create   Crer
    revert   Rtablir
    colour   couleur
    grey   gris
    mono   mono
    portr   portrait
    landsc   paysage
    legend   Lgende
    incscale   "Inclure l'chelle"
    more   Plus
    waypoint   Waypoint
    name   Nom
    created Cr
    cmmt   Commentaire
    withWP  "Avec ce point d'itinraire:"
    displ   "Afficher sur la carte"
    startRT "Dmarrage de la route"
    route   Route
    number   Nombre
    insb   "Insrer avant"
    insa   "Insrer apprs"
    del   Dtruire
    repl   "Remplacer par"
    comp   Calculer
    RTcomp   "Calcul de route"
    savecomp "Sauvegarde du calcul"
    totdst   "Distance totale"
    tottime   "Temps total"
    track   Trace
    chophd   "Supprimer avant"
    choptl   "Supprimer aprs"
    incb   "Inclure avant"
    mkRT   "Faire une route"
    date   Date
    newdate   "Nouvelle date pour le point suivant"
    endprTR   "Fin de la trace prcdente"
    begnxt   "Dbut du prochain"
    date1st   "Date du premier point du prochain"
    TRcomp   "Calcul de trace"
    avgsp   "Vitesse moyenne"
    maxsp   "Vitesse maximale"
    minsp   "Vitesse minimale"
    lat   Lat
    long   Long
    ze   ZE
    zn   ZN
    eastng   "Est"
    nrthng   "Nord"
    zone   Zone
    change   Changer
    forget   Oublier
    others   Autres
    opt_Interf  Interface
    optLANG   Langage
    optISOLATIN1   "Caractres composs"
    optDELETE   "DEL efface le dernier caractre"
    optMWINDOWSCONF  "Fentre principale"
    optGPSREC   "Modle de GPS"
    opt_GPSRecConf   "Paramtres du rcepteur"
    optNAMELENGTH   "Longueur maximale pour un nom"
    optINTERVAL "Intervale d'chantillonage"
    optCOMMENTLENGTH   "Longueur maximale pour un commentaire"
    optMAXWPOINTS   "Nombre max des points d'itinraire"
    optMAXROUTES   "Mombre max de routes"
    optMAXWPINROUTE   "Nombre max de points dans une route"
    optMAXTPOINTS   "Nombre max de points dans une trace"
    optCREATIONDATE   "L'enregistrement a une date de cration"
    optNOLOWERCASE   "L'enregistrement n'a pas de minuscule"
    optDEFAULTSYMBOL "Symbole par dfaut pour un point d'itinraire"
    optDEFAULTDISPOPT "Option d'affichage par dfaut pour un point d'itinraire"
    opt_Data "Donnes"
    optEQNAMEDATA "Donne avec le mme nom"
    optKEEPHIDDEN "Garder les donnes caches"
    optDatum   Donne
    optTimeOffset   "Dcalage horaire"
    optACCFORMULAE "Formule juste"
    optASKPROJPARAMS "Confirmer les paramtres de projection"
    optBalloonHelp "Bulles d'aide"
    optNumberingTracks "Numrotation des points des traces"
    opt_Formats   "Units et formats"
    optDISTUNIT   "Distance"
    KM    km
    NAUTMILE    "mile nautique"
    STATMILE    "mile"
    optPositionFormat   "Format de position"
    optDateFormat   "Format de date"
    opt_Geom   "Gometrie des fentres"
    opt_MapGeom   "Gomtrie des cartes"
    optMAPWIDTH   "Largeur de carte"
    optMAPHEIGHT   "Hauteur de la carte"
    optMAPSCLENGTH   "Longueur de l'chelle"
    optMAPSCALE   "Echelle de la carte"
    optMAXMENUITEMS   "Nombre maximum d'lments par menu"
    optLPOSX   "Abscisse de la fentre des listes"
    optLPOSY   "Ordonne de la fentre des listes"
    optMPOSX   "Abscisse de la fentre de la carte"
    optMPOSY   "Ordonne de la fentre de la carte"
    optRPOSX   "Abscisse de la fentre du rcepteur"
    optRPOSY   "Ordonne de la fentre du rcepteur"
    optEPOSX   "Abscisse de la fentre d'erreur"
    optEPOSY   "Ordonne de la fentre d'erreur"
    optDPOSX   "Abscisse de la fentre de dialogue"
    optDPOSY   "Ordonne de la fentre de dialogue"
    optDPOSRTMAP "Position de la fentre de route par rapport  la carte"
    optLISTWIDTH   "Largeur de la liste"
    optLISTHEIGHT  "Hauteur de la liste"
    optCOLOUR   Couleurs
    optCOLOUR,fg   "Premier plan"
    optCOLOUR,bg   "Fond d'cran"
    optCOLOUR,messbg   "Fond pour les erreurs"
    optCOLOUR,confbg   "Fond pour les confirmations"
    optCOLOUR,selbg    "Fond pour les slections"
    optCOLOUR,dialbg   "Fond pour les saisies"
    optCOLOUR,offligne "Rcepteur hors ligne"
    optCOLOUR,onligne  "Rcepteur en ligne"
    optCOLOUR,check    "Bouton  cocher slectionn"
    optCOLOUR,ballbg   "Fond pour les bulles d'aide"
    optCOLOUR,ballfg   "Premier plan pour les bulles d'aide"
    optMAPCOLOUR  "Couleur pour la carte"
    optMAPCOLOUR,mapsel   "Item slectionn"
    optMAPCOLOUR,WP   "Points sur la carte"
    optMAPCOLOUR,RT   "Routes sur la carte"
    optMAPCOLOUR,mkRT "Routes dfinies sur la carte"
    optMAPCOLOUR,TR   "Traces sur la carte"
    optMAPCOLOUR,TP   "Point d'itinraire sur la carte"
    optMAPCOLOUR,mapleg   "Lgende de la carte"
    optMAPCOLOUR,anim  "Animation sur la carte"
    optMAPCOLOUR,emptygrid  "Image vide"
    optMAPCOLOUR,fullgrid   "Image existante"
    opt_Files Fichiers
    optDEFSPORT "Port Srie"
    optSAVESTATE "Sauvegarde de l'tat en quittant"
    optDELSTATE "Destruction des fichiers aprs avoir restaur l'tat"
    optPERMS   "Permission du fichier"
    optPAPERSIZE "Taille du papier"
    red   Rouge
    green   Vert
    blue   Bleu
    owner   Propritaire
    permgroup   Groupe
    others   Autres
    fread   Lecture
    fwrite   Ecriture
    fexec   Excution
    YYYYMMDD   AAAAMMJJ
    MMDDYYYY   MMJJAAAA
    DDMMMYYYY   JJMMAAAA
    mainwd   "Fentre principate"
    distazim   "Distance et direction"
    nearestWPs   "Points les plus proches"
    fromto   "De %s  %s"
    degrees   degrs
    nameWPDistBear   "distance et direction"
    nameWPNearest   "point d'itinraire le plus prs"
    inrect   "Dans le rectangle"
    forthisWP   "pour ce point d'itinraire"
    formappedWPs   "pour les points d'itinraire sur la carte"
    group   Groupe
    element   Elment
    insert   Insertion
    joinGR   "Joindre au groupe"
    TRtoRT   "Conversion de trace en route"
    TRRTnpoints   "Nombre de points  garder"
    TRRTdispl   "Affichage de la route"
    TRTRdispl   "Affichage de la trace"
    WP   WP
    RT   RT
    TR   TR
    GR   GR
    commrec   "Communication avec le rcepteur"
    abort   Arrt
    ACKs   ACKs
    NAKs   NAKs
    packets   paquets
    unnamed   "(inconnu)"
    fromTR    "Depuis la trace : %s"
    mapload "Image de go-rfrencement"
    loadmback Chargement
    savemback "Sauvegarde des informations de go-rfrencement"
    chgmback Modification
    clearmback Effacement
    backgrnd Fond
    nameMapBkInfo "Fond de carte"
    nameMapInfo "Paramtres de la carte"
    mpbkchg "Changement du fond"
    mpbkgrcs "Position de la grille"
    nameImage Image
    symbol Symbole
    SYCATgeneral "Utilisation gnrale"
    SYCATland Terre
    SYCATwater Eau
    SYCATaviation Aviation
    SY1st_aid "Premiers secours"
    SYWP_buoy_white "Boue, blanche"
    SYWP_dot "WP"
    SYairport "Aroport"
    SYamusement_park "Parc de loisirs"
    SYanchor "Ancre"
    SYavn_danger "Danger"
    SYavn_faf "Premier point d'approche"
    SYavn_lom "Localizer outer marker"
    SYavn_map "Point d'approche manqu"
    SYavn_ndb "Signal ND"
    SYavn_tacan "TACAN"
    SYavn_vor "VHF omni-range"
    SYavn_vordme "VOR-DME"
    SYavn_vortac "VOR/TACAN"
    SYball "Balle"
    SYbeach "Plage"
    SYbell "Cloche"
    SYboat "Bateau"
    SYboat_ramp "Embarcadre"
    SYborder "Poste frontire"
    SYbowling "Bowling"
    SYbridge "Pont"
    SYbuilding "Btiment"
    SYbuoy_amber "Boue, ambre"
    SYbuoy_black "Boue, noire"
    SYbuoy_blue "Boue, bleue"
    SYbuoy_green "Boue, verte"
    SYbuoy_green_red "Boue, verte et rouge"
    SYbuoy_green_white "Boue, verte et blanche"
    SYbuoy_orange "Boue, orange"
    SYbuoy_red "Boue, rouge"
    SYbuoy_red_green "Boue, rouge et verte"
    SYbuoy_red_white "Boue, rouge et blanche"
    SYbuoy_violet "Boue, violette"
    SYbuoy_white "Boue, blanche"
    SYbuoy_white_green "Boue, blanche et verte"
    SYbuoy_white_red "Boue, blanche et rouge"
    SYcamping "Campement"
    SYcapitol_city "Ville, toile"
    SYcar "Vhicule"
    SYcar_rental "Location de vhicule"
    SYcar_repair "Garage"
    SYcasino "Casino"
    SYcastle "Chateau"
    SYcemetery "Cimetire"
    SYchapel "Chapelle"
    SYchurch "Eglise"
    SYcircle_x "Rond avec un X"
    SYcivil "Civil location"
    SYcontrolled "Aire rglemente"
    SYcrossing "Croisement"
    SYdam "Barrage"
    SYdanger "Danger"
    SYdeer "Cerf"
    SYdiamond_green "Diamant, vert"
    SYdiamond_red "Diamant, rouge"
    SYdiver_down_1 "Plonge 1"
    SYdiver_down_2 "Plonge 2"
    SYdollar "Dollar"
    SYdot "Point"
    SYdrinking_water "Eau potable"
    SYduck "Canard"
    SYelevation "Altitude"
    SYexit_no_serv "Sortie, pas de service"
    SYexit "Sortie"
    SYfactory "Usine"
    SYfastfood "Restauration rapide"
    SYfish "Poisson"
    SYfitness "Remise en forme"
    SYflag "Drapeau"
    SYfreeway "Autoroute"
    SYfuel "Carburant"
    SYfuel_store "Carburant et magasin"
    SYgeo_name_land "Nom topographique, naturel"
    SYgeo_name_man "Nom topographique, artificiel"
    SYgeo_name_water "Nom topographique, eau"
    SYglider "Planeur"
    SYgolf "Golf"
    SYheliport "Heliport"
    SYhorn "Corne"
    SYhouse "Maison"
    SYice_skating "Patinoire"
    SYinfo "Point d'information"
    SYintersection "Intersection"
    SYis_highway "Autoroute"
    SYknife_fork "Nourriture"
    SYladder "Echelle"
    SYlanding "Atterissage"
    SYlarge_city "Ville, grande"
    SYlarge_exit_ns "Sortie sans service, grande"
    SYlarge_ramp_int "Ramp int, large"
    SYlevee "Digue"
    SYlight "Lumire"
    SYlodging "Hbergement"
    SYmany_fish "Banc de poisson"
    SYmany_tracks "Nombreuses traces"
    SYmark_x "Marque, x"
    SYmedium_city "Ville, moyenne"
    SYmile_marker "Point kilomtrique"
    SYmilitary "Zone militaire"
    SYmine "Mine"
    SYMOB "Homme  la mer"
    SYmonument "Monument"
    SYmountains "Montagnes"
    SYmovie "Cinma"
    SYmug "Mug"
    SYmuseum "Muse"
    SYntl_highway "Autoroute nationale"
    SYnull "(transparent)"
    SYnull_2 "(vide)"
    SYoil_field "Puit de ptroile"
    SYparachute "Parachute"
    SYpark "Parc"
    SYparking "Parking"
    SYpharmacy "Pharmacie"
    SYphone "Tlphone"
    SYpicnic "Pique nique"
    SYpizza "Pizza"
    SYpolice "Police"
    SYpost_office "Bureau de poste"
    SYprivate "Proprit prive"
    SYradio_beacon "Signal radio"
    SYramp_int "Croisement de rampes"
    SYrestricted "Aire  accs restreint"
    SYrestrooms "WC"
    SYRV_park "Camping car"
    SYscenic "Point de vue"
    SYschool "Ecole"
    SYseaplane "Base d'hydravion"
    SYshopping_cart "Commerces"
    SYshort_tower "Tour, courte"
    SYshowers "Douches"
    SYskiing "Ski nautique"
    SYskull "Skull"
    SYsmall_city "Ville, petite"
    SYsnow_skiing "Ski"
    SYsoft_field "Zone meuble"
    SYsquare_green "Carr, vert"
    SYsquare_red "Carr, rouge"
    SYst_highway "Autoroute rgionale"
    SYstadium "Stade"
    SYstore "Magasin"
    SYstreet_int "Croisement de rues"
    SYsummit "Sommet"
    SYswimming "Natation"
    SYtake_off "Dcollage"
    SYtall_tower "Tour, haute"
    SYtheater "Thatre"
    SYtoll "Page"
    SYtow_truck "Dpaneuse"
    SYtraceback "Itinraire de retour"
    SYtracks "Traces"
    SYtrail_head "Dpart de piste"
    SYtree "Arbre"
    SYtruck_stop "Arrt pour camion"
    SYtunnel "Tunnel"
    SYultralight "ULM"
    SYus_highway "Autoroute nord amricaine"
    SYweight_station "Station de pesage"
    SYwreck "Epave"
    SYzoo "Zoo"
    psvisible "Seul lment visible"
    DISPsymbol "Symbole uniquement"
    DISPs_name "Symbole et nom"
    DISPs_comment "Symbole et commentaire"
    DISPname "Nom uniquement"
    DISPcomment "Commentaire uniquement"
    dispopt "Affichage"
    mapitems "Affichage des lments sur la carte"
    nameIC "Icone"
    prod "Produit"
    WPCapac "Capacit en points d'itinraire"
    ICCapac "Capacit en icones"
    RTCapac "Capacit en route"
    TRCapac "Capacit en traces"
    protcl "Protocole"
    ICGraph "Graphique des icones"
    WPperRT "Point par route"
    notinGR "n'est pas dans le (sous-)groupe"
    onlyinGR "uniquement dans le (sous-)groupe"
    loadgrels "Chargement des lments"
    importgrels "Importation des lments"
    about "Informations sur GPSman..."
    contrib "   Contributions de"
    errorsto "Error reports to:"
    obsTRToRT "WPs created by a TR to RT conversion"
    nameLists "Listes"
    nameData "Donnes"
    MWCmap "Cartes"
    MWClists "Listes"
    MWCsingle "Fentre simple"
    search "Recherche"
    rmrk "NB"
    closeto "Fermer vers"
    with "Avec"
    srchres "Trouv"
    database "Base de donnes"
    where "O"
    what "Quoi"
    list "liste"
    distance "Distance"
    fromWP "depuis le point"
    fromPos "depuis la position"
    azimuth "Direction"
    any "indiffrente"
    opening "Ouverture"
    suggested "suggr"
    another "Un autre"
    srchdd1 "Recherche sur"
    srchdd2Data "tous les lments"
    srchdd2GR "Groupe(s)"
    from "depuis"
    started "partant de "
    transf  "Transformation de coordonnes"
    TRNSFAffine    "Affine"
    TRNSFAffineConf  "Affine Conforme"
    TRNSFNoRot      "Conforme sans rotation"
    projection "Projection"
    lat0  "Latitude du centre"
    long0 "Longitude centre"
    lat1  "Latitude du 1er parallle"
    lat2  "Latitude du 2eme parallle"
    latF  "Latitude de l'origine errone"
    longF "Longitude de l'origine errone"
    gkklong0 "Longitude du centre"
    kkjplong0 "Longitude du centre"
    k0 "Facteur d'chelle"
    PRJUTM "UTM/UPS"
    PRJTM "Mercator Transverse"
    PRJCMP "Carte Militaire Portugaise"
    PRJBNG "Grille Nationale Britannique"
    PRJBWI "British West Indies"
    PRJITM "Mercator Transverse Irlandaise"
    PRJGKK "Grille Allemande"
    PRJLCC1 "Lambert Conique Conf 1"
    PRJLCC2 "Lambert Conique Conf 2"
    PRJKKJP "Grille Finlandaise de base"
    PRJKKJY "Grille Finlandaise uniforme"
    PRJSEG "Grille Sudoise"
    PRJMerc1 "Mercator 1"
    PRJMerc2 "Mercator 2"
    PRJCS "Cassini-Soldner"
    dontaskagain "Ne plus demander"
    rename "Utiliser le nouveau nom"
    oname "Nom d'origine"
    never "Jamais"
    ask "Demander"
    always "Toujours"
    stage "Etape"
    label "Etiquette"
    alt "Altitude"
    locate "Localiser"
    animation  Animation
    fast Rapide
    slow Lent
    start "Dpart"
    pause Pause
    speed Vitesse
    centred "Centrage"
    state "Etat"
    animinit "dbut / fin"
    animon "en cours"
    animpause "en pause"
    animabort "arrt"
    realtimelog "Traage en temps rel"
    garmin Garmin
    nmea "NMEA 0183"
    stext "Simple texte"
    simul "Simulateur"
    lowrance Lowrance
    getlog "Charger le journal"
    stop "Arrt"
    dolog "Enregistrement"
    show Montrer
    hide Cacher
    posfixerror erreur
    posfix_  ?
    posfix2D 2D
    posfix3D 3D
    posfix2D-diff "2D d"
    posfix3D-diff "3D d"
    posfixGPS GPS
    posfixDGPS DGPS
    posfixAuto ok
    posfixsimul simul
    restart "Redmarrage"
    mkTR "Faire une route"
    PVTflds "# t lat long alt fix EPE EPH EPV vel_x vel_y vel_z CMG"
    namePVTData "Journaliser les donnes"
    mkavgWP "Calcul du point moyen"
    move Dplacer
    define Dfinir
    open Ouvrir
    defs "Definitions"
    baseproj "Projection de base"
    abbrev "Nom court"
    grid Grille
    use Utiliser
    unit Unit
    feasting "Erreur sur l'axe Est-Ouest"
    fnorthing "Erreur sur l'axe Nord-Sud"
    bounds Limite
    max Max
    min Min
    easting "Axe Est-Ouest"
    northing "Axe Nord-Sud"
    fixeddatum "donnes fixes"
    elevation Altitude
    usewps "Utiliser les points d'itinraire"
    chgpfrmt "Changer le format de position"
    here Ici
    atprevwp "Au point prcdent"
    prevwp "Point prcdent"
    firstwp "Premier point"
    chglstrs "Editer la phase prcdente"
    chgnxtrs "Editer la phase suivante"
    contnend "Ajouter en fin"
    closemenu "Fermeture du menu"
    ellpsd Ellipsoide
    datum Datum
    userdefs "Dfinitions de l'utilisateur"
    edmap "Editer sur la carte"
    actual "rel"
    rtimelogintv "Interval de journalisation"
    inca "Inclure aprs"
    invert "Inverser"
    recwindow "Fentre du rcepteur"
    volume "Volume"
    latS "Lat Sud"
    latN "Lat Nord"
    longW "Long Ouest"
    longE "Long Est"
    no Non
    PRJAPOLY "Polyconique amricaine - American Polyconic"
    computations Calculs
    comparea "Calcul de l'aire"
    optTRNUMBERINTVL "Intervalle pour la numrotation des points sur les traces"
    cluster "Groupement de points"
    mkclusters "Construction de groupements"
    dlat "Interval de latitude"
    dlong "Interval de longitude"
    collcntr "Dtection des centres..."
    compclstr "Calcul des groupements..."
    crtgclstrgrs "Cration des groupes..."
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    DMS   DMS
    DMM   DMM
    DDD   DDD
    UTM/UPS   UTM/UPS
    WP   WP
    RT   RT
    TR   TR
    GR   GR
}
