#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2001 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langport.tcl
#  Last change:  14 November 2001
#

# file langengl.tcl is consulted first; no need for duplicating entries here

# only 3 chars long names; check also ALLMONTH in file gpsman
set MONTHNAMES "Jan Fev Mar Abr Mai Jun Jul Ago Set Out Nov Dez"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) km/h
set DLUNIT(KM,area) km2
set DLUNIT(NAUTMILE,dist) "ml mar"
set DLUNIT(NAUTMILE,subdist) "p"
set DLUNIT(NAUTMILE,speed) ns
set DLUNIT(NAUTMILE,area) km2
set DLUNIT(STATMILE,dist) "ml ter"
set DLUNIT(STATMILE,subdist) "p"
set DLUNIT(STATMILE,speed) mph
set DLUNIT(STATMILE,area) seco

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)
set ARUNIT $DLUNIT($DISTUNIT,area)

set MESS(RTcomp) "#\tPT\t\t$DTUNIT\tgraus\tm"
set MESS(TRcomp) "#\t$DTUNIT\t$DTUNIT\tm\th:m:s\t$SPUNIT\tgraus"
set MESS(WPNearest) "PT\t\t$DTUNIT\tgrau"

array set MESS {
    notleap   "YEAR0 definido como %d no  bissexto"
    badscale   "Valor errado para escala do mapa"
    oktoexit   "Ok para terminar (dados no guardados perder-se-o)"
    okclrmap   "Ok para apagar o mapa"
    namelgth   "Nome no poder ter mais de %d caracteres"
    cmmtlgth   "Comentrio nao poder ter mais de %d caracteres"
    namevoid   "Nome no pode ser vazio"
    baddate   "Data errada"
    badhdg   "Direco errada %s: tem de ser %s ou +/-"
    badcoord "Coordenada com valor ou formato errado: \"%s\" tem de ser em %s"
    outofrng   "Nmero fora dos limites"
    UTMZN   "Tem de ser uma letra em A..H, J..N, ou P..Z"
    badstrg   "Caracter(es) errado(s)"
    strgvoid   "Tem de ter pelo menos um caracter"
    nan   "\"%s\" no  um nmero"
    written   "Escrito por"
    undefWP   "Rota %s tem pontos no definidos; no guardada/exportada"
    bigRT   "Rota %s > mximo; no exportada"
    unkndatum   "Datum desconhecido"
    nogrids   "Grelhas no implementadas"
    badcommdWP   "Comando errado ao ler pontos; linha"
    notabsWP   "Ponto mal definido (sem tabulaes); linha"
    undefWP   "Referncia a ponto desconhecido: %s; linha %d"
    nofieldsWP   "Ponto mal definido (faltam campos); linha"
    excfieldsWP   "Ponto mal definido (campos a mais); linha"
    badWPsRT   "Rota com lista errada de pontos; linha"
    toomuchWPs   "Aviso: mais de %d pontos numa rota"
    badcommdTP   "Comando errado ao ler pontos de trajecto; linha"
    badTP   "Ponto errado num trajecto; linha"
    badTPsTR   "Trajecto com lista errada de pontos; linha"
    noheader   "Ficheiro nao tem cabealho"
    loaderr   "Erro ao ler ficheiro; linha"
    unkncommd   "Comando desconhecido ao ler ficheiro; linha"
    noformat   "Ficheiro nao comea com linha de formato"
    badformat   "Especificao de formato errada"
    badRT   "Rota mal especificada; linha"
    badRTargs   "Parmetros errados para rota; linha"
    badTR   "Trajecto mal especificado; linha"
    fileact   "%s qual ficheiro de %s?"
    filexists   "Ficheiro existente!"
    GPSok   "Ligao ok"
    toomany   "Demasiados %ss (> %d)"
    cantfgt   "No posso esquecer %s: pertence a algo desenhado"
    cantfgted   "No posso esquecer %s: est a ser editado"
    cantmapRTunkn   "Rota no desenhada; ponto desconhecido"
    cantmapRTed   "Rota no desenhada; ponto em edio"
    cantrun   "No posso executar"
    inprogr   "Operao j iniciada"
    cantread   "No posso ler do ficheiro auxiliar"
    cantwrtopt   "No posso escrever no ficheiro de opes"
    voidRT   "Rota sem pontos"
    activeRT   "Rota 0  a rota activa; continuar?"
    voidTR   "Trajecto sem pontos"
    idinuse   "Identificador j usado"
    cantunmap   "Impossvel apagar %s; pertence a algo desenhado"
    askrevert   "Voltar aos dados iniciais?"
    askforget   "Esquecer de vez %s?"
    notimpl   "No implementado"
    forgetall   "Esquecer tudo na lista de %ss?"
    counted   "Tem %d %ss na lista"
    notlisted   "Item no listado"
    wrgval   "Valor errado p/"
    voidGR   "Grupo sem elementos"
    initselfGR   "Grupo contem-se a si prprio atravs de"
    GRelout   "Comando para elemento fora de definio de GR; linha"
    badGRels   "Grupo com lista de elementos errada; linha"
    badcommdGRel   "Comando errado ao ler elementos de grupo; linha"
    notypeforGRel   "Elemento sem tipo; linha"
    badGRel   "Definio de elemento errada; linha"
    check   "Tentando ligar"
    toomanyerr   "Erros a mais; desistindo..."
    getWP   "A buscar Pontos"
    getRT   "A buscar Rotas"
    getTR   "A buscar Trajectos"
    putWP   "A pr Pontos"
    putRT   "A pr Rotas"
    putTR   "A pr Trajectos"
    fillbuffWP  "A carregar depsito de PTs"
    fillbuffRT  "A carregar depsito de RTs"
    noACKNAK  "Pacote recebido em vez de ACK/NAK; verifique a ligao ao GPS"
    badplatform   "Esta plataforma no suporta E/S na porta srie"
    badserial "Sem acesso  porta srie %s"
    nodata    "O receptor no tem %ss"
    badimage "Ficheiro de imagem no aceite"
    mapaskWPs "Escolha %d PTs a colocar no mapa"
    mapadjust "Coloque os PTs no mapa; carregue depois em Ok"
    duplicate "%s j escolhido"
    clrcurrmap "Apagar mapa existente?"
    cantfix "Precisa %d PTs para fixar o mapa; defina-os ou carregue-os primeiro"
    mbkbaddatum "Sem datum vlido"
    mbkbadscale "A escala no pode ser negativa"
    mbkbadat "Argumentos errados"
    edityourrisk "Mude  sua responsabilidade!"
    okclrbkmap   "Ok para apagar fundo do mapa"
    okclrbkim   "Ok para apagar imagem em"
    badWPfield "Campo opcional invlido"
    badWPattr "Nome de campo opcional desconhecido"
    badSYMBOLcode "Cdigo de smbolo errado"
    badDISPOPTcode "Cdigo errado de forma de mostrar errado"
    goingdown "Opes guardadas; recomear"
    putwhat "Colocar que tipos de dados?"
    readwhat "Procurar que tipos de dados?"
    noWPinx "Demasiados PTs para o receptor"
    noICinx "Demasiados ICs para o receptor"
    getIC "A buscar cones"
    serial1 "Prembulo de cabealho errado"
    serial2 "Recebido comando errado"
    checksum1 "Soma de verificao do cabealho errada"
    checksum2 "Soma de verificao de dados errada"
    receiver "Sem ligao srie!" 
    importonly1 "S pode importar 1 tipo de dados"
    exportonly1 "S pode exportar 1 tipo de dados"
    outdatedprefs "Ficheiro de opes tem de ser actualizado"
    mustchoose1type "Seleccione ao menos 1 tipo de dados"
    nosuchitems "Nenhum elemento com essa descrio"
    resultsin "Resultados no Grupo"
    badWP "Ponto em falta ou por definir"
    badangle "ngulo tem de ser >0 e <360 graus"
    georefhow  "Mtodo para geo-referenciar"
    cantsolve  "Equaes sem soluo"
    transfcantscale "Transformao no permite alterar escala"
    oldfilefmt "Formato antigo; p.f. guardar no formato novo!"
    unknProj "Projeco desconhecida"
    unknTransf "Transformao desconhecida"
    badProjargs "Parmetros de projeco errados"
    badTransfargs "Parmetros de transformao errados"
    badfield "Par atributo=valor errado"
    badattr "Nome de atributo errado"
    missattrs "Faltam atributo(s)"
    mbkbadproj "Projeco errada"
    mbkbadtransf "Transformao errada"
    notUTMproj "Informao para UTM; continuar com projeco"
    projchg    "Rever parmetros da projeco"
    badparam "Valor errado para %s"
    connectedto "Ligado a um %s"
    recnotsuppd "Modelo no reconhecido"
    gotprots "Recebida info sobre protocolos"
    badprots "Info sobre protocolos errada"
    defprots "A usar tabela de protocolos"
    nohidden "Esquecer dados ocultos?"
    badRS "Etapa de rota fora de definio de RT; linha"
    badWPsRSs "Etapa antes do primeiro ou depois do ltimo PT; linha"
    windowdestr "A janela foi destruda!"
    badhidden "Formato errado em valor oculto"
    replname "Substitua \"%s\" por nome com at %d dos caracteres seguintes: %s"
    badalt "Valor errado para altitude"
    baddistunit "Unidade de distncia errada para escala do mapa nas opes"
    badgridzone "Zona de grelha errada"
    outofgrid "Posio no coberta pela grelha"
    timeoffnotint "Diferena horria tem de ser inteira"
    cantchkprot "Este protocolo no permite verificar"
    mustconn1st "Primeiro verifique a ligao ao receptor"
    rltmnotsupp "Este protocolo neste receptor no faz registo em tempo real"
    createdir "Precisa criar a pasta %s e depois recomece"
    oktomkdir "Posso criar o directrio %s?"
    projnameabbr " favor dar nome e abreviatura para a projeco a criar"
    abbrevinuse "Abreviatura j usada"
    nameinuse "Nome j usado"
    projinuse "Projeco est a ser usada; alteraes no tero efeito"
    gridneedsdatum "Definio errada da grelha %s; datum por definir"
    badgriddatum "O datum para a grelha %s tem de ser %s"
    cantchggriddatum "Tem de usar o datum %s para esta grelha"
    gridinuse "Grelha usada por %s, no poder ser apagada; continuar?"
    gridinusenochg "Grelha usada por %s; alteraes sem efeito"
    cantwrtprgr "No posso escrever no ficheiro de projeces"
    cantwrtdtel "No posso escrever no ficheiro de datums"
    movingWP "Colocar %s com boto esquerdo\nCancelar com boto direito"
    missingdata "Informao insuficiente!"
    needs1wp "A rota tem que ter 1 ponto pelo menos"
    emptypos "Posio com campo(s) vazio(s)"
    cantwrtsstate "No posso escrever no ficheiro de estado: %s"
    cantrdsstate "No posso ler do ficheiro de estado: %s"
    corruptsstate "Ficheiro de estado %s com erros"
    editrisk "Modifique  sua responsabilidade!"
    savestate "Guardar o estado?"
    delsstate "Apagar os ficheiros de estado?"
    badmapinfo "Erros no ficheiro de parmetros de mapa"
    badMHloc "Posio Maidenhead errada"
    areais "rea do polgono (que no se intersecta): %.3f%s"
    areatoosmall "A rea  demasiado pequena (<%s km2)"
    projarea "Calculando a rea projecteda"
    selfintsct "PTs repetidos: a RT no se pode intersectar!"
    badinvmdist "Erro de aproximao ao inverter distncia sobre meridiano"
    badinvproj "Erro de aproximao ao inverter a projeco %s"
    negdlatlong "Diferena em lat/long no pode ser negativa!"
    allundef "Nenhum dos PTs do GR est definido"
}

set TXT(RTcompflds) "# PT {$DTUNIT} grau m etapa etiq"
set TXT(TRcompflds) "PTR {$DTUNIT} {$DTUNIT} m h:m:s {$SPUNIT} grau"
set TXT(starttoend) "Incio: ao fim %s $DTUNIT;"
set TXT(startmax) "no mx %s $DTUNIT;"
set TXT(WPnearflds) "PT {$DTUNIT} grau"
set TXT(within) "At (${DTUNIT}s)"
set TXT(between) "Entre (${DTUNIT}s)"

array set TXT {
    GMtit   "GPS Manager - verso"
    exit   Terminar
    map   Mapa
    load   Lr
    loadfrm   "Lr de"
    save   Guardar
    saveels "Guardar elementos"
    saveto   "Guardar em"
    clear   Limpar
    clearall   "Limpar tudo"
    newWP   "Novo PT"
    newRT   "Nova RT"
    newTR   "Novo TR"
    newGR   "Novo GR"
    import   Importar
    importfrm   "Importar de"
    export   Exportar
    exportels "Exportar elementos"
    exportto   "Exportar para"
    count   Contar
    trueN   "Norte Geogr"
    automagn   "Declin Auto"
    usrdef   "Def Ut"
    nameWP   Ponto
    nameRT   Rota
    nameTR   Traj
    nameGR   Grupo
    namePlot   Grfico
    nameMap   Mapa
    nameRTComp   "Clculo para Rota"
    nameTRComp   "Clculo para Trajecto"
    GPSrec   "Receptor GPS"
    turnoff   Desligar
    get   Buscar
    put   Colocar
    all   Tudo
    select   Escolher
    selection   Escolha
    options   Opes
    DMS   GMS
    DMM   GMM
    DDD   GGG
    message   Mensagem
    cancel   Cancelar
    file   Ficheiro
    ovwrt   Destrur
    app   Acrescentar
    online   "em linha"
    offline   "sem linha"
    check   Testar
    create   Criar 
    revert   Recomear
    colour   cres
    grey   cinzentos
    mono   mono
    portr   "ao alto"
    landsc   "ao baixo"
    legend   Legenda
    incscale   "Inclur escala"
    more   "(cont.)"
    waypoint   Ponto
    name   Nome
    created   "Criado em"
    cmmt   Comentrio
    withWP  "Com este PT:"
    displ   "Desenhar no mapa"
    startRT "Iniciar RT"
    route   Rota
    number   Nmero
    insb   "Inserir antes"
    insa   "Inserir depois"
    del   Apagar
    repl   "Substitur por"
    comp   Calcular
    RTcomp   "Clculos para rota"
    savecomp "Guardar clculos"
    totdst   "Distncia total"
    tottime   "Tempo total"
    track   Trajecto
    chophd   "Cortar cabea"
    choptl   "Cortar cauda"
    incb   "Incluir antes"
    mkRT   "Transf em Rota"
    date   Data
    newdate   "Nova data para o ponto seguinte"
    endprTR   "Fim do trajecto anterior"
    begnxt   "Incio do seguinte"
    date1st   "Data para 1o ponto do seguinte"
    TRcomp   "Clculos para trajecto"
    avgsp   "Veloc mdia"
    maxsp   "Veloc max"
    minsp   "Veloc min"
    lat   Lat
    long   Long
    ze   ZE
    zn   ZN
    eastng   x
    nrthng   y
    zone   Zona
    change   Mudar
    forget   Esquecer
    others   Outros
    optLANG   Lngua
    optISOLATIN1   "Acentos e cedilha"
    optDELETE   "DEL apaga ltimo caracter"
    optMWINDOWSCONF  "Janela principal"
    optGPSREC   "Modelo do GPS"
    opt_GPSRecConf   "Parmetros do Receptor"
    optNAMELENGTH   "Compr mx p/ nomes"
    optINTERVAL "Intervalo de amostragem"
    optCOMMENTLENGTH   "Compr mx p/ comentrios"
    optMAXWPOINTS   "No. mx de Pontos"
    optMAXROUTES   "No. mx de Rotas"
    optMAXWPINROUTE   "No. mx de PTs numa Rota"
    optMAXTPOINTS   "No. mx de pontos de Traj"
    optCREATIONDATE   "Rec usa data de criao"
    optNOLOWERCASE   "Rec no usa minsculas"
    optDEFAULTSYMBOL "Smbolo habitual de PT"
    optDEFAULTDISPOPT "Forma habitual de mostrar PT"
    opt_Data "Dados"
    optEQNAMEDATA "Dados c/ o mesmo nome"
    optKEEPHIDDEN "Manter dados ocultos"
    optDatum   Datum
    optTimeOffset   "Dif horria"
    optACCFORMULAE "Frmulas de maior preciso"
    optASKPROJPARAMS "Rever parmetros da projeco"
    optBalloonHelp "Bales de ajuda"
    optTRNUMBERINTVL "Mostrar nmero de PT de TR cada"
    opt_Formats   "Unidades e formatos"
    optDISTUNIT   "Distncia"
    KM    km
    NAUTMILE    "milha nutica"
    STATMILE    "milha terrestre"
    optPositionFormat   "Formato p/ posies"
    optDateFormat   "Formato p/ datas"
    opt_Geom   "Geometria p/ janelas"
    opt_MapGeom   "Geometria do mapa"
    optMAPWIDTH   "Larg do mapa"
    optMAPHEIGHT   "Alt do mapa"
    optMAPSCLENGTH   "Compr escala do mapa"
    optMAPSCALE   "Escala do mapa"
    optMAXMENUITEMS   "No. mx de itens em menu"
    optLPOSX   "Pos horiz jan de listas"
    optLPOSY   "Pos vert jan de listas"
    optMPOSX   "Pos horiz jan do mapa"
    optMPOSY   "Pos vert jan do mapa"
    optRPOSX   "Pos horiz jan do rec"
    optRPOSY   "Pos vert jan do rec"
    optEPOSX   "Pos horiz janela de erro"
    optEPOSY   "Pos vert janela de erro"
    optDPOSX   "Pos horiz dilogo"
    optDPOSY   "Pos vert dilogo"
    optDPOSRTMAP "Ajuste janela RT/mapa"
    optLISTWIDTH   "Larg de lista"
    optLISTHEIGHT   "Alt de lista"
    optCOLOUR   Cres
    optCOLOUR,fg   Frente
    optCOLOUR,bg   Fundo
    optCOLOUR,messbg   "Fundo p/ erros"
    optCOLOUR,confbg   "Fundo p/ confirmaes"
    optCOLOUR,selbg   "Fundo p/ seleces"
    optCOLOUR,dialbg   "Fundo p/ perguntas"
    optCOLOUR,offline   "Receptor s/ linha"
    optCOLOUR,online   "Receptor em linha"
    optCOLOUR,check   "Boto seleccionado"
    optCOLOUR,ballbg   "Fundo p/ ajuda"
    optCOLOUR,ballfg   "Frente p/ ajuda"
    optMAPCOLOUR  "Cres no mapa"
    optMAPCOLOUR,mapsel   "Item selecc no mapa"
    optMAPCOLOUR,WP   "Pontos no mapa"
    optMAPCOLOUR,RT   "Rotas no mapa"
    optMAPCOLOUR,mkRT "Rota definida no mapa"
    optMAPCOLOUR,TR   "Trajectos no mapa"
    optMAPCOLOUR,TP   "Pontos de traj no mapa"
    optMAPCOLOUR,mapleg   "Legendas no mapa"
    optMAPCOLOUR,anim "Animao no mapa"
    optMAPCOLOUR,emptygrid  "Sem imagem"
    optMAPCOLOUR,fullgrid   "Com imagem"
    opt_Files Ficheiros
    optDEFSPORT "Porta srie"
    optSAVESTATE "Guardar estado ao sair"
    optDELSTATE "Apagar ficheiros de estado"
    optPERMS   "Permisses de ficheiro"
    optPAPERSIZE "Tamanho do papel"
    red   Verm
    green   Verde
    blue   Azul
    owner   Dono
    permgroup   Grupo
    others   Outros
    fread   Lr
    fwrite   Escr
    fexec   Exec
    YYYYMMDD   AAAAMMDD
    MMDDYYYY   MMDDAAAA
    DDMMMYYYY   DDMMMAAAA
    mainwd   "Janela principal"
    distazim   "Dist e azimute"
    nearestWPs   "PTs prximos"
    fromto   "De %s para %s"
    degrees   graus
    nameWPDistBear   "dist e azimute"
    nameWPNearest   "PTs prximos"
    inrect   "No rectngulo"
    forthisWP   "para este PT"
    formappedWPs   "para PTs no mapa"
    group   Grupo
    element   Elemento
    insert   Inserir
    joinGR   "Juntar Grupo"
    TRtoRT   "Converso de TR para RT"
    TRRTnpoints   "No. de pontos a reter"
    TRRTdispl   "Desenhar RT j"
    TRTRdispl   "Desenhar TR j"
    WP   PT
    RT   RT
    TR   TR
    GR   GR
    commrec   "Comunicao com receptor"
    abort   Desistir
    ACKs   ACKs
    NAKs   NAKs
    packets   pacotes
    unnamed   "(por definir)"
    fromTR    "Do TR: %s"
    mapload "Geo-ref imagem"
    loadmback Ler
    savemback "Guardar geo-ref"
    chgmback Alterar
    clearmback Limpar
    backgrnd Fundo
    nameMapBkInfo "Info sobre fundo"
    nameMapInfo "Parmetros do mapa"
    mpbkchg "Alterar fundo"
    mpbkgrcs "Posio na grelha"
    nameImage Imagem
    symbol Smbolo
    SYCATgeneral Genrico
    SYCATland Terrestre
    SYCATwater Aqutico
    SYCATaviation Aviao
    SY1st_aid "Primeiros socorros"
    SYWP_buoy_white "Bia, branca"
    SYWP_dot "Ponto"
    SYairport "Aeroporto"
    SYamusement_park "Parque de diverses"
    SYanchor "ncora"
    SYavn_danger "Perigo (av)"
    SYball "Bola"
    SYbeach "Praia"
    SYbell "Sino"
    SYboat "Barco"
    SYboat_ramp "Rampa p/ barcos"
    SYborder "Fronteira"
    SYbridge "Ponte"
    SYbuilding "Prdio"
    SYbuoy_amber "Bia, mbar"
    SYbuoy_black "Bia, preta"
    SYbuoy_blue "Bia, azul"
    SYbuoy_green "Bia, verde"
    SYbuoy_green_red "Bia, verde vermelha"
    SYbuoy_green_white "Bia, verde branca"
    SYbuoy_orange "Bia, laranja"
    SYbuoy_red "Bia, vermelha"
    SYbuoy_red_green "Bia, vermelha verde"
    SYbuoy_red_white "Bia, vermelha branca"
    SYbuoy_violet "Bia, violeta"
    SYbuoy_white "Bia, branca"
    SYbuoy_white_green "Bia, branca verde"
    SYbuoy_white_red "Bia, branca vermelha"
    SYcamping "Campismo"
    SYcapitol_city "Cidade, estrela"
    SYcar "Automvel"
    SYcar_rental "Aluguer de automveis"
    SYcar_repair "Oficina de automveis"
    SYcasino "Casino"
    SYcastle "Castelo"
    SYcemetery "Cemitrio"
    SYchapel "Capela"
    SYchurch "Igreja"
    SYcircle_x "Crculo com X"
    SYcivil "Instalaes civis"
    SYcrossing "Passadeira"
    SYdam "Barragem"
    SYdanger "Perigo"
    SYdeer "Veado"
    SYdiamond_green "Losango, verde"
    SYdiamond_red "Losango, vermelho"
    SYdiver_down_2 "Mergulhador 2"
    SYdiver_down_1 "Mergulhador 1"
    SYdollar "Dolar"
    SYdot "Ponto"
    SYdrinking_water "gua potvel"
    SYduck "Pato"
    SYelevation "Ponto alto"
    SYexit "Sada"
    SYexit_no_serv "Sada s/ servios"
    SYfactory "Fbrica"
    SYfish "Peixe"
    SYfitness "Ginstica"
    SYflag "Bandeira"
    SYfreeway "Via rpida"
    SYfuel "Gasolina"
    SYfuel_store "Gasolina & loja"
    SYgeo_name_land "Nome geogr, terra"
    SYgeo_name_man "Nome geogr, homem"
    SYgeo_name_water "Nome geogr, gua"
    SYglider "Asa delta"
    SYheliport "Heliporto"
    SYhorn "Buzina"
    SYhouse "Casa"
    SYice_skating "Patinagem no gelo"
    SYinfo "Informao"
    SYintersection "Interseco"
    SYis_highway "Auto-estrada"
    SYknife_fork "Comida"
    SYladder "Escada"
    SYlanding "Aterragem"
    SYlarge_city "Cidade, grande"
    SYlarge_exit_ns "Sada s/ serv, grande"
    SYlarge_ramp_int "Cruz rampas, grande"
    SYlevee "Dique"
    SYlight "Farol"
    SYlodging "Alojamento"
    SYmany_fish "Cardume"
    SYmany_tracks "Muitos caminhos"
    SYmark_x "Marca, x"
    SYmedium_city "Cidade, mdia"
    SYmile_marker "Marco"
    SYmilitary "Instalaes militares"
    SYmine Mina
    SYMOB "Homem ao mar"
    SYmonument "Monumento"
    SYmountains "Montanhas"
    SYmovie "Cinema"
    SYmug "Caneca"
    SYmuseum "Museu"
    SYntl_highway "Auto-estrada nacional"
    SYnull "(transparente)"
    SYnull_2 "(vazio)"
    SYoil_field "Campo de petrleo"
    SYparachute "Paraquedas"
    SYpark "Parque"
    SYparking "Aparcamento"
    SYpharmacy "Farmcia"
    SYphone "Telefone"
    SYpicnic "Picnic"
    SYpolice "Polcia"
    SYpost_office "Correios"
    SYprivate "Campo privado"
    SYradio_beacon "Rdio farol"
    SYramp_int "Cruza/o rampas" 
    SYrestrooms "WC"
    SYscenic "Panorama"
    SYschool "Escola"
    SYseaplane "Base de hidro-avies"
    SYshopping_cart "Centro comercial"
    SYshort_tower "Torre, baixa"
    SYshowers "Chuveiros"
    SYskiing "Ski aqutico"
    SYskull "Caveira"
    SYsmall_city "Cidade, pequena"
    SYsnow_skiing "Ski de neve"
    SYsoft_field "Campo mole"
    SYsquare_green "Quadrado, verde"
    SYsquare_red "Quadrado, vermelho"
    SYst_highway "Auto-estrada estadual"
    SYstadium "Estdio"
    SYstore "Loja"
    SYstreet_int "Cruza/o ruas"
    SYsummit "Pico"
    SYswimming "Natao"
    SYtake_off "Descolagem"
    SYtall_tower "Torre, alta"
    SYtheater Teatro
    SYtoll Portagem
    SYtow_truck "Pronto-socorro"
    SYtraceback "Regresso"
    SYtracks "Caminhos"
    SYtrail_head "Incio de caminho"
    SYtree "rvore"
    SYtruck_stop "Paragem"
    SYtunnel "Tnel"
    SYultralight "Ultra-ligeiro"
    SYus_highway "Auto-estrada EUA"
    SYweight_station Bscula
    SYwreck "Destroos"
    SYzoo "Jardim zoolgico"
    psvisible "S a parte visvel"
    DISPsymbol "S smbolo"
    DISPs_name "S & nome"
    DISPs_comment "S & comentrio"
    DISPname "S nome"
    DISPcomment "S comentrio"
    dispopt Mostrar
    mapitems "Mostrar no mapa"
    nameIC cone
    prod Produto
    WPCapac "Mximo de Pontos"
    ICCapac "Mximo de Icones"
    RTCapac "Mximo de Rotas"
    TRCapac "Mximo de Trajectos"
    protcl "Protocolo"
    ICGraph "Smbolos para cones"
    WPperRT "Pontos por Rota"
    notinGR "no no (sub-)grupo"
    onlyinGR "s os do (sub-)grupo"
    loadgrels "Ler elementos"
    importgrels "Importar elementos"
    about "Sobre o GPSMan..."
    contrib "Com contribuies de"
    errorsto "Em caso de erro, contactar:"
    obsTRToRT "PTs criados pela converso de TR em RT"
    nameLists "Listas"
    nameData "Dados"
    MWCmap "Mapa"
    MWClists "Listas"
    MWCsingle "Janela nica"
    search "Procurar"
    rmrk "NB"
    closeto "Prximo de"
    with "Com"
    srchres "ACHADOS"
    srchresults "Resultado de procura"
    database "Base de dados"
    where "Onde"
    what "O qu"
    list "lista"
    distance "Distncia"
    fromWP "do Ponto"
    fromPos "da posio"
    azimuth "Azimute"
    any "qualquer"
    opening "Abertura"
    suggested "sugesto"
    another "Outra"
    srchdd1 "Procura em"
    srchdd2Data "todos os dados"
    srchdd2GR "Grupo(s)"
    from "de"
    started "iniciado em"
    transf  "Transf Coords"
    TRNSFAffine    "Afim"
    TRNSFAffineConf  "Afim Conforme"
    TRNSFNoRot      "Conf S/ Rot"
    projection "Projeco"
    lat0  "Lat central"
    long0 "Long central"
    lat1  "Lat 1.o paralelo"
    lat2  "Lat 2.o paralelo"
    latF  "Lat falsa origem"
    longF "Long falsa origem"
    gkklong0 "Long central"
    kkjplong0 "Long central"
    k0 "Factor de escala"
    PRJUTM "UTM/UPS"
    PRJTM "Transversa de Mercator"
    PRJCMP "Carta Militar Port"
    PRJBNG "Grelha Nac Britnica"
    PRJBWI "ndias Ocid Britnicas"
    PRJITM "Grelha TM Irlandesa"
    PRJGKK "Grelha Alem"
    PRJLCC1 "Lambert Cnica Conf 1"
    PRJLCC2 "Lambert Cnica Conf 2"
    PRJKKJP "Grelha Finlandesa Base"
    PRJKKJY "Grelha Finlandesa Unif"
    PRJSEG "Grelha Sueca"
    PRJAPOLY "Policnica Americana"
    dontaskagain "Deixar de confirmar"
    rename "Usar nome diferente"
    oname "Nome original"
    never "Nunca"
    ask "Perguntar"
    always "Sempre"
    stage "Etapa"
    label "Etiqueta"
    alt "Altitude"
    locate "Encontrar"
    animation  Animao
    fast Rpido
    slow Lento
    start Incio
    pause Pausa
    speed Velocidade
    centred "centrado"
    state Estado
    animinit "no incio/fim"
    animon "em curso"
    animpause "em pausa"
    animabort "sando"
    realtimelog "Registo de TR em tempo real"
    stext "Simple Text"
    simul "simulador"
    getlog Captar
    stop Parar
    dolog Registar
    show Mostrar
    hide Esconder
    posfixerror erro
    restart Recomear
    mkTR "Criar TR"
    PVTflds "# t lat long alt qual EPE EPH EPV vel_x vel_y vel_z CMG"
    namePVTData Registo
    mkavgWP "Criar PT mdio"
    move Recolocar
    define Definir
    open Abrir
    defs "Definies"
    baseproj "Projeco de base"
    abbrev Abreviatura
    grid Grelha
    use Usar
    unit Unidade
    feasting "Dist E falsa"
    fnorthing "Dist N falsa"
    bounds Limites
    easting "Dist E"
    northing "Dist N"
    fixeddatum "datum obrigatrio"
    elevation "Vista lateral"
    usewps "Usar PTs"
    chgpfrmt "Mudar formato posio"
    here Aqui
    atprevwp "No PT anterior"
    prevwp "PT anterior"
    firstwp "Primeiro PT"
    chglstrs "Editar etapa anterior"
    chgnxtrs "Editar etapa seguinte"
    contnend "Acrescentar no fim"
    closemenu "Fechar menu"
    ellpsd Elipsoide
    userdefs "Definies prprias"
    edmap "Editar no mapa"
    actual real
    rtimelogintv "Intervalo de tempo"
    inca "Incluir depois"
    invert   "Inverter"
    recwindow "Janela do receptor"
    no No
    computations Clculos
    comparea "Calcular rea"
    cluster Vizinhos
    centre  Centro
    mkclusters "Agrupar vizinhos"
    quadr Quadrngulo
    dlat "Diferena em latitude"
    dlong "Diferena em longitude"
    collcntr "A determinar centros..."
    compclstr "A agrupar vizinhos..."
    crtgclstrgrs "A criar grupos..."
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    GMS   DMS
    GMM   DMM
    GGG   DDD
    UTM/UPS   UTM/UPS
    PT   WP
    RT   RT
    TR   TR
    GR   GR
}
