#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2000 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: recdefs.tcl
#  Last change:  8 November 2000
#

# general definitions that may depend on the receiver trade-mark

  # assuming trade mark is the first list element in $GPSREC
set MYGPS [lindex $GPSREC 0]
set MYGPSMODEL [lreplace $GPSREC 0 0]

set TYPES {WP RT TR GR}
set PROCTYPES {GMWPoint GMRoute GMTrack GMGroup}
set MAPTYPES {WP RT TR}

set MAX(WP) $MAXWPOINTS
set MAX(RT) $MAXROUTES
set MAX(TR) $MAXTPOINTS

switch $MYGPS {
    Garmin {
	set RECTYPES {WP RT TR GR}
	# character set for names
	set RECNAMECHARS(Garmin) {^[-A-Z0-9]*$}
	set RECNAMECHARS(Garmin,mess) "A..Z, 0..9, \"-\""
	set UNDEFDATESECS [DateToSecs 1989 12 31 1 0 0]
	set RECPROTOCOLS {garmin nmea stext simul}
    }
    Lowrance {
	set RECTYPES {WP IC RT TR GR}
	set RECNAMECHARS(Lowrance) {^[-A-Z0-9.'()/]*$}
	set RECNAMECHARS(Lowrance,mess) \
		"A..Z, 0..9, \"-\", \"'\", \".\", \"/\", \"(\", \")\""
	# default values
	set MAX(IC) 100
	set MAXICG 100
	set UNDEFDATESECS 0
	set RECPROTOCOLS {lowrance nmea}
    }
}

