#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2003 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langdeutsch.tcl
#  Last change:  29 July 2002
# German language file by Andreas Lange (Andreas.C.Lange@GMX.de)
#  last input from him inserted: 31 January 2002
#
# Support by Sabine Broda (sbb@ncc.up.pt) since 2002
#  last input from her inserted: 28 February 2003

# file langengl.tcl is consulted first; no need for duplicating entries here


# only 3 chars long names; check also ALLMONTH in file gpsman
set MONTHNAMES "Jan Feb Mr Apr Mai Jun Jul Aug Sep Okt Nov Dez"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) km/h
set DLUNIT(KM,area) qkm
set DLUNIT(NAUTMILE,dist) sm
set DLUNIT(NAUTMILE,subdist) ft
set DLUNIT(NAUTMILE,speed) knt
set DLUNIT(NAUTMILE,area) qsm
set DLUNIT(STATMILE,dist) "us ml"
set DLUNIT(STATMILE,subdist) ft
set DLUNIT(STATMILE,speed) mph
set DLUNIT(STATMILE,area) qusml

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)

set MESS(RTcomp) "#\tWP\t\t$DTUNIT\tGrad\tm"
set MESS(TRcomp) "#\t$DTUNIT\t$DTUNIT\tm\th:m:s\t$SPUNIT\tGrad"
set MESS(WPNearest) "WP\t\t$DTUNIT\tGrad"

## comments to Mess
# namevoid     # "Name darf nicht ausgelassen werden"
# activeRT     # "Route 0 ist bereits aktiv; fortsetzen?"
# noACKNAK     # "Got packet when expecting ACK/NAK; check GPS connection"
# badplatform  # "No I/O with serial port in this platform"
# notUTMproj   # "Saved info for UTM; proceed with projection set to"


array set MESS {
    notleap   "YEAR0 definiert als %d ist kein Schaltjahr"
    badscale   "Ungltiger Wert fr Karten-Mastab"
    oktoexit   "Ok zum Beenden (nichtgespeicherte Daten gehen verloren)"
    okclrmap   "Ok zum Lschen der Karte"
    namelgth   "Der Name darf %d Zeichen nicht berschreiten"
    cmmtlgth   "Der Kommentar darf %d Zeichen nicht berschreiten"
    namevoid   "Der Name darf nicht leer sein"
    baddate   "Ungltiges Datum"
    badhdg   "Ungltige Richtungsangabe %s: mu entweder %s oder +/- sein"
    badcoord   "Ungltige Koordinaten oder falsches Format: \"%s\" mu sein %s"
    outofrng   "Zahl auerhalb des zulssigen Bereiches"
    UTMZN   "Mu ein Buchstabe von  A..H, J..N, oder P..Z sein"
    badstrg "Falsche(r) Buchstabe(n)"
    strgvoid   "Zeichenkette darf nicht leer sein"
    nan   "\"%s\" ist keine Zahl"
    written   "Geschrieben von"
    undefWP   "Route %s besitzt undefinierte WPe; nicht gespeichert/exportiert"
    bigRT   "Route %s > max. Anzahl; nicht exportiert"
    unkndatum   "Unbekanntes Datum"
    badcommdWP   "Ungltiger Befehl beim Laden der WPe; Zeile"
    notabsWP   "Ungltige WP Definition; keine Tabulatoren, Zeile"
    undefWP   "Referenz zu umbekanntem WP: %s; Zeile %d"
    nofieldsWP   "Ungltiger WP, nicht gengend Felder; Zeile"
    excfieldsWP  "Ungltiger WP, zu viele Felder; Zeile"
    badWPsRT   "RT mit ungltiger Wegpunkte-Liste; Zeile"
    toomuchWPs   "Warnung: mehr als %d WP in der RT"
    badcommdTP   "Ungltiger Befehl beim Laden der TPe; Zeile"
    badTP   "Ungltiger Punkt in TR; Zeile"
    badTPsTR   "TR mit ungltiger Punkte-Liste; Zeile"
    noheader   "Datei beginnt nicht mit Dateikopf"
    loaderr   "Fehler beim Laden der Datei; Zeile"
    unkncommd   "Unbekanntes Kommando beim Laden der Datei; Zeile"
    noformat   "Datei beginnt nicht mit Format-Zeile"
    badformat   "Ungltige Format-Zeile"
    badRT   "Ungltige RT Definition; Zeile"
    badRTargs   "Ungltige RT Argumente; Zeile"
    badTR   "Ungltige TR Definition; Zeile"
    fileact   "%s %s Datei?"
    filexists   "Datei existiert!"
    GPSok   "Verbindung ok"
    toomany   "Zu viele %se (> %d)"
    cantfgt   "Kann %s nicht lschen: gehrt zur Kartendarstellung"
    cantfgted   "Kann %s nicht lschen: ist in Bearbeitung"
    cantmapRTunkn   "Route nicht dargestellt; keine Informationen fr WP"
    cantmapRTed   "Route nicht dargestellt; WP ist in Bearbeitung"
    cantrun   "Nicht ausfhrbar"
    inprogr   "Operation wird bereits ausgefhrt"
    cantread   "Kann Hilfsdatei nicht lesen"
    cantwrtopt   "Kann Prferenz-Datei nicht schreiben"
    voidRT   "Route enthlt keine Wegpunkte"
    activeRT   "Route 0 ist aktiv; fortsetzen?" 
    voidTR   "Track enthlt keine Punkte"
    idinuse   "Bezeichner bereits vorhanden"
    cantunmap   "Kann %s nicht lschen: gehrt zu dargestelltem Inhalt"
    askrevert   "Auf ursprngliches Datum zurckstellen?"
    askforget   "%s lschen?"
    notimpl   "Nicht implementiert"
    forgetall   "Alle Punkte in Liste %s lschen?"
    counted   "Es sind %d %s(s/e) definiert"
    notlisted   "Punkt nicht aufgelistet"
    wrgval   "Falscher Wert fr"
    voidGR   "Gruppe hat keine Elemente"
    initselfGR   "Gruppe ist in sich selbst enthalten ber"
    GRelout   "Kommando fr das Element ist auerhalb der GR Definition; Zeile"
    badGRels   "Gruppe mit ungltiger Elemente-Liste; Zeile"
    badcommdGRel   "Ungltiges Kommando beim Laden der GR Elemente, Zeile"
    notypeforGRel   "Element ohne Typ-Angabe; Zeile"
    badGRel   "Ungltige Element-Definition; Zeile"
    check   "berprfe Verbindung"
    toomanyerr   "Zu viele Fehler, breche ab..."
    getWP   "Empfangen der Wegpunkte"
    getRT   "Empfangen der Routen"
    getTR   "Empfangen der Tracks"
    putWP   "Senden der Wegpunkte"
    putRT   "Senden der Routen"
    putTR   "Senden der Tracks"
    fillbuffWP  "Laden des WP Puffers"
    fillbuffRT  "Laden des RT Puffers"
    noACKNAK  "Paket erhalten, ACK/NAK erwartet; GPS Verbindung berprfen!"
    badplatform "Keine Ein-/Ausgabe auf der seriellen Schnittstelle auf dieser Platform"
    badserial "Kann serielle Schnittstelle %s nicht ffnen"
    nodata    "Kein %se im Empfnger"
    badimage "Ungltige Bild-Datei"
    mapadjust "Bitte plazieren Sie die WPe auf der Karte; Ok zum Beenden"
    duplicate "%s bereits ausgewhlt"
    clrcurrmap "Aktuelle Karte lschen?"
    mbkbaddatum "Kein oder unbekanntes Datum"
    mbkbadscale "Die Skala mu nicht-negativ sein"
    mbkbadat "Ungltige Argumente"
    edityourrisk "Bearbeiten auf eigene Gefahr!"
    okclrbkmap   "Ok zum Lschen des Karten-Hintergrundes"
    okclrbkim    "Ok zum Lschen des Bildes bei"
    badSYMBOLcode "Ungltiger Symbol-Code"
    badDISPOPTcode "Ungltiger Code der Anzeige-Optionen"
    goingdown "Prferenzen wurden gespeichert; bitte neu starten"
    putwhat "Welche Punkt-Typen speichern?"
    readwhat "Welche Punkt-Typen lesen?"
    noWPinx "Zu viele WPe fr diesen Empfnger"
    noICinx "Zu viele ICs fr diesen Empfnger"
    getIC "Lade Symbole / Zeichen"
    serial1 "Inkorrekter Vorspann"
    serial2 "Inkorrekter Befehl zurckgegeben"
    checksum1 "Inkorrekte Kopf-Prfsumme"
    checksum2 "Prfsummen-Fehler"
    receiver "Keine serielle Verbindung!"
    importonly1 "Kann nur einen Typ Daten importieren"
    exportonly1 "Kann nur einen Typ Daten exportieren"
    outdatedprefs "Prferenz-Datei berholt, bitte jetzt berprfen"
    mustchoose1type "Mindestens ein Punkt-Typ mu ausgewhlt werden."
    nosuchitems "Kein Punkt entspricht der Beschreibung"
    resultsin "Suchergebnisse in der Gruppe"
    badWP "WP nicht angegeben oder undefiniert"
    badangle "Winkel mu zwischen 0 und 360 Grad betragen"
    georefhow  "Methode der Geo-Referenzierung"
    cantsolve  "Kann Gleichungen nicht lsen"
    transfcantscale "Keine Skalierung mit dieser Transformation mglich"
    oldfilefmt "Altes Datei-Format; bitte unter neuem Format abspeichern!"
    unknProj "Unbekannte Kartenprojektion"
    unknTransf "Unbekannte Kartentransformation"
    badProjargs "Falsche Argumente fr die Projektion"
    badTransfargs "Falsche Argumente fr die Transformation"
    badfield "Ungltiges Attribut/Wert Paar"
    badattr "Ungltiger Attribut-Name"
    missattrs "Fehlende(s) Attribut(e)"
    mbkbadproj "Ungltige Kartenprojektion"
    mbkbadtransf "Ungltige Kartentransformation"
    notUTMproj "Info fr UTM gespeichert; Fortsetzen mit Projektion gesetzt auf"
    projchg    "Bitte besttigen Sie die Projektions-Parameter"
    badprojprm "Ungltiger Wert fr %s"
    connectedto "Verbunden mit %s"
    recnotsuppd "Empfnger-Modell nicht untersttzt"
    gotprots "Protokoll-Definition geladen"
    badprots "Ungltige Protokoll-Definition"
    defprots "Verwende die Protokoll-Tabelle"
    nohidden "Verborgene Daten verwerfen?"
    badRS "Etappe der Route auerhalb der Definition der RT; Zeile"
    badWPsRSs "RT Etappe vor dem ersten oder nach dem letzten WP; Zeile"
    windowdestr "Das Fenster wurde geschlossen!"
    badhidden "Ungltiges Format fr versteckten Wert"
    replname "Ersetzen Sie \"%s\" durch einen Namen mit hchstens %d der folgenden Buchstaben: %s"
    badalt "Ungltiger Wert fr Hhe"
    baddistunit "Ungltige Maeinheit fr Karten-Mastab in Prferenz-Datei"
    badgridzone "Ungltige Gitternetz-Zone"
    outofgrid "Position ausserhalb der Definition des Gitternetzes"
    cantchkprot "Kann mit diesem Protokoll nicht festgestellt werden"
    mustconn1st "Zuerst die Verbindung zum Empfnger berprfen"
    rltmnotsupp "Echtzeit-Aufzeichnung wird vom Protokoll dieses Empfngers nicht untersttzt"
    timeoffnotint "Zeitdifferenz muss eine Ganzzahl sein"
    abbrevinuse "Abkrzung bereits vergeben"
    nameinuse  "Name ist bereits vergeben"
    badgriddatum "Das Datum fr das Gitternetz %s ist %s"
    badparam "Falscher Wert fr %s"
    cantchggriddatum "Dieses Gitternetz bentigt das Datum %s"
    cantwrtprgr "Kann die nutzerdefinierte Projektionsdatei nicht schreiben"
    createdir "Bitte zuerst das Verzeichnis %s erzeugen und neu starten"
    cantwrtdtel  "Kann die nutzerdefinierte Datum Datei nicht schreiben"
    gridinuse "Das Gitternetz, von %s genutzt, kann nicht gelscht werden, trotzdem Fortsetzen?"
    gridinusenochg "Das Gitternetz wird von %s benutzt; keine nderungen eingetragen"
    gridneedsdatum "Falsche Definition fr das Gitternetz %s; kein Datum angegeben"
    oktomkdir "Soll das Verzeichnis %s angelegt werden?"
    projinuse "Die Projektion wird genutzt; die nderungen werden verworfen"
    projnameabbr "Bitte einen Namen und eine Abkrzung fr die neue Projektion eingeben"
    missingdata "Unzureichende Daten!"
    movingWP "Plazieren von %s mit linker Maustaste\nAbbrechen mit rechter Maustaste"
    needs1wp "Eine Route muss mindestens aus einem Wegpunkt bestehen"
    emptypos "Position mit leerem Feld/leeren Feldern"
    cantwrtsstate "Kann gespeicherte Status-Datei nicht schreiben"
    cantrdsstate "Kann gespeicherte Status-Datei nicht lesen"
    corruptsstate "Ungltige gespeicherte Status-Datei: %s"
    editrisk "nderungen auf eigene Gefahr!"
    savestate "Aktuellen Status speichern?"
    delsstate "Gespeicherte Status-Dateien lschen?" 
    badmapinfo "Ungltige Kartenparameterdatei"
    badMHloc "Falsches Maidenhead Gitter"
    areais "Die Flche des (nicht selbst-berschneidenen) Polygons betrgt %.3f%s"
    areatoosmall "Die Flche ist zu klein (<0.001 qkm)"
    projarea "Berechne die projizierte Flche"
    selfintsct "Wiederholte WPe: RT kann sich nicht selbst schneiden!"
    badinvmdist "Fehler in der Nherung bei der Umkehrung des Meridional-Abstandes"
    badinvproj "Nherungsfehler bei der Umkehrung der %s Projektion"
    negdlatlong "Lnge/Breite Werte drfen nicht negativ sein!"
    allundef "In der Gruppe sind keine Definitionen fr die WPe enthalten"
    badfloats "Fliesskomma-Konvertierung funktioniert nicht korrekt; sind
Sie sicher, dass Sie die Verbindung herstellen wollen?"
    frgetGRcs "Gruppe mit allen Elementen lschen?!"
    clrtrvlog "Reiseaufzeichnung lschen?"
    badattr "Unbekannter %s optionaler Feldname: %s"
    badattrval "Falscher %s optionaler Feldwert: %s"
    couldntcd "Konnte nicht zu directory %s wechseln"
    shpext "Falsche Endung %s; kann .shp, .shx, .dbf benutzt werden?"
    shpcntopen "Shapefile-Dateien konnten nicht erzeugt/geffnet werden"
    shpcntcrtfs "Shapefile .dbf Felder konnten nicht erzeugt werden"
    shpcntwrtfs "Shapefile .dbf Felder konnten nicht gespeichert werden"
    shpoutmem "Speicher ist voll!"
    shpemptyfile "Leere Datei"
    shpwrongfile "Ungltiger Dateientyp"
    shplessdim "Dimension in Datei kleiner als erforderlich; weiter?"
    shpbadWPinRT "%d. WP mit ungltigen Koordinaten ignoriert in RT %s"
    badGTMvers "GTrackMaker Dateienversion ungltig"
    badGTMfile "Falscher Anfang in GTrackMaker Datei"
    badGTMcounts "Negative(r) Zhler in GTrackMaker Datei"
    badGTMlat "Ungltige Breitenwerte in GTrackMaker Datei"
    badGTMlong "Ungltige Lngenwerte in GTrackMaker Datei"
    badGTMdatum "Ungltiges Datum in GTrackMaker Datei"
    unobscmap "Fehler erfolgte warscheinlich wegen Fenster/Icon auf der Karte; nach Verzgerung wiederversuchen?"
    cantwrtimg "Fehler whrend Bildspeicherung in Datei in %s Format"
    TRsimplres "Vereinfachter TR mit Namen %s erzeugt"
    cantsaveRTid "%d RT(n) nicht gespeichert: non-numerisches Id"
    badtrvconf "Ungltige Konfiguration; Neustart ohne Elemente"
    drvsimoff "Fahrsimulator: noch nicht gestartet!"
    needWP "Fahrsimulater: bitte erst einige WPe laden/definieren"
    chgrecprot "Bitte Empfnger-Protokoll ndern"
    noprintcmd "Kein Druckkommando; bitte eins in den Optionen angeben"
    cantexecasroot "GPSMan kann nicht von root ausgefhrt werden"
    badargtofunc "%s Funktion mit ungltigem Argument"
    redefproj "Benutzers %s Projektion lscht vordefinierte Projektion mit gleicher Abkrzung; bitte Definition ndern!"
}

set TXT(RTcompflds) "# WP {$DTUNIT} Grad m Etappe Bezeichnung"
set TXT(TRcompflds) "TP {$DTUNIT} {$DTUNIT} m h:m:s {$SPUNIT} Grad"
set TXT(starttoend) "Start: bis Ende %s $DTUNIT;"
set TXT(startmax) "max. %s $DTUNIT;"
set TXT(WPnearflds) "WP {$DTUNIT} Grad"
set TXT(within) "Innerhalb (${DTUNIT})"
set TXT(between) "Zwischen (${DTUNIT})"

## comments to TXT elements
# optISOLATIN     # "Compose chars"
# optDPOSRTMAP    # "RT/map dialog offset"
# TRRTnpoints     # "No. points to keep"
# commrec         # "Communication with receiver"
# Marker (after SYzoo)
# azimuth         # "Azimuth" "Kompakurs" "Bearing"
# opening         # "Opening"
# started         # "starting on"
# dontaskagain    # "Stop asking"

array set TXT {
    exit   Ende
    map   Karte
    load   Laden
    loadfrm   "Laden aus"
    save   Speichern
    saveels "Speichern Elemente"
    saveto   "Speichern in"
    clear   Lschen
    clearall   "Alles Lschen"
    newWP   "Neuer WP"
    newRT   "Neue RT"
    newTR   "Neuer TR"
    newGR   "Neue GR"
    import   Importieren
    importfrm   "Importieren aus"
    export   Exportieren
    exportels "Export Elemente"
    exportto   "Exportieren nach"
    count   Zhlen
    trueN   "Geographisch Nord"
    automagn   "Autom. Nadelabweichung"
    usrdef   "Benutzerdefiniert"
    nameWP   Wegpunkt
    nameRT   Route
    nameTR   Track
    nameGR   Gruppe
    namePlot   Zeichnung
    nameMap   Karte
    nameRTComp   "Berechnung der Route"
    nameTRComp   "Berechnung des Track"
    GPSrec   "GPS Empfnger"
    turnoff   "Ausschalten"
    get   Empfangen
    put   Senden
    all   Alle
    select   Auswhlen
    selection   Auswahl
    options   Optionen
    message   Nachricht
    cancel   Abbrechen
    file   Datei
    ovwrt   berschreiben
    app   Anfgen
    online   online
    offline   offline
    check   Prfen
    create   Erstellen 
    revert   Zurcksetzen
    colour   Farbe
    grey   Grau
    mono   Monochrom
    portr   hochformat
    landsc   querformat
    legend   Legende
    incscale   "Mastab einfgen"
    more   Mehr
    waypoint   Wegpunkt
    name   Name
    created   Erstellt
    cmmt   Kommentar
    withWP  "Mit diesem WP:"
    displ   "in der Karte zeigen"
    startRT "Starte RT"
    route   Route
    number   Nummer
    insb   "Einfgen vor"
    insa   "Einfgen nach"
    del   Lschen
    repl   "Ersetzen mit"
    invRT   "RT umkehren"
    comp   Berechne
    RTcomp   "Route Berechnung"
    savecomp "Speichern der Berechnung"
    totdst   "Gesamte Entfernung"
    tottime   "Gesamte Zeit"
    track   Track
    chophd   "Anfang abschneiden"
    choptl   "Ende abschneiden"
    incb   "Einfgen vor"
    date   Datum
    newdate   "Neues Datum fr nchsten Punkt"
    endprTR   "Ende des vorhergehenden Tracks"
    begnxt   "Beginn des nchsten"
    date1st   "Datum fr den ersten Punkt der nchsten"
    TRcomp   "Track-Berechnung"
    avgsp   "Durchschn. Geschwindigkeit"
    maxsp   "Max. Geschwindigkeit"
    minsp   "Min. Geschwindigkeit"
    lat   Breite
    long   Lnge
    ze   ZE
    zn   ZN
    eastng   Rechtswert
    nrthng   Hochwert
    zone   Zone
    change   ndern
    forget   Lschen
    others   Andere
    optLANG   Sprache
    optISOLATIN1   "Buchstaben zusammensetzen" 
    optDELETE   "DEL lscht letzten Buchstaben"
    optMWINDOWSCONF  "Hauptfenster"
    optGPSREC   "GPS-Modell"
    opt_GPSRecConf   "Empfnger-Parameter"
    optNAMELENGTH   "Max. Lnge des Namens"
    optINTERVAL "Stichproben-Intervall"
    optCOMMENTLENGTH   "Max. Lnge des Kommentars"
    optMAXWPOINTS   "Max. # WPunkte"
    optMAXROUTES   "Max. # Routen"
    optMAXWPINROUTE   "Max. # WPe in der Route"
    optMAXTPOINTS   "Max. # Trackpunkte"
    optCREATIONDATE   "Satz hat Erstellungs-Datum"
    optNOLOWERCASE   "Satz ist nicht in Kleinbuchstaben"
    optDEFAULTSYMBOL "Standard WP Symbol"
    optDEFAULTDISPOPT "Standard WP Anzeige Option"
    opt_Data "Daten"
    optEQNAMEDATA "Daten mit identischem Namen"
    optKEEPHIDDEN "Verborgene Daten halten"
    optDatum   Datum
    optTimeOffset   "Zeitdifferenz"
    optACCFORMULAE "Genaue Formel"
    optASKPROJPARAMS "Projektionsparameter besttigen"
    optBalloonHelp "Balloon help"
    opt_Formats   "Einheiten und Formate"
    optDISTUNIT   "Entfernung"
    KM    km
    NAUTMILE    "Nautische Meile"
    STATMILE    "US Meile"
    optPositionFormat   "Positions-Format"
    optDateFormat   "Datums-Format"
    opt_Geom   "Fenster-Einstellungen"
    optMAPWIDTH   "Kartenbreite"
    optMAPHEIGHT   "Kartenhhe"
    optMAPSCLENGTH   "Lnge der Kartenskala"
    optMAPSCALE   "Kartenskala"
    optMAXMENUITEMS   "Max. # Men-Eintrge"
    optLPOSX   "Listen-Fenster X-Pos."
    optLPOSY   "Listen-Fenster Y-Pos."
    optMPOSX   "Karten-Fenster X-Pos."
    optMPOSY   "Karten-Fenster Y-Pos."
    optRPOSX   "Empfnger-Fenster X-Pos."
    optRPOSY   "Empfnger-Fenster Y-Pos."
    optEPOSX   "Fehler-Meldung X-Pos."
    optEPOSY   "Fehler-Meldung Y-Pos."
    optDPOSX   "Dialog-Fenster X-Pos."
    optDPOSY   "Dialog-Fenster Y-Pos."
    optDPOSRTMAP "Abstand RT/Karten Dialog"
    optLISTWIDTH   "Breite Listen"
    optLISTHEIGHT   "Hhe Listen"
    optCOLOUR   Farben
    optCOLOUR,fg   Vordergrund
    optCOLOUR,bg   Hintergrund
    optCOLOUR,messbg   "Hintergrund Fehlermeldung"
    optCOLOUR,confbg   "Hintergrund Besttigung"
    optCOLOUR,selbg   "Hintergrund Auswahl"
    optCOLOUR,dialbg   "Hintergrund Eingabe"
    optCOLOUR,offline   "Empfnger offline"
    optCOLOUR,online   "Empfnger online"
    optCOLOUR,check   "Auswahlknopf"
    optCOLOUR,ballbg  "Hintergrundfarbe Ballon-Hilfe"
    optCOLOUR,ballfg  "Vordergrundfarbe Ballon-Hilfe"
    optMAPCOLOUR "Farben in der Karte"
    optMAPCOLOUR,mapsel   "Ausgewhltes Element auf der Karte"
    optMAPCOLOUR,WP   "Wegpunkte auf der Karte"
    optMAPCOLOUR,RT   "Routen auf der Karte"
    optMAPCOLOUR,mkRT "Route auf der Karte definiert"
    optMAPCOLOUR,TR   "Tracks auf der Karte"
    optMAPCOLOUR,TP   "Track Punkte auf der Karte"
    optMAPCOLOUR,mapleg   "Karten-Legenden"
    optMAPCOLOUR,anim  "Karten-Animation"
    optMAPCOLOUR,emptygrid  "Leeres Bild"
    optMAPCOLOUR,fullgrid   "Bestehendes Bild"
    opt_Files "Seriell Schnittstelle & Dateien"
    optDEFSPORT "Seriell Schnittstelle"
    optPERMS   "Dateirechte"
    optPAPERSIZE "Papiergre"
    red   Rot
    green   Grn
    blue   Blau
    owner   Eigentmer
    permgroup   Gruppe
    others   Andere
    fread   Lesen
    fwrite   Schreiben
    fexec   Ausfhren
    mainwd   "Haupt-Fenster"
    distazim   "Entf. u. Richtung"
    nearestWPs   "Nchste WPe"
    fromto   "Von %s nach %s"
    degrees   Grad
    nameWPDistBear   "Entf. und Richtung"
    nameWPNearest   "nchste WPe"
    inrect   "innerh. Rechteck"
    forthisWP   "fr diesen WP"
    formappedWPs   "fr dargest. WPe"
    group   Gruppe
    element   Element
    insert   Einfgen
    joinGR   "Gruppe zusammenfgen"
    TRtoRT   "Umwandlung von TR nach RT"
    TRRTnpoints   "Anzahl der Punkte" 
    TRTRdispl   "TR jetzt anzeigen"
    WP   WP
    RT   RT
    TR   TR
    GR   GR
    commrec   "Kommunikation mit Empfnger"
    abort   Abbrechen
    ACKs   ACKs
    NAKs   NAKs
    packets   Pakete
    unnamed   "(unbekannt)"
    fromTR    "Von TR: %s"
    mapload "Bild Geo-Referenzieren"
    loadmback Laden
    savemback "Geo-Ref. Info speichern"
    chgmback ndern
    clearmback Lschen
    backgrnd Hintergr
    nameMapBkInfo "Hintergrund-Info"
    mpbkchg "Hintergrund ndern"
    mpbkgrcs "Gitter-Position"
    nameImage Bild
    symbol Symbol
    SYCATgeneral "Allgemein"
    SYCATland Land
    SYCATwater Schiffahrt
    SYCATaviation Luftfahrt
    SY1st_aid "Erste Hilfe"
    SYWP_buoy_white "Boje, wei"
    SYWP_dot "Punkt"
    SYairport "Verkehrsflughafen"
    SYamusement_park "Freizeitpark"
    SYanchor "Anker"
    SYavn_danger "Gefahr (Luftfahrt)"
    SYavn_ndb "ND Funkfeuer"
    SYball "Ball"
    SYbeach "Strand"
    SYbell "Glocke"
    SYboat "Boot"
    SYboat_ramp "Slipanlage"
    SYborder "Grenzbergang"
    SYbridge "Brcke"
    SYbuilding "Gebude"
    SYbuoy_amber "Boje, amber"
    SYbuoy_black "Boje, schwarz"
    SYbuoy_blue "Boje, blau"
    SYbuoy_green "Boje, grn"
    SYbuoy_green_red "Boje, grn-rot"
    SYbuoy_green_white "Boje, grn-wei"
    SYbuoy_orange "Boje, orange"
    SYbuoy_red "Boje, rot"
    SYbuoy_red_green "Boje, rot-grn"
    SYbuoy_red_white "Boje, rot-wei"
    SYbuoy_violet "Boje, violett"
    SYbuoy_white "Boje, wei"
    SYbuoy_white_green "Boje, wei-grn"
    SYbuoy_white_red "Boje, wei-rot"
    SYcamping "Campingplatz"
    SYcapitol_city "Hauptstadt"
    SYcar "Auto"
    SYcar_rental "Auto-Verleih"
    SYcar_repair "Auto-Werkstatt"
    SYcastle "Burg, Schlo"
    SYcemetery "Friedhof"
    SYchapel "Kapelle"
    SYchurch "Kirche"
    SYcircle_x "Gekreuztes X"
    SYcivil "ffentliche Einrichtung"
    SYcontrolled "Betreten verboten"
    SYcrossing "Bahnbergang"
    SYdam "Damm"
    SYdanger "Gefahr"
    SYdeer "Jagdgrund"
    SYdiamond_green "Diamant, grn"
    SYdiamond_red "Diamant, rot"
    SYdiver_down_1 "Taucher 1"
    SYdiver_down_2 "Taucher 2"
    SYdot "Punkt"
    SYdrinking_water "Trinkwasser"
    SYduck "Wassergeflgel"
    SYelevation "Anhhe"
    SYexit_no_serv "Anschlustelle"
    SYexit "Ausfahrt"
    SYfactory "Fabrik"
    SYfastfood "Schnellrestaurant"
    SYfish "Angelplatz"
    SYfitness "Trimm-Dich-Pfad"
    SYflag "Flagge"
    SYfreeway "Hauptstrae"
    SYfuel "Tankstelle"
    SYfuel_store "Rasthof"
    SYgeo_name_land "Landschaft"
    SYgeo_name_man "Kultur"
    SYgeo_name_water "Gewsser"
    SYglider "Segelfluggelnde"
    SYgolf "Golfplatz"
    SYheliport "Hubschrauber-Landeplatz"
    SYhorn "Hupe"
    SYhouse "Haus"
    SYice_skating "Eisstadion"
    SYinfo "Information"
    SYintersection "Kreuzung"
    SYis_highway "Bundesstrae"
    SYknife_fork "Restauration"
    SYladder "Leiter"
    SYlanding "Landeplatz"
    SYlarge_city "Grostadt"
    SYlarge_exit_ns "Autobahnausfahrt"
    SYlarge_ramp_int "Autobahnkreuz"
    SYlevee "Deich"
    SYlight "Leuchtturm"
    SYlodging "Unterkunft"
    SYmany_fish "Fischgrund"
    SYmany_tracks "Viele Wanderwege"
    SYmark_x "Markierung, x"
    SYmedium_city "Stadt"
    SYmile_marker "Kilometermarkierung"
    SYmilitary "Militrsttzpunkt"
    SYmine "Bergwerk"
    SYMOB "Mann ber Board"
    SYmonument "Monument"
    SYmountains "Gebirge"
    SYmovie "Kino"
    SYmug "Kaffee & Kuchen"
    SYntl_highway "Autobahn"
    SYnull "(transparent)"
    SYnull_2 "(leer)"
    SYoil_field "lfeld"
    SYparachute "Fallschirm"
    SYparking "Parkplatz"
    SYpharmacy "Apotheke"
    SYphone "Telefon"
    SYpicnic "Liegewiese"
    SYpizza "Pizzeria"
    SYpolice "Polizei"
    SYpost_office "Post"
    SYprivate "Privatgrund"
    SYradio_beacon "Funkfeuer"
    SYramp_int "Anschlustelle"
    SYrestricted "Sperrgebiet"
    SYrestrooms "WC"
    SYRV_park "Freizeit-Fahrgelnde"
    SYscenic "Aussichtspunkt"
    SYschool "Schule"
    SYseaplane "Wasserungs-Stelle"
    SYshopping_cart "Einkaufen"
    SYshort_tower "Turm, niedrig"
    SYshowers "Dusche"
    SYskiing "Wasserski"
    SYskull "Totenkopf"
    SYsmall_city "Kleinstadt"
    SYsnow_skiing "Ski"
    SYsoft_field "Grasplatz"
    SYsquare_green "Rechteck, grn"
    SYsquare_red "Rechteck, rot"
    SYst_highway "Landstrae"
    SYstadium "Stadion"
    SYstore "Kaufhaus"
    SYstreet_int "Straenkreuzung"
    SYsummit "Gipfel"
    SYswimming "Schwimmbad"
    SYtake_off "Startplatz"
    SYtall_tower "Turm, hoch"
    SYtheater Theater
    SYtoll Mautstation
    SYtow_truck "Abschleppwagen"
    SYtraceback "Rckweg"
    SYtracks Wanderwege
    SYtrail_head "Wander-Parkplatz, Ausgangspunkt"
    SYtree "Baum"
    SYtruck_stop "Rastplatz"
    SYtunnel "Tunnel"
    SYultralight "Ultraleicht-Landeplatz"
    SYus_highway "Europastrae"
    SYweight_station "Waage"
    SYwreck "Wrack"
    psvisible "Nur sichtbarer Teil"
    DISPsymbol "nur Symbol"
    DISPs_name "Symbol & Name"
    DISPs_comment "Symbol & Kommentar"
    DISPname "nur Name"
    DISPcomment "nur Kommentar"
    dispopt Anzeige
    mapitems "Zeige Elemente in der Karte"
    nameIC Icon
    prod Produkt
    WPCapac "Wegpunkt-Kapazitt"
    ICCapac "Icon Kapazitt"
    RTCapac "Routen-Kapazitt"
    TRCapac "Track-Kapazitt"
    protcl "Protokoll"
    ICGraph "Icon Grafik"
    WPperRT "Wegpunkte pro Route"
    notinGR "nicht in (Unter-)Gruppe enthalten"
    onlyinGR "nur in (unter-)Gruppe enthalten"
    loadgrels "Lade Elemente"
    importgrels "Importiere Elemente"
    about "ber GPSMan..."
    contrib "Mit Beitrgen von"
    errorsto "Fehlerberichte an:"
    obsTRToRT "WPe erzeugt mit TR nach RT Konvertierung"
    nameLists "Listen"
    nameData "Daten"
    MWCmap "Karte"
    MWClists "Listen"
    MWCsingle "Einzelnes Fenster"
    search "Suchen"
    rmrk "NB"
    closeto "Benachbart zu"
    with "Mit"
    srchres "GEFUNDEN"
    database "Datenbank"
    where "Wo"
    what "Was"
    list "Liste"
    distance "Entfernung"
    fromWP "von Wegpunkt"
    fromPos "von Position"
    azimuth "Komparichtung" 
    any "jedes"
    opening "ffnen"
    suggested "Vorschlag"
    another "Anderes"
    srchdd1 "Suchen nach"
    srchdd2Data "Alle Elemente"
    srchdd2GR "Gruppe(n)"
    from "von"
    started "beginnend von" 
    transf  "Koord. Transf."
    TRNSFAffine    "Affin"
    TRNSFAffineConf  "Affin Konform"
    TRNSFNoRot      "Konform ohne Rotation"
    projection "Projektion"
    lat0  "zentrale Breite"
    long0 "zentrale Lnge"
    gkklong0 "zentrale Lnge"
    kkjplong0 "zentrale Lnge"
    twglong0 "zentrale Lnge"
    k0 "Skalenfaktor des Zentralmeridians"
    PRJUTM "UTM/UPS"
    PRJTM  "Transv. Mercatorproj."
    PRJCMP "Port. Militr-Karte"
    PRJBNG "Nat. Britisches Gitter"
    PRJBWI "Britisch West Indies"
    PRJITM "Irische Transv. Merkator-Proj."
    PRJGKK "Gau-Krger-Koordinaten"
    dontaskagain "Ohne Rckfrage"
    rename "Verwende neuen Namen"
    oname "Ursprnglicher Name"
    never "Niemals"
    ask "Fragen"
    always "Immer"
    stage "Etappe"
    label "Beschriftung"
    alt "Hhe"
    locate "Lokalisieren"
    animation  Animation
    fast Schnell
    slow Langsam
    start Start
    pause Pause
    speed Geschwindigkeit
    centred "zentriert"
    state Status
    animinit "zu Beginn/am Ende"
    animon "laufend"
    animpause "pausiert"
    animabort "abgebrochen"
    dolog Aufzeichnen
    getlog "Aufzeichnung laden"
    stop Stopp
    hide Verdecken
    show Zeigen
    posfixerror Fehler
    restart "Neu starten"
    mkTR "TR erzeugen"
    posfixsimul Simul
    namePVTData "Aufzeichnungsdaten"
    realtimelog "Echtzeitdaten"
    simul "Simulator"
    mkavgWP "Mittel-WP erzeugen"
    abbrev "Abkrzung"
    actual "Aktuell"
    baseproj  "Basisprojektion" ?
    atprevwp "Vorhergehender WP"
    here "Hier"
    chglstrs "Vorhergehenden Zustand bearbeiten"
    chgnxtrs "Nchsten Zustand bearbeiten"
    contnend "Zum Ende anfgen"
    edmap "In der Karte bearbeiten"
    prevwp Vorheriger WP"
    firstwp "Erster WP"
    fixeddatum  "Festes Datum"
    grid "Gitternetz"
    lat1 "erster Breitenkreis"
    lat2  "zweiter Breitenkreis"
    latF  "Ursprung der Breite"
    longF "Ursprung der Lnge"
    chgpfrmt "Positions-Format ndern"
    closemenu "Men schliessen"
    datum "Datum"
    easting "Rechtswert"
    northing "Hochwert"
    feasting "Ordinate des Rechtswertes"
    fnorthing "Ordinate des Hochwertes"
    elevation "Hhe"
    ellpsd "Ellipsoid"
    inca  "Einfgen nach"
    invert "umkehren"
    move "Verschieben"
    open "ffnen"
    opt_MapGeom "Geometrie der Karte"
    PRJKKJP "Finisches Basis Gitter"
    PRJKKJY "Einheitliches Finnisches Gitter"
    PRJSEG "Schwedisches Gitter"
    recwindow "Empfnger-Fenster"
    restart "Neu starten"
    rtimelogintv "Aufzeichnungs-Intervall"
    unit "Einheit"
    use "benutze"
    userdefs "Nutzerspezifische Definitionen"
    usewps  "Benutze WPe"
    optSAVESTATE "Bei Beenden Status speichern"
    optDELSTATE "Nach Wiederherstellen des Status, Dateien lschen"
    nameMapInfo "Kartenparameter"
    volume "Volumen"
    no Nein
    latS "sdl. Breite"
    latN "nrdl. Breite"
    longW "westl. Lnge"
    longE "stl. Lnge"
    PRJAPOLY "Amerikanische Polykonische"
    computations Berechnungen
    comparea "Berechne Flche"
    optTRNUMBERINTVL "Zeige TP Nummer auf der Karte alle"
    centre  Mittelpunkt
    mkclusters "Erzeuge Cluster"
    dlat "Wertebereich der Breite"
    dlong "Wertebereich der Lnge"
    collcntr "Erzeuge Mittelpunkte..."
    compclstr "Erzeuge Cluster..."
    crtgclstrgrs "Erstelle Gruppen..."
    PRJStereogr "Stereographische Proj."
    PRJTWG "Taiwan Gitter"
    chgdatum "Datum ndern"
    forgetGRcs "GR&Els lschen"
    renres "Neubenannt"
    zelev "Z-Mastab"
    xyelev "XY-Mastab"
    chggoal "Zum nchsten Ziel wechseln"
    Ghidden_class Klasse
    Ghidden_subclass Subklasse
    Ghidden_lnk_ident "Etappen Id"
    Ghidden_colour Farbe
    Ghidden_attrs Attribute
    Ghidden_depth Tiefe
    Ghidden_state Staat
    Ghidden_country Land
    Ghidden_facility Facility
    Ghidden_city Stadt
    Ghidden_addr Adresse
    Ghidden_int_road "Straenkreuzung"
    Ghidden_dtyp "Anzeige Option+Typ"
    Ghidden_ete "ETE"
    Ghidden_display "Display?"
    Ghidden_yes ja
    Ghidden_no nein
    Ghidden_user Benutzer
    Ghidden_user_symbol "Benutzer (nur Symbol)"
    Ghidden_non_user "Nichtbenutzer"
    Ghidden_avn_airport Flughafen
    Ghidden_avn_inters "Avn intersection"
    Ghidden_avn_NDB "NDB"
    Ghidden_avn_VOR "VOR"
    Ghidden_avn_airp_rway "Airport runway threshold"
    Ghidden_avn_airp_int "Airport intersection"
    Ghidden_avn_airp_NDB "Airport NDB"
    Ghidden_map_pt "Kartenpunkt"
    Ghidden_map_area "Karten-Flche"
    Ghidden_map_int "Karten-Kreuzung"
    Ghidden_map_addr "Karten-Adresse"
    Ghidden_map_label "Karten-Kennzeichen"
    Ghidden_map_line "Karten-Linie"
    Ghidden_locked blockiert
    Ghidden_default "Vorgabe"
    Ghidden_black Schwarz
    Ghidden_white Weiss
    Ghidden_red Rot
    Ghidden_dark_red "Dunkelrot"
    Ghidden_green Grn
    Ghidden_dark_green "Dunkelgrn"
    Ghidden_blue Blau
    Ghidden_dark_blue "Dunkelblau"
    Ghidden_yellow Gelb
    Ghidden_dark_yellow "Dark Gelb"
    Ghidden_magenta Magenta
    Ghidden_dark_magenta "Dunkles Magenta"
    Ghidden_cyan Cyan
    Ghidden_dark_cyan "Dunkles Cyan"
    Ghidden_light_gray "Hellgrau"
    Ghidden_dark_gray "Dunkelgrau"
    Ghidden_line Linie
    Ghidden_link Etappe
    Ghidden_net Netz
    Ghidden_direct Direkt
    Ghidden_snap Snap
    numberid "Nummer/Id"
    hiddendata "Verborgene Daten"
    cwpsdef "Wieviele Kontroll WPe definieren"
    nextTP "Nchster TP"
    generate Erzeugen
    generateall "Alle erzeugen"
    optSERIALBAUD "Baud Rate"
    optDEFTRTWIDTH "RT Liniendicke"
    optDEFTTRWIDTH "TR Liniendicke"
    width Dicke
    TRtoTR   "TR Vereinfachung"
    TRlinedispl   "Ergebnis jetzt zeigen"
    obsTRsimpl "TR nach Vereinfachung"
    simplTRto "Vereinfachen zu"
    exstglog "Existigerender log"
    contnsly "fortgesetzt"
    animate "animieren"
    animabbrev "anim."
    noanabbr "nicht anim."
    notext "kein Text"
    view "ansehen"
    sideview "Seitenansicht"
    persptv "Perspektive"
    SYgeocache "Geocache"
    SYgeocache_fnd "Geocache entdeckt"
    optMAPCOLOUR,trvtrk "TRK Zeiger"
    optMAPCOLOUR,trvtrn "TRN Zeiger"
    optMAPCOLOUR,trvcts "CTS Zeiger"
    optMAPCOLOUR,trvcts2 "2. CTS Zeiger"
    optMAPCOLOUR,trvvel_z "Hoch/Runter Zeiger"
    optMAPCOLOUR,trvwrnimportant "Wichtige Warnung (nav)"
    optMAPCOLOUR,trvwrnnormal "Warnung (nav)"
    optMAPCOLOUR,trvwrninfo "Information (nav)"
    travel Reise
    notravel "Reise unterbrechen"
    optTRAVELFONTSIZE "Schriftgre der Reisenanzeige"
    travdisplay "Anzeige konfigurieren"
    travchgdisplay "Zu Anzeige %s wechseln"
    travdsetup "Reisenanzeige konfigurieren"
    navMOB "MOB: Mann ber Bord!"
    startnav "Navigate"
    navWP "Zu WP gehen"
    goback "Zurckgehen"
    follow "%s folgen"
    exactly "exakt"
    fromnrst "vom nhesten Punkt"
    inrvrs "umgekehrt"
    forgetgoal "Ziel lschen"
    suspend "unterbrechen"
    resume "weiter"
    TRVfix "Fix"
    TRVhour "Uhrzeit"
    TRVspeed "Geschw."
    TRVpos "Pos"
    TRValt "Hhe"
    TRVtrk "TRK"
    TRVnxtWP "Zu"
    TRVprvWP "Von"
    TRVete "ETE"
    TRVeta "ETA"
    TRVvmg "VMG"
    TRVxtk "XTK"
    TRVcts "CTS"
    TRVtrn "TRN"
    TRVvel_z "V Geschw."
    TRVtrkcts "TRK, CTS"
    TRVdist "Dist"
    TRVc_trkcts "TRK/CTS Zeiger"
    TRVc_trn "TRN Zeiger"
    TRVc_vel_z "Hoch/runter Zeiger"
    add "Hinzufgen"
    addlabelled "Mit Beschriftung hinzufuegen"
    remove "Lschen"
    mindist "Ankunftsnhe"
    chginggoal "Wechsel zum nchsten Ziel"
    chggoalhlp "Wann von diesem zum\nnchsten Ziel wechseln\nbeim Folgen von RT/TR"
    soon frh
    late spt
    warnings "Warnungen"
    dowarn "Warnungen ausstellen"
    warnconf "Warnungen konfigurieren"
    priority Vorrang
    high hoch
    medium mittel
    low niedrig
    warnprox "Entfernung zu WP <"
    warnanchor "Entfernung zu WP >"
    warnspeed "Geschwindigkeit >"
    warntrn "TRN (abs)>"
    warnvspeed "Vertikale Geschwindigkeit"
    warnxtk "XTK (abs)>"
    fntsize "Schriftgre"
    trvhlpbox "Rechte Taste zur Wiederordnung von\nfolgenden Elementen benutzen"
    trvhlpbxs "Rechte Taste zur Wiederordnung von\nElementen der Liste benutzen"
    trvwarrv "Ankunft in %s!"
    trvwleave "Abfahrt von %s!"
    trvwspeed "Geschwindigkeit > %s!"
    trvwtrn "TRN > %s!"
    trvwvspeed "Vert. Geschwindigkeit nicht in [%s,%s]!"
    trvwxtk "XTK > %s!"
    trvwnolog "Echtzeitdatenaufnahme ausgeschaltet!"
    trvwnopos "Keine vorherigen Positionen"
    trvwuwps "RT hat undefinierte WP(e)"
    trvwchg "Jetzt nach %s gehend"
    TP TP
    drivesim "Fahrsimulator"
    startfrom "Startpunkt..."
    outofctrl "Ausser Kontrolle!"
    right Rechts
    left Links
    straight Geradeaus
    rthlpdsim "Zeigertasten: steuern, Geschwindigkeit ndern\nLeertaste: geradeaus"
    printopt "Druckoptionen"
    optPRINTCMD "Druckkommandos"
    optMAPFONTSIZE "Kartenschriftgre"
    print Drucken
    prevctr "Vorheriger Mittelpunkt"
    PRJSOM "Swiss Oblique Mercator"
    PRJLV03 "Swiss LV03 Grid"
    PRJIcG "Iceland Grid"
    PRJRDG "The Netherlands Grid"
    chgmfsize "Kartenschriftgre ndern"
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    DMS   DMS
    DMM   DMM
    DDD   DDD
    UTM/UPS   UTM/UPS
    WP   WP
    RT   RT
    TR   TR
    GR   GR
}

