#
#  Copyright (c) 1994-1997 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: faxIt.t,v 1.4 1996/12/31 02:41:43 andy Exp $
#

#
# Fax a file(s). The "Ooops_only" argument indicates whether or not to
# report all errors and successes (default) or to report only errors.
#


proc faxIt { {Ooops_only false}} {

    global Th_Info
    global Comments

    # If no phone number then abort the request	
    if {[string length $Th_Info(phone)] == 0} {
	tk_dialog .err "Ooops!" "There's no fax phone number." warning 0 OK
	return
    }

    # Collect up options
    set delay [expr ($Th_Info(tdHours)*60) + $Th_Info(tdMin)]
    if {$delay > 0} {
        append options " -a \"now+$delay minutes\""
    }

    if {$Th_Info(retryCount) > 0} {
        append options " -t $Th_Info(retryCount)"
    }

    if {[string length $Th_Info(name)]} {
        # This MUST appear.
        append options " -d \"$Th_Info(name)@$Th_Info(phone)\""

        # Make an ID string for later usage
        append options " -i \"$Th_Info(name)@$Th_Info(company)\"" 
    } else {
        # This MUST appear.
        append options " -d $Th_Info(phone)"
    }

    append options $Th_Info(faxResolution) \
	          $Th_Info(initiatePoll) \
	          $Th_Info(notifyOnCompletion) \
	          $Th_Info(notifyOnRetry)

    # Determine whether this is a cover-sheet-only request. 
    set sz [$Th_Info(docsLB) size] 
    if {$sz == 0} {
	set res \
	    [tk_dialog .err "Ooops!" "No files have been specified. \
	    Shall just the cover sheet be sent?" questhead 0 OK Cancel] 
	switch -exact -- $res 1 {
	    return
	} default {
	    append faxcmd "[mkCover] | sendfax -n" $options
	}
    } elseif {$sz > 0} {
	# Make command. Ignore the following options: -k -s -h -v 
	append faxcmd "sendfax "

         foreach ln [lsort [array name Comments]] { 
	    append comments "$Comments($ln) "
         }    

	set comments [string trim $comments]
	if {[string length $comments]} {
	    append faxcmd " -c \"$comments\""
	}

	if {[string length $Th_Info(regard)]} {
	    append faxcmd " -r \"$Th_Info(regard)\""
	}

	if {[string length $Th_Info(company)]} {
	    append faxcmd " -x \"$Th_Info(company)\""
	}

	if {[string length $Th_Info(location)]} {
	    append faxcmd " -y \"$Th_Info(location)\""
	}

	append faxcmd $options

	# Append all the files.
	for {set i 0} {$i < $sz} {incr i} {
	    append faxcmd " [glob [$Th_Info(docsLB) get $i]]"
	}
    }

    # Exec it
    if {[catch {eval exec $faxcmd} err]} {
        tk_dialog .err "Ooops!" "$err" questhead 0 OK
    } else {
        if {$Ooops_only == "false"} {
	   tk_dialog .err "Send Fax Status" "Fax job queued ok" info 0 OK
        }
    }
}
