# This file is a part of TkFax.
# fax-about.tcl

#
# TkFax version and date

set fax(progname) TkFax
set fax(version) 0.91
set fax(date) {October 1998}
set fax(ex_version) 1.02
set fax(ex_date) {22 Apr 2002}

#
# About TkFax

set fax(about0) "
$fax(progname) version $fax(ex_version), $fax(ex_date)
A Tcl/Tk based GUI fax program
License : GNU Public License"

set fax(about) "Written by $fax(progname) extention project
(c)Masaki Shinomiya <shino@pos.to>
(c)Ryoji Kawagishi <kawagisi@yk.rim.or.jp>
http://shino.pos.to/linux/tkscanfax.html

$fax(progname) version $fax(version), $fax(date)
(c) Hang-Bae Kim <hbkim@muon.kaist.ac.kr>
http://muon.kaist.ac.kr/~hbkim/linux/tkscanfax/

Special thanks
Seizo Murakami (JX-250 scanner driver)
OGAWA Hideo  (GT-7600S scanner driver)
"

set fax(license) "
This is a free software and comes with no warranty.
See the GNU General Public License for details.
"

proc fax_about {} {
#
# About TkFax window.
#
    global fax m

    set wn $fax(mwn).about
    if [winfo exists $wn] return
    toplevel $wn
    wm title $wn "$fax(progname) $fax(version): About"
    image create photo tkfax -file $fax(libdir)/images/tkfax-s.gif
#    image create photo hbkim -file $fax(libdir)/images/hbkim.gif

    frame $wn.0
    label $wn.0.i -image tkfax
    label $wn.0.t -text $fax(about0) -justify left -padx 4
    pack $wn.0.i $wn.0.t -side left
    label $wn.l -text $fax(about)
#    label $wn.i -image hbkim
    label $wn.j -text $fax(license)
    button $wn.b -width 8 -text $m(ok) -command "destroy $wn"
    pack $wn.b -side bottom
    pack $wn.0 $wn.l $wn.j -side top

#   set url http://shino.pos.to/linux/tkscanfax.html
#    bind  $wn.0.i <Button-1> "open_url $url" 
}


proc open_url { url } {
     global fax m
     fax_exec "netscape -remote \"openURL($url,rase)\"" 
}

# End of fax-about.tcl
