# This file is a part of TkFax.

#--------------------------------------------------------------------------
# configure window
#--------------------------------------------------------------------------
# 4 Jul 2001 by Ryoji Kawagishi 
proc FaxConfigure {} {

  global  fax m cover p1 p2 p3 p4 p5
  global  ckusrlocale ckfaxagent  ckviewer ckxterm cklatex
  global  ckfaxPaper ckprintertype ckprinterPaper

  if { [winfo exists .st] == 1 } {return }

  set m(procname) $m(config)
  toplevel  .st
  wm title  .st "TkFax$m(procname)"

  frame .st.fr1
  frame .st.fr2
  # 11 Sep 2001 assign high priority to the buttons
  pack  .st.fr2 -side bottom
  pack  .st.fr1 -fill both
  tabnotebook_create .st.fr1.tn    ;# create tab-notebook
  pack  .st.fr1.tn -fill both

  # add resources
  option add *Tabnotebook.tabs.background #666666  widgetDefault
  option add *Tabnotebook.margin          6        widgetDefault
  option add *Tabnotebook.tabColor        skyblue  widgetDefault
  option add *Tabnotebook.activeTabColor  yellow   widgetDefault

  set p1 [tabnotebook_page .st.fr1.tn $m(directory)]
  set p2 [tabnotebook_page .st.fr1.tn $m(extprogs)] 
  set p3 [tabnotebook_page .st.fr1.tn $m(looks)]   
  set p4 [tabnotebook_page .st.fr1.tn $m(letter_head)]     
  set p5 [tabnotebook_page .st.fr1.tn $m(repetitives)]     

  .st.fr1.tn.tabs configure -background #666666

  #----------------------------------------------------------------------
  # Buttons
  #----------------------------------------------------------------------
  button .st.fr2.help   -text $m(help)    -command { DispHelp }
  button .st.fr2.default   -text $m(load_default)    -command { LoadDefault .st }
  button .st.fr2.cancel -text $m(cancel) -command { destroy .st }
  button .st.fr2.quit   -text $m(finish)     -command {
      UpdateConf
      set q [tk_dialog .dialog "TkFax Dialog" \
                  "$m(config_file_updated)"  {info} 0 $m(ok)]
      fax_message $m(config_file_updated)
      destroy .st }
  pack   .st.fr2.help .st.fr2.default .st.fr2.cancel .st.fr2.quit \
         -side left -fill both -expand yes -padx 10 -pady 10

  #----------------------------------------------------------------------
  # configure directories
  #----------------------------------------------------------------------
  # 11 Sep 2001
  # 4 Sep 2001 use foreach
  # 2 Nov 2001 workspace
  global directories
   frame $p1.directories
   label $p1.directories.lab -text $m(directory)  -relief groove -fg blue -width 15 -anchor w
#  checkbutton $p1.frcleartmpdiratexit.lab  -anchor w
#  pack $p1.frcleartmpdiratexit.lab  $p1.frcleartmpdiratexit.var -side left 
  grid $p1.directories.lab -column 1 -columnspan 2 -sticky w

 set items ""
  set directories "user tmp pbook tex systex spool incoming outgoing log"
  set i 0
  foreach n $directories {
      set i [expr $i+1]
      set item "${n}dir"
      set items "$items $item"
      label $p1.lab$i -text "$m($n) $m(directory)"
      entry $p1.ent$i -width 50
            $p1.ent$i insert  0 $fax($item)
      label $p1.dmy$i -width 2
      grid  $p1.lab$i -column 1 -row $i -sticky e
      grid  $p1.ent$i -column 2 -row $i -sticky we
      grid  $p1.dmy$i -column 3 -row $i
  }

  grid columnconfigure $p1 1 -weight 1
 
  #----------------------------------------------------------------------
  # Configuration 1
  # Locale, paper size, fax agent, fax viewr, print command, printer type
  #----------------------------------------------------------------------
# 2 Nov 2001
# modified on 25 Aug 2001 by Masaki Shinomiya ( Auto locale, viewr, printer )
  set items "usrlocale faxagent viewer xterm latex mpage faxPaper faxmargin\
 printertype printcmd printerPaper printermargin"
  set r 0
  foreach i $items {
     set r [expr $r+1]
     frame   $p2.fr$i
     grid    $p2.fr$i -column 1 -row $r -sticky wn
  }
  grid rowconfigure $p2 1 -minsize 40
  grid rowconfigure $p2 6 -minsize 40
#  grid rowconfigure $p2 12 -minsize 40

  label       $p2.frusrlocale.lab -text $m(usrlocale) -relief groove -fg blue -width 15 -anchor w
  radiobutton $p2.frusrlocale.auto  -text $m(auto)  -variable ckusrlocale -value ""  -width 8 -anchor w
  radiobutton $p2.frusrlocale.c  -text "C"  -variable ckusrlocale -value C  -anchor w
  radiobutton $p2.frusrlocale.ja -text "ja" -variable ckusrlocale -value ja  -width 3 -anchor w
  radiobutton $p2.frusrlocale.other -text $m(others) -variable ckusrlocale -value other
  entry       $p2.frusrlocale.ent -width 10

  pack  $p2.frusrlocale.lab  $p2.frusrlocale.auto $p2.frusrlocale.c \
           $p2.frusrlocale.ja $p2.frusrlocale.other $p2.frusrlocale.ent \
        -side left -expand no -anchor w

  switch $fax(usrlocale) {
      ""  {$p2.frusrlocale.auto  select ;# System default }
      C  {$p2.frusrlocale.c  select ;# English }
      ja {$p2.frusrlocale.ja select ;# Japanese }
      default {$p2.frlclocale.other select
               $p2.frusrlocale.ent insert 0 $fax(usrlocale)
      }
  }

  label       $p2.frfaxagent.lab -text $m(faxagent) -relief groove -fg blue \
              -width 15 -anchor w
  radiobutton $p2.frfaxagent.sendfax -text "sendfax" -variable ckfaxagent -value "sendfax"\
              -width 8 -anchor w
  radiobutton $p2.frfaxagent.efax -text "efax"    -variable ckfaxagent -value "efax"\
              -width 8 -anchor w
  pack        $p2.frfaxagent.lab $p2.frfaxagent.sendfax $p2.frfaxagent.efax -side left
  switch $fax(faxagent) {
      sendfax { $p2.frfaxagent.sendfax select }
      efax    { $p2.frfaxagent.efax select }
  }

  label       $p2.frviewer.lab -text $m(viewer) -relief groove -fg blue \
              -width 15 -anchor w
  radiobutton $p2.frviewer.auto -text $m(auto)    -variable ckviewer -value "" \
             -width 8 -anchor w
#  radiobutton $p2.frviewer.xloadimage -text xloadimage -variable ckviewer \
#               -value "xloadimage -zoom 35" -anchor w
 radiobutton $p2.frviewer.kfax -text kfax       -variable ckviewer -value kfax\
              -anchor w
#  radiobutton $p2.frviewer.gfax -text ghfaxviewer -variable ckviewer  -value ghfaxviewer \
#             -width 12 -anchor w
  radiobutton $p2.frviewer.other -text $m(others) -variable ckviewer -value other
  entry       $p2.frviewer.ent -width 28
  pack        $p2.frviewer.lab $p2.frviewer.auto $p2.frviewer.kfax \
               $p2.frviewer.other $p2.frviewer.ent -side left
  switch $fax(viewer) {
      ""                { $p2.frviewer.auto  select }
      kfax             { $p2.frviewer.kfax  select }
      default         { $p2.frviewer.other select
                           $p2.frviewer.ent insert 0 $fax(viewer)
      }
  }

  label       $p2.frxterm.lab -text $m(xterm) -relief groove -fg blue \
              -width 15 -anchor w
  radiobutton $p2.frxterm.xterm -text xterm -variable ckxterm -value xterm \
              -width 8 -anchor w
  radiobutton $p2.frxterm.kterm -text kterm -variable ckxterm -value kterm \
              -width 8 -anchor w
  radiobutton $p2.frxterm.rxvt  -text rxvt  -variable ckxterm -value rxvt \
                       -anchor w
  radiobutton $p2.frxterm.other -text $m(others) -variable ckxterm -value other
  entry       $p2.frxterm.ent -width 16
  pack        $p2.frxterm.lab $p2.frxterm.xterm $p2.frxterm.kterm \
              $p2.frxterm.rxvt $p2.frxterm.other $p2.frxterm.ent -side left
 switch $fax(xterm) {
      xterm { $p2.frxterm.xterm select }
      kterm { $p2.frxterm.kterm select }
      rxvt   { $p2.frxterm.rxvt   select }
     default     { $p2.frxterm.other select
                    $p2.frxterm.ent insert 0 $fax(xterm)
      }
  }

  label       $p2.frlatex.lab   -text LaTeX -relief groove -fg blue \
             -width 15 -anchor w
  radiobutton $p2.frlatex.latex  -text LaTeX      -variable cklatex -value latex \
             -width 8 -anchor w
  radiobutton $p2.frlatex.platex -text pLaTeX     -variable cklatex -value platex  \
             -width 8 -anchor w
  radiobutton $p2.frlatex.none   -text $m(none)   -variable cklatex -value none   -anchor w
  pack       $p2.frlatex.lab $p2.frlatex.latex  $p2.frlatex.platex  $p2.frlatex.none \
           -side left
  switch $fax(latex) {
      latex   { $p2.frlatex.latex    select }
      platex  { $p2.frlatex.platex   select }
      default { $p2.frlatex.none     select }
  }

  label       $p2.frmpage.lab -text $m(mpage) -relief groove -fg blue -width 16 -anchor w
  entry       $p2.frmpage.ent -width 55
  pack        $p2.frmpage.lab -side left -padx 4
  pack        $p2.frmpage.ent -side left -padx 4
              $p2.frmpage.ent insert 0 $fax(mpage)

  label       $p2.frfaxPaper.lab   -text $m(faxPaper) -relief groove -fg blue \
             -width 15 -anchor w
  radiobutton $p2.frfaxPaper.a4  -text "A4"     -variable ckfaxPaper -value "a4" \
             -width 4 -anchor w
  radiobutton $p2.frfaxPaper.letter -text "Letter" -variable ckfaxPaper -value "letter" \
             -anchor w
  radiobutton $p2.frfaxPaper.legal -text "Legal"  -variable ckfaxPaper -value "legal"  -anchor w
  pack  $p2.frfaxPaper.lab $p2.frfaxPaper.a4 $p2.frfaxPaper.letter $p2.frfaxPaper.legal \
       -side left
  switch $fax(faxPaper) {
      letter  { $p2.frfaxPaper.letter select }
      legal   { $p2.frfaxPaper.legal select }
      a4 -
      default { $p2.frfaxPaper.a4  select }
  }
  label       $p2.frfaxmargin.labx -text $m(Xmargin) -width 15 -anchor e
  entry       $p2.frfaxmargin.xmgn -width 10
  label       $p2.frfaxmargin.unitx -text inches -width 8 -anchor w
  pack        $p2.frfaxmargin.labx -side left -padx 4
  pack        $p2.frfaxmargin.xmgn $p2.frfaxmargin.unitx -side left
              $p2.frfaxmargin.xmgn insert 0 $fax(faxXmargin)
  label       $p2.frfaxmargin.laby -text $m(Ymargin) -width 16 -anchor e
  entry       $p2.frfaxmargin.ymgn -width 10
  label       $p2.frfaxmargin.unity -text inches -anchor w
  pack        $p2.frfaxmargin.laby -side left -padx 4
  pack        $p2.frfaxmargin.ymgn $p2.frfaxmargin.unity -side left
              $p2.frfaxmargin.ymgn insert 0 $fax(faxYmargin)
  

  label       $p2.frprintertype.lab  -text $m(printertype) -relief groove -fg blue \
             -width 15 -anchor w
  radiobutton $p2.frprintertype.auto  -text $m(auto)  -variable ckprintertype -value "" \
             -width 8 -anchor w
  radiobutton $p2.frprintertype.ps    -text ps      -variable ckprintertype -value ps  \
             -anchor w
  radiobutton $p2.frprintertype.ljs   -text ljs     -variable ckprintertype -value ljs \
             -anchor w
  radiobutton $p2.frprintertype.lj    -text lj      -variable ckprintertype -value lj \
             -anchor w
  pack       $p2.frprintertype.lab $p2.frprintertype.auto  $p2.frprintertype.ps \
             $p2.frprintertype.ljs $p2.frprintertype.lj  \
              -side left
  switch $fax(printertype) {
      ps      { $p2.frprintertype.ps     select }
      ljs     { $p2.frprintertype.ljs    select }
      lj      { $p2.frprintertype.lj     select }
      default { $p2.frprintertype.auto   select }
  }

  label       $p2.frprintcmd.lab -text $m(printcmd) -relief groove -fg blue -width 15 -anchor w
  entry       $p2.frprintcmd.ent -width 19
  pack        $p2.frprintcmd.lab -side left
  pack        $p2.frprintcmd.ent -side left -padx 4
              $p2.frprintcmd.ent insert 0 $fax(printcmd)

  label       $p2.frprintcmd.labx -text $m(Xreso) -width 15 -anchor e
  entry       $p2.frprintcmd.xreso -width 10
  label       $p2.frprintcmd.unitx -text dpi -anchor w
  pack        $p2.frprintcmd.labx $p2.frprintcmd.xreso $p2.frprintcmd.unitx \
              -side left -padx 4
              $p2.frprintcmd.xreso insert 0 $fax(printerXreso)

  label       $p2.frprinterPaper.lab   -text $m(printerPaper) -relief groove -fg blue -width 15 -anchor w
  radiobutton $p2.frprinterPaper.papA4  -text "A4"     -variable ckprinterPaper -value "a4" -width 4 -anchor w
  radiobutton $p2.frprinterPaper.papLet -text "Letter" -variable ckprinterPaper  -value "letter"  -anchor w
  radiobutton $p2.frprinterPaper.papLeg -text "Legal"  -variable ckprinterPaper -value "legal"  -anchor w
  pack  $p2.frprinterPaper.lab $p2.frprinterPaper.papA4 $p2.frprinterPaper.papLet $p2.frprinterPaper.papLeg -side left
  switch $fax(faxPaper) {
      letter  { $p2.frprinterPaper.papLet select }
      legal   { $p2.frprinterPaper.papLeg select }
      a4 -
      default { $p2.frprinterPaper.papA4  select }
  }
#  label       $p2.frprintermargin.dummy -width 10
  label       $p2.frprintermargin.labx -text $m(Xmargin) -width 15 -anchor e
  label       $p2.frprintermargin.unitx -text inches -width 8 -anchor w
  entry       $p2.frprintermargin.xmgn -width 10
  pack        $p2.frprintermargin.labx -side left -padx 4
  pack        $p2.frprintermargin.xmgn $p2.frprintermargin.unitx -side left
              $p2.frprintermargin.xmgn insert 0 $fax(printerXmargin)
  label       $p2.frprintermargin.laby -text $m(Ymargin) -width 16 -anchor e
  entry       $p2.frprintermargin.ymgn -width 10
  label       $p2.frprintermargin.unity -text inches -anchor w
  pack        $p2.frprintermargin.laby -side left -padx 4
  pack        $p2.frprintermargin.ymgn $p2.frprintermargin.unity -side left
              $p2.frprintermargin.ymgn insert 0 $fax(printerYmargin)
  
#  label $p2.frcleartmpdiratexit.lab -text $m(atexit)  -relief groove -fg blue -width 15 -anchor w
#  checkbutton $p2.frcleartmpdiratexit.var -text $m(cleartmpdiratexit) -variable fax(cleartmpdiratexit)  -anchor w
#  pack $p2.frcleartmpdiratexit.lab  $p2.frcleartmpdiratexit.var -side left 

  #----------------------------------------------------------------------
  # Configure 2 (Appearance)
  #----------------------------------------------------------------------
  label  $p3.lab13 -text "$m(font) 1"
  entry  $p3.ent13 -width 60
         $p3.ent13 insert  0 $fax(f1)
  grid   $p3.lab13 -column 0 -row 13 -sticky e
  grid   $p3.ent13 -column 1 -columnspan 4 -row 13 -sticky w

  label  $p3.lab14 -text "$m(font) 2"
  entry  $p3.ent14 -width 60
         $p3.ent14 insert  0 $fax(f2)
  grid   $p3.lab14 -column 0 -row 14 -sticky e
  grid   $p3.ent14 -column 1 -columnspan 4 -row 14 -sticky w

  label  $p3.lab15 -text "$m(font) 3"
  entry  $p3.ent15 -width 60
         $p3.ent15 insert  0 $fax(f3)
  grid   $p3.lab15 -column 0 -row 15 -sticky e
  grid   $p3.ent15 -column 1 -columnspan 4 -row 15 -sticky w

  label  $p3.lab16 -text "$m(button)$m(text)$m(color)"
  entry  $p3.ent16 -width 30
         $p3.ent16 insert  0 $fax(c1)
  button $p3.but16 -text $m(select_color) -background skyblue -command {
           set color_code [tk_chooseColor -initialcolor $fax(c1) -parent .]
           if {$color_code != ""} { $p3.ent16 delete 0 end
                                    $p3.ent16 insert 1 $color_code }
  }
  grid   $p3.lab16 -column 0 -row 16 -sticky e
  grid   $p3.ent16 -column 1 -columnspan 3 -row 16 -sticky w
  grid   $p3.but16 -column 4 -columnspan 1 -row 16 -sticky w

  label  $p3.lab17 -text "$m(window)$m(background)$m(color)"
  entry  $p3.ent17 -width 30
         $p3.ent17 insert 1 [option get .st background ""]
  button $p3.but17 -text  $m(select_color) -background skyblue -command {
           set color_code [tk_chooseColor -title "Background Color"\
               -initialcolor [option get .st background ""] -parent .]
           if {$color_code != ""} { $p3.ent17 delete 0 end
                                    $p3.ent17 insert 1 $color_code
                                    option add *background $color_code }
  }
  grid   $p3.lab17 -column 0 -row 17 -sticky e
  grid   $p3.ent17 -column 1 -columnspan 3 -row 17 -sticky w
  grid   $p3.but17 -column 4 -columnspan 1 -row 17 -sticky w

  label  $p3.lab18 -text "$m(window)$m(forground)$m(color)"
  entry  $p3.ent18 -width 30
         $p3.ent18 insert 1 [option get .st foreground ""]
  button $p3.but18 -text  $m(select_color) -background skyblue -command {
           set color_code [tk_chooseColor -title "Foreground Color"\
               -initialcolor [option get .st foreground ""]  -parent .]
           if {$color_code != ""} { $p3.ent18 delete 0 end
                                    $p3.ent18 insert 1 $color_code
                                    option add *foreground $color_code }
  }
  grid   $p3.lab18 -column 0 -row 18 -sticky e
  grid   $p3.ent18 -column 1 -columnspan 3 -row 18 -sticky w
  grid   $p3.but18 -column 4 -columnspan 1 -row 18 -sticky w

  label  $p3.lab19 -text "$m(active)$m(background)$m(color)"
  entry  $p3.ent19 -width 30
         $p3.ent19 insert 1 [option get .st activeBackground ""]
  button $p3.but19 -text  $m(select_color) -background skyblue -command {
           set color_code [tk_chooseColor -title "Active Background Color"\
               -initialcolor [option get .st activeBackground ""] -parent .]
           if {$color_code != ""} { $p3.ent19 delete 0 end
                                    $p3.ent19 insert 1 $color_code
                                    option add *activeBackground $color_code }
  }
  grid   $p3.lab19 -column 0 -row 19 -sticky e
  grid   $p3.ent19 -column 1 -columnspan 3 -row 19 -sticky w
  grid   $p3.but19 -column 4 -columnspan 1 -row 19 -sticky w

  label  $p3.lab20 -text "$m(active)$m(forground)$m(color)"
  entry  $p3.ent20 -width 30
         $p3.ent20 insert 1 [option get .st activeForeground ""]
  button $p3.but20 -text  $m(select_color) -background skyblue -command {
           set color_code [tk_chooseColor -title "Active Foreground Color"\
               -initialcolor [option get .st activeForeground ""] -parent .]
           if {$color_code != ""} { $p3.ent20 delete 0 end
                                    $p3.ent20 insert 1 $color_code
                                    option add *activeForeground $color_code }
  }
  grid   $p3.lab20 -column 0 -row 20 -sticky e
  grid   $p3.ent20 -column 1 -columnspan 3 -row 20 -sticky w
  grid   $p3.but20 -column 4 -columnspan 1 -row 20 -sticky w

  label  $p3.lab21 -text "$m(select)$m(background)$m(color)"
  entry  $p3.ent21 -width 30
         $p3.ent21 insert 1 [option get .st selectBackground ""]
  button $p3.but21 -text  $m(select_color) -background skyblue -command {
           set color_code [tk_chooseColor -title "Selected Background Color"\
               -initialcolor [option get .st selectBackground ""] -parent .]
           if {$color_code != ""} { $p3.ent21 delete 0 end
                                    $p3.ent21 insert 1 $color_code
                                    option add *selectBackground $color_code }
  }
  grid   $p3.lab21 -column 0 -row 21 -sticky e
  grid   $p3.ent21 -column 1 -columnspan 3 -row 21 -sticky w
  grid   $p3.but21 -column 4 -columnspan 1 -row 21 -sticky w

  label  $p3.lab22 -text "$m(select)$m(forground)$m(color)"
  entry  $p3.ent22 -width 30
         $p3.ent22 insert 1 [option get .st selectForeground ""]
  button $p3.but22 -text   $m(select_color) -background skyblue -command {
           set color_code [tk_chooseColor -title "Selected Foreground Color"\
               -initialcolor [option get .st selectForeground ""] -parent .]
           if {$color_code != ""} { $p3.ent22 delete 0 end
                                    $p3.ent22 insert 1 $color_code
                                    option add *selectForeground $color_code }
  }
  grid   $p3.lab22 -column 0 -row 22 -sticky e
  grid   $p3.ent22 -column 1 -columnspan 3 -row 22 -sticky w
  grid   $p3.but22 -column 4 -columnspan 1 -row 22 -sticky w

  #----------------------------------------------------------------------
  # Letter head
  #----------------------------------------------------------------------

  label  $p4.lab0 -text ""    ;# Dummy for space
  grid   $p4.lab0 -column 0 -row 0

  foreach i "1 2 3" {
    label  $p4.lab$i -text "$m(header) $i"
    entry  $p4.ent$i -width 72
           $p4.ent$i insert  0 $cover(head$i)
    grid   $p4.lab$i -column 0 -row $i
    grid   $p4.ent$i -column 1 -row $i -sticky wens
  }

  label  $p4.lab4 -text "$m(from)"
  entry  $p4.ent4 -width 64
         $p4.ent4 insert  0 $cover(from) 
  grid   $p4.lab4 -column 0 -row 4
  grid   $p4.ent4 -column 1 -row 4 -sticky wens

  grid columnconfigure $p4 1 -weight 1

  #----------------------------------------------------------------------
  # Repetitive texts
  #----------------------------------------------------------------------

  label  $p5.lab5 -text ""    ;# Dummy for space
  grid   $p5.lab5 -column 0 -row 5

  foreach i "1 2 3 4 5 6" {
    set r [expr $i+5]
    label  $p5.lab$r -text "$m(phrase) $i"
    text   $p5.txt$r -width 64 -height 3 -yscrollcommand "$p5.scr$r set"
           $p5.txt$r insert 1.0 $cover(pat$i)
    scrollbar $p5.scr$r -command "$p4.txt$r yview" -orient vertical
    grid   $p5.lab$r -column 0 -row $r -sticky we
    grid   $p5.txt$r -column 1 -row $r -sticky wens
    grid   $p5.scr$r -column 2 -row $r -sticky ns
    grid rowconfigure    $p5 $r -weight 1 -minsize 3
  }

#  label  $p4.lab12 -text ""    ;# Dummy for space
#  grid   $p4.lab12 -column 0 -row 12

  grid columnconfigure $p5 1 -weight 1
}
#--------------------------------------------------------------------------
# ե (~/.tkfax/config.tcl) 򹹿
#--------------------------------------------------------------------------
# 6 Sep 2001
# 25 Aug 2001 fax(usrlocale)
proc UpdateConf {} {

  global  fax m p1 p2 p3 p4 p5
  global  ckusrlocale ckfaxagent ckviewer ckxterm cklatex
  global  ckfaxPaper ckprintertype ckprinterPaper
  global directories

  if { $ckusrlocale == "other" } { set ckusrlocale [$p2.frusrlocale.ent get] } 
  if { $ckviewer == "other" } { set ckviewer [$p2.frviewer.ent get] } 
  if { $ckxterm == "other" } { set ckxterm [$p2.frxterm.ent get] } 

  set coverhead1 "[$p4.ent1  get]"
  set coverhead2 "[$p4.ent2  get]"
  set coverhead3 "[$p4.ent3  get]"
  set coverfrom  "[$p4.ent4  get]"
  regsub -all \n  [$p5.txt6  get 1.0 end] {} coverpat1
  regsub -all \n  [$p5.txt7  get 1.0 end] {} coverpat2
  regsub -all \n  [$p5.txt8  get 1.0 end] {} coverpat3
  regsub -all \n  [$p5.txt9  get 1.0 end] {} coverpat4
  regsub -all \n  [$p5.txt10 get 1.0 end] {} coverpat5
  regsub -all \n  [$p5.txt11 get 1.0 end] {} coverpat6

  set configfile $fax(userconfigfile)
  if { [string compare  $fax(config_version) "0.99b"] < 0 } {
       file rename -force $configfile $configfile.old
       file copy $fax(libdir)/fax-conf.tcl $configfile
       set saveold 0
       fax_message "New config file $configfile is created."
  } else { set saveold 1 }
  set rf [open $configfile r]
  set wf [open $configfile.temp w+]

# ʲset[  ] (tab)(space) äƤ롣

# foreach line [split [read $rfileid] \n] ;# ȥե뤬1ԤNG
  while { [gets $rf line] >= 0 } {
    switch -regexp -- $line {
      ^$                    {puts $wf $line  ;#        }
      ^#                    {puts $wf $line  ;# ȹ }

 {^set[	 ]*fax\(usrlocale\)}      {puts $wf "set fax(usrlocale)      \{$ckusrlocale\}"}
 {^set[	 ]*fax\(faxagent\)}    {puts $wf "set fax(faxagent)    \{$ckfaxagent\}"}
 {^set[	 ]*fax\(viewer\)}      {puts $wf "set fax(viewer)      \{$ckviewer\}"}
 {^set[	 ]*fax\(xterm\)}      {puts $wf "set fax(xterm)       \{$ckxterm\}"}
 {^set[	 ]*fax\(latex\)}      {puts $wf "set fax(latex)       \{$cklatex\}"}
 {^set[	 ]*fax\(mpage\)}      {puts $wf "set fax(mpage)      \{[$p2.frmpage.ent get]\}"}

 {^set[	 ]*fax\(faxPaper\)}   {puts $wf "set fax(faxPaper)	\{$ckfaxPaper\}"}
 {^set[	 ]*fax\(faxXmargin\)} {puts $wf \
                            "set fax(faxXmargin)	\{[$p2.frfaxmargin.xmgn get]\}"}
 {^set[	 ]*fax\(faxYmargin\)} {puts $wf \
                            "set fax(faxYmargin)	\{[$p2.frfaxmargin.ymgn get]\}"}
 {^set[	 ]*fax\(printertype\)} {puts $wf "set fax(printertype) \{$ckprintertype\}"}
 {^set[	 ]*fax\(printcmd\)}    {puts $wf "set fax(printcmd)   \{[$p2.frprintcmd.ent get]\}"}
 {^set[	 ]*fax\(printerXreso\)} {puts $wf \
                                 "set fax(printerXreso)	\{[$p2.frprintcmd.xreso get]\}"}
 {^set[	 ]*fax\(printerPaper\)}   {puts $wf "set fax(printerPaper)	\{$ckprinterPaper\}"}
 {^set[	 ]*fax\(printerXmargin\)} {puts $wf \
                               "set fax(printerXmargin)	\{[$p2.frprintermargin.xmgn get]\}"}
 {^set[	 ]*fax\(printerYmargin\)} {puts $wf \
                               "set fax(printerYmargin)	\{[$p2.frprintermargin.ymgn get]\}"}

 {^set[	 ]*cover\(head1\)} {puts $wf "set cover(head1) \{$coverhead1\}"}
 {^set[	 ]*cover\(head2\)} {puts $wf "set cover(head2) \{$coverhead2\}"}
 {^set[	 ]*cover\(head3\)} {puts $wf "set cover(head3) \{$coverhead3\}"}
 {^set[	 ]*cover\(from\)}  {puts $wf "set cover(from)  \{$coverfrom\}"}
 {^set[	 ]*cover\(pat1\)}  {puts $wf "set cover(pat1)  \{$coverpat1\}"}
 {^set[	 ]*cover\(pat2\)}  {puts $wf "set cover(pat2)  \{$coverpat2\}"}
 {^set[	 ]*cover\(pat3\)}  {puts $wf "set cover(pat3)  \{$coverpat3\}"}
 {^set[	 ]*cover\(pat4\)}  {puts $wf "set cover(pat4)  \{$coverpat4\}"}
 {^set[	 ]*cover\(pat5\)}  {puts $wf "set cover(pat5)  \{$coverpat5\}"}
 {^set[	 ]*cover\(pat6\)}  {puts $wf "set cover(pat6)  \{$coverpat6\}"}
 {^set[	 ]*fax\(f1\)}      {puts $wf "set fax(f1)      \{[$p3.ent13 get]\}"}
 {^set[	 ]*fax\(f2\)}      {puts $wf "set fax(f2)      \{[$p3.ent14 get]\}"}
 {^set[	 ]*fax\(f3\)}      {puts $wf "set fax(f3)      \{[$p3.ent15 get]\}"}
 {^set[	 ]*fax\(c1\)}      {puts $wf "set fax(c1)      \{[$p3.ent16 get]\}"}
 {^set[	 ]*fax\(cleartmpdiratexit\)}  {   puts $wf "set fax(cleartmpdiratexit)     $fax(cleartmpdiratexit)" } 

  {^option add \*background} {puts $wf \
   "option add *background        [$p3.ent17 get]"}

  {^option add \*foreground} {puts $wf \
   "option add \*foreground        [$p3.ent18 get]"}

  {^option add \*activeBackground} {puts $wf \
   "option add *activeBackground  [$p3.ent19 get]"}

  {^option add \*activeForeground} {puts $wf \
   "option add *activeForeground  [$p3.ent20 get]"}

  {^option add \*selectBackground} {puts $wf \
   "option add *selectBackground  [$p3.ent21 get]"}

  {^option add \*selectForeground} {puts $wf \
   "option add *selectForeground  [$p3.ent22 get]"}

      default {
          set flag 1
          set n 0
          foreach i $directories {
              set n [expr $n+1]
              if { [regexp "^set\[	 \]*fax\\(${i}dir\\)" $line] } {
                  puts $wf "set fax(${i}dir)	\{[$p1.ent$n get]\}"
                  set flag 0
               }
          }
          if  $flag   {puts $wf $line  ;# 嵭ʳι }
      }
    }
  }

  close $rf
  close $wf
  if $saveold {
     file rename -force $configfile $configfile.old
  }
  file rename  -force $configfile.temp $configfile
}
#--------------------------------------------------------------------------
# Help
#--------------------------------------------------------------------------
proc DispHelp {} {
# 11 Seo 2001 use fax_help
  global fax m gifdir helpdir
  fax_help "Config Help" $m(confighelp)

}

#-----------------------------------------------------------------
# 18 Jan 2002
proc LoadDefault {win} {
  global fax m

  if { [tk_dialog .dialog "TkFax: $m(load_default)" \
            "$m(abandon_config) $m(is_it_ok)" {warning} 1 $m(ok) $m(cancel) ] } {
            return 1
  }
  source $fax(libdir)/fax-conf.tcl
  set e [autoconfig]
  if { $e != "" } { fax_message "$e$m(is_not_available)" }
  destroy $win
  FaxConfigure
}
#===========================================================================
# ΥդΡȥ֥åΥץϡMark Harrison ʪ
# Ǥʰ¤Ƥޤˡ
# http://www.awl.com/cp/efftcl/efftcl.html ǸƤޤ
#
# ͡Ƕɤν Effective Tcl/Tk
#       Mark Harrison/Michael McLennan  ˮ: ISBN4-7561-3165-4
# ----------------------------------------------------------------------
#  panedwindow facility, notebook, tabnotebook, HSB color editor
# ----------------------------------------------------------------------
#  Effective Tcl/Tk Programming
#    Mark Harrison, DSC Communications Corp.
#    Michael McLennan, Bell Labs Innovations for Lucent Technologies
#    Addison-Wesley Professional Computing Series
# ======================================================================
#  Copyright (c) 1996-1997  Lucent Technologies Inc. and Mark Harrison
# ======================================================================

#===========================================================================
# Ρȥ֥å
#===========================================================================
proc notebook_create {win} {

  global nbInfo

  frame  $win -class Notebook
  pack   propagate $win 0

  set    nbInfo($win-count)   0    ;# ڡ
  set    nbInfo($win-pages)   ""   ;# ڡΥꥹ
  set    nbInfo($win-current) ""   ;# ߤΥڡ̾
  return $win                      ;# Ρȥ֥å֤̾
}
#===========================================================================
# Ρȥ֥å˿ڡä
#===========================================================================
proc notebook_page {win name} {

  global nbInfo

  set page "$win.page[incr nbInfo($win-count)]"
  lappend nbInfo($win-pages) $page
  set     nbInfo($win-page-$name) $page
  frame $page
  if {$nbInfo($win-count) == 1} {
      after idle [list notebook_display $win $name]
  }
  return $page
}
#===========================================================================
# Ρȥ֥åΥڡɽ
#===========================================================================
proc notebook_display {win name} {

  global nbInfo

  set page ""
  if {[info exists nbInfo($win-page-$name)]} {
        set page $nbInfo($win-page-$name)
  } elseif {[winfo exists $win.page$name]} {
        set page $win.page$name
  }
  if {$page == ""} {
    error "bad notebook page \"$name\""
  }

  notebook_fix_size $win

  if {$nbInfo($win-current) != ""} {
      pack forget $nbInfo($win-current)
  }
  pack $page -expand yes -fill both
  set nbInfo($win-current) $page
}
#===========================================================================
# Ρȥ֥åŬڤʥ
#===========================================================================
proc notebook_fix_size {win} {

  global nbInfo

  update idletasks

  set maxw 0
  set maxh 0
  foreach page $nbInfo($win-pages) {
      set w [winfo reqwidth $page]
      if {$w > $maxw} {
          set maxw $w
      }
      set h [winfo reqheight $page]
      if {$h > $maxh} {
          set maxh $h
      }
  }
  set bd   [$win cget -borderwidth]
  set maxw [expr $maxw+2*$bd]
  set maxh [expr $maxh+2*$bd]
  $win configure -width $maxw -height $maxh
}
#===========================================================================
# ֥Ρȥ֥å
#===========================================================================
proc tabnotebook_create {win} {

  global tnInfo

  frame  $win -class Tabnotebook
  canvas $win.tabs -highlightthickness 0
  pack   $win.tabs -fill x

  notebook_create $win.notebook
  pack   $win.notebook -expand yes -fill both

  set tnInfo($win-tabs)    ""    ;# ̾Υꥹ
  set tnInfo($win-current) ""    ;# ɽƤڡΥ̾
  set tnInfo($win-pending) ""    ;# 
  return $win
}
#===========================================================================
# ֥Ρȥ֥åΥڡ
#===========================================================================
proc tabnotebook_page {win name} {

  global tnInfo

  set page [notebook_page $win.notebook $name]
  lappend tnInfo($win-tabs) $name

  if {$tnInfo($win-pending) == ""} {
      set id [after idle [list tabnotebook_refresh $win]]
      set tnInfo($win-pending) $id
  }
  return $page
}
#===========================================================================
# ֤ΥåȤ褹
#===========================================================================
proc tabnotebook_refresh {win} {

  global tnInfo

  $win.tabs delete all
  set  margin [option get $win margin   Margin]
  set  color  [option get $win tabColor Color ]
  set  x      2
  set  maxh   0

  foreach name $tnInfo($win-tabs) {
      set id [$win.tabs create text \
             [expr $x+$margin+2] [expr -0.5*$margin] \
             -anchor sw -text $name -tags [list $name]]
      set bbox [$win.tabs bbox $id]
      set wd   [expr [lindex $bbox 2]-[lindex $bbox 0]]
      set ht   [expr [lindex $bbox 3]-[lindex $bbox 1]]
      if {$ht > $maxh} {
          set maxh $ht
      }

      $win.tabs create polygon 0 0 $x 0 \
          [expr $x+$margin]     [expr -$ht-$margin] \
          [expr $x+$margin+$wd] [expr -$ht-$margin] \
          [expr $x+$wd+2*$margin] 0 \
          2000 0 2000 10 0 10 \
          -outline black -fill $color \
          -tags [list $name tab tab-$name]

      $win.tabs raise $id

      $win.tabs bind $name <ButtonPress-1> \
       [list tabnotebook_display $win $name]

      set x [expr $x+$wd+2*$margin]
  }
  set height [expr $maxh+2*$margin]
  $win.tabs move all 0 $height

  $win.tabs configure -width $x -height [expr $height+4]

  if {$tnInfo($win-current) != ""} {
      tabnotebook_display $win $tnInfo($win-current)
  } else {
      tabnotebook_display $win [lindex $tnInfo($win-tabs) 0]
  }
  set tnInfo($win-pending) ""
}
#===========================================================================
# ڡ򤹤
#===========================================================================
proc tabnotebook_display {win name} {

  global tnInfo

  notebook_display $win.notebook $name

  set  normal [option get $win tabColor Color]
  $win.tabs itemconfigure tab -fill $normal

  set  active [option get $win activeTabColor Color]
  $win.tabs itemconfigure tab-$name -fill $active
  $win.tabs raise $name

  set tnInfo($win-current) $name
}
