# You can copy this file in your home directory as ~/.tkfax/config.tcl
# and change the settings.
# Do not make any space before the keyword 'set'.
#
global env
set fax(config_version) 1.0
# 27 Jan 2002

#  25 Nov 2001 for debugging
set fax(debug) 0

# Directories and file names
set fax(curdir)		[pwd]
set fax(userdir)	$env(HOME)/.tkfax
set fax(tmpdir)		$fax(userdir)/tmp
set fax(pbookdir)	$fax(userdir)/pbook
set fax(texdir)		$fax(userdir)/tex
set fax(systexdir)	$fax(libdir)/tex
set fax(spooldir)	/var/spool/fax
set fax(incomingdir)	/var/spool/fax/incoming
set fax(outgoingdir)	/var/spool/fax/outgoing
set fax(logdir)	        /var/log/fax
set fax(attachdir)  $fax(curdir)
set fax(sentdir)     $fax(userdir)
set fax(rcvdir)      $fax(userdir)
set fax(coverdir)      $fax(userdir)
set fax(faxprefix)  fax
set fax(rcvprefix)  rcv

# 25 Aug 2001 usrlolale
# Set your language {C}, {ja},...
# leave it {} for autoset from env LANG
set fax(usrlocale) {}

# fax paper size {a4}, {letter} or {legal}
set fax(faxPaper) {a4}
set fax(faxXreso)    204.1
set fax(faxYreso)    195.6
# dead space per each side
set fax(faxXmargin) 0
set fax(faxYmargin) 0.2

# printer
# printer command {lpr}, {lpr -Plp0},{lp} etc. 
set fax(printcmd)	{}
# printer type: {lj}, {ljs}, {ps},{efax}
set fax(printertype)	{}
# Next settings affects only in case you chose {ljs} or {ps}  as the printer type.
# In case of efax, edit the variable 'PRINT' in /etc/efax.rc or in ~/.efaxrc
set fax(printerPaper)     {a4}
set fax(printerXreso)     300
# printerYreso is asumed =printerXreso if zero
set fax(printerYreso)     0
# spaces per each side
set fax(printerXmargin)   0.45
set fax(printerYmargin)   0.85

# papers
set paperList {
    { a4    8.26389 11.6944 }
    { b4    9.84722 13.9167 }
    { legal 8.5        14.0      }
    { letter 8.5        11.0      }
}

# asumed resolutions of the source image files
set fax(resoList) { 75 150 }

# fax agent {sendfax} or {efax}
set fax(faxagent) {}

# viewer {viewfax},{fax view}, {xloadimage}, {kfax}, {ghfaxviewer}, etc.
set fax(viewer)	{}

# otherexternal commands
#set fax(mpage)		{mpage -1 -o -m30l}
#set fax(mpage)     {a2ps --columns=1 --borders no --margin=30 -R -B}
set fax(mpage)      {}
# font size cannot be selected ?!
set fax(mpageFont) {Courier}
set fax(ghostscript)	{gs}
#set fax(gstextfont)	{Courier-Bold10}
# latex, platex, none
set fax(latex)		{}
# kterm, rxvt, xterm, ...
set fax(xterm)		{}

# next are obsolute
set fax(convert)	{convert}
set fax(dvips)		{dvips}
set fax(pgmtopbm)	{pgmtopbm}
set fax(pbm2ps)		{pbmtolps}
#set fax(pbmscale)	{pnmscale -xsize 2479 -ysize 3508 2>/dev/null | pgmtopbm -fs}
#set fax(pbmtolj)	"pgmtopbm | pbmtolj -resolution $fax(printerReso)"
# your favorite editor {xterm -e vi}, {emacs}, {gedit}, {vedit}, etc.
#set fax(editcmd) {gedit}

# dithering method
set fax(pgmtopbmOptionList) {
    { photo floyd }
    { halftone cluster3 }
    { linart threshold}
}
#
# Initial settings
set dithering_method 1
set fax(dithering_method) [lindex [lindex $fax(pgmtopbmOptionList) $dithering_method ] 1]

set fax(spooling) 0
set fax(queueautoupdate) 1
set fax(queueautoupdateperiod) 30
set fax(queueshowjobs) w
set fax(receivedcollectpages) 1
set fax(cleartmpdiratexit) 0
#

# Custom styles
# 'Japan' shall be replaced by Japanese charactor if the locale is 'ja' 
set fax(custom) {
    { {English}   en }
    { {Japan} ja }
    { {Korean} kr }
    { {Aux} aux }
}
set fax(customstyle) 0

#===========================================================================
#  Headers and Phrases
# Use '\n' for newline 
#===========================================================================
set cover(head1) "Cool Penguins group"
set cover(head2) "South street, somewhere, South Pole, the Antarctic"
set cover(head3) "TEL: 03-xxxx-5x86    FAX: 03-xxxx-6x86"
set cover(from)  "My Name <mayumi@xxxxxx.yy.jp>"
set cover(pat1)  "To whom which may concern,\n"
set cover(pat2)  "Please find the attached per your request."
set cover(pat3)  "Sincerely yours,\n"
set cover(pat4)  "With best regards,\n"
set cover(pat5)  "դη\n"
set cover(pat6)  "̻(    )տ夲ޤ"
#===========================================================================

#
# Fonts and colors

set fax(f1) "-adobe-courier-normal-r-*--12-120-*-*-*-*-*-*"
set fax(f2) "-adobe-helvetica-bold-r-*--14-140-*-*-*-*-*-*"
set fax(f3) "-adobe-helvetica-bold-r-*--16-160-*-*-*-*-*-*"

set fax(c1) "blue"

#
# Window configurations

option add *background		#dfdfdf
option add *foreground		#000000
option add *activeBackground 	#ffc0cb
option add *activeForeground	#000000
option add *selectBackground	#ffc0cb
option add *selectForeground	#000000

#==========================================================================


