# This file is a part of TkFax.
# fax-faxwin.tcl   27 Jan 2002

#
# Main window of TkFax
#

proc fax_main_window { wn } {
    global fax m

    #
    # Principal frames -- three horizontal frames

    set fax(mwn) $wn
    frame $wn.t -bd 1 -relief ridge
    frame $wn.m -bd 1
    frame $wn.b -bd 2 -relief groove
    pack $wn.t  -side top -fill both
    pack $wn.m $wn.b -side top -fill both -expand yes

    #
    # Top frame: menus ===============================
    # 
    set w $wn.t
#    button $w.1 -text $m(quit) -command fax_exit -width 8 -relief groove
#    button $w.2 -text  $m(config) -command FaxConfigure -width 8 -relief groove
    menubutton $w.1 -text $m(file)  -menu $w.1.m -width 8 -underline 0
    menubutton $w.2 -text $m(config)  -menu $w.2.m -width 8 -underline 0
    menubutton $w.3 -text $m(logs)  -menu $w.3.m -width 8 -underline 0
    menubutton $w.4 -text $m(help)    -menu $w.4.m -width 8 -underline 0
    label $w.l -text "$fax(progname) $fax(ex_version)" \
          -pady 0 -padx 4 -fg red -font $fax(f2)
    pack $w.1 $w.2 $w.3  $w.4 -side left
    pack $w.l -side right
    menu $w.1.m -tearoff false
    menu $w.2.m -tearoff false
    menu $w.3.m -tearoff false
    menu $w.4.m -tearoff false
    $w.1.m add command -label  $m(new_session) -command fax_delete_all 
    $w.1.m add separator
    $w.1.m add command -label  $m(quit) -command fax_exit 
    $w.2.m add command -label "$m(edit_config_file)"      -command FaxConfigure
    $w.2.m add command -label  $m(load_default)    -command { LoadDefault .st }
    $w.3.m add command -label  $m(lookup_logs) -command fax_log_browse
    $w.4.m add command -label $m(about)  -command fax_about
    $w.4.m add command -label $m(guide)  -command fax_guide
 
    #
    # Main (or middle) frame ===============================
    # Three vertical frames:
    # Page List + Page manipulation buttons + Dialing & queuing

    set wm $wn.m
    frame $wm.1 -bd 5
    frame $wm.2 -bd 5
    frame $wm.3 -bd 5
    pack $wm.3  -side right -fill x -expand yes
    pack $wm.2  -side right -expand no
    pack $wm.1 -side right -fill both -expand yes

    #
    # Page List -----------------

    set wl $wm.1
    label $wl.1 -text $m(page_list)
    listbox $wl.2 -width 20 -height 9 -font $fax(f1) -fg $fax(c1) \
            -yscrollcommand "$wl.3 set" -xscrollcommand "$wl.4 set"
    mscroll $wl.2
    scrollbar $wl.3 -orient vertical   -command "$wl.2 yview"
    scrollbar $wl.4 -orient horizontal -command "$wl.2 xview"
    label $wl.5 -text "" -padx 7 -pady 0 -relief sunken
    grid $wl.1 -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.2 -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.3 -row 1 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.4 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.5 -row 2 -column 1 -rowspan 1 -columnspan 1
    grid columnconfigure $wl 0 -weight 1
    grid rowconfigure $wl 1 -weight 1

    #
    # Page Operations -----------------
    # Label and Buttons for page operations

    set wo $wm.2
    label $wo.0 -text $m(page_manipulation)
    button $wo.1 -text $m(custom)     -command fax_mkpg_custom \
           -width 5 -pady 4 -background \#66cdaa
    set slabel [lindex [lindex $fax(custom) $fax(customstyle)] 0]
    menubutton $wo.2 -text $slabel -menu $wo.2.m \
           -width 7 -padx 3 -pady 5 -relief raised -background \#66cdaa
    menu $wo.2.m -tearoff false
    for {set i 0} {$i < [llength $fax(custom)]} {incr i} {
        set slabel [lindex [lindex $fax(custom) $i] 0]
        $wo.2.m add command -label $slabel -command \
            "set fax(customstyle) $i; $wo.2 configure -text \"$slabel\""
    }
    button $wo.3 -text $m(file)       -command fax_file_window \
           -width 5 -pady 4 -background \#66cdaa
    button $wo.4 -text $m(scan)       -command fax_scan_window \
           -width 5 -pady 4 -background \#66cdaa
    button $wo.5 -text $m(up)         -command fax_up_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.6 -text $m(down)       -command fax_down_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.7 -text $m(view)       -command fax_view_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.8 -text $m(view_all)   -command fax_view_all \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.9 -text $m(save)       -command fax_save_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.a -text $m(save_all)   -command fax_save_all \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.b -text $m(print)      -command fax_print_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.c -text $m(print_all)  -command fax_print_all \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.d -text $m(delete)     -command fax_delete_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.e -text $m(delete_all) -command fax_delete_all \
           -width 5 -pady 0 -background \#20b2aa
    grid $wo.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news -pady 1
    grid $wo.1 -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.2 -row 1 -column 1 -rowspan 1 -columnspan 1              -pady 1
    grid $wo.3 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.4 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.5 -row 3 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.6 -row 3 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.7 -row 4 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.8 -row 4 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.9 -row 5 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.a -row 5 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.b -row 6 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.c -row 6 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.d -row 7 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.e -row 7 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1

    #
    # Dialing  & Queuing -----------------
    # horizontal frames

    set wd $wm.3
    frame $wd.1 -bd 0
    frame $wd.2 -bd 0
    frame $wd.3 -bd 2 -relief groove
    frame $wd.4 -bd 0
    pack $wd.1 $wd.3 $wd.2 $wd.4 -side top -expand yes -fill x

    #
    # Label Dialing & Queuing

    label $wd.1.1 -text $m(dialing_and_queuing)
    pack $wd.1.1 -side left -fill x -expand yes

    #
    # Numeric buttons, Phone book, Fax queuing and received buttons

    set wb $wd.2

    foreach i { 1 2 3 4 5 6 7 8 9 0 - < } {
        button $wb._$i -text $i -command "fax_dial $i" \
               -width 1 -padx 4 -pady 0 -background #87ceeb
    }
    button $wb._C -text $m(clear) -command "fax_dial C" \
           -width 5 -padx 2 -pady 0 -background #add8e6
    button $wb._R -text $m(regist) -command "fax_dial R" \
           -width 5 -padx 2 -pady 0 -background #add8e6
    button $wb.pb -text $m(phone_book)   -command fax_phonebook \
           -width 12 -padx 0 -pady 0 -background #b0c4de

    button $wb.fr -text $m(fax_received) -command fax_received_window \
             -background \#afeeee
    frame $wb.sf -bd 2 -relief groove
    label $wb.sf.fs -text $m(fax_spool) 
    checkbutton $wb.sf.pd -text $m(spooling) -variable fax(spooling) 
    button $wb.sf.fo -text $m(fax_outgoing) -command fax_queue_window \
            -background \#afeeee
    pack $wb.sf.fs $wb.sf.pd $wb.sf.fo -side top -fill both -expand yes

    grid $wb._1  -row 2 -column 0 -rowspan 1 -columnspan 1
    grid $wb._2  -row 2 -column 1 -rowspan 1 -columnspan 1
    grid $wb._3  -row 2 -column 2 -rowspan 1 -columnspan 1
    grid $wb._4  -row 3 -column 0 -rowspan 1 -columnspan 1
    grid $wb._5  -row 3 -column 1 -rowspan 1 -columnspan 1
    grid $wb._6  -row 3 -column 2 -rowspan 1 -columnspan 1
    grid $wb._7  -row 4 -column 0 -rowspan 1 -columnspan 1
    grid $wb._8  -row 4 -column 1 -rowspan 1 -columnspan 1
    grid $wb._9  -row 4 -column 2 -rowspan 1 -columnspan 1
    grid $wb._0  -row 5 -column 0 -rowspan 1 -columnspan 1
    grid $wb._-  -row 4 -column 3 -rowspan 1 -columnspan 1
    grid $wb._<  -row 4 -column 4 -rowspan 1 -columnspan 1
    grid $wb._C  -row 2 -column 3 -rowspan 1 -columnspan 2
    grid $wb._R  -row 3 -column 3 -rowspan 1 -columnspan 2
    grid $wb.pb  -row 5 -column 1 -rowspan 1 -columnspan 5
    grid $wb.sf  -row 3 -column 6 -rowspan 3 -columnspan 1 -sticky wens
    grid $wb.fr  -row 2 -column 6 -rowspan 1 -columnspan 1 -sticky wens
    grid columnconfigure $wb 6 -weight 1

    label $wd.3.1 -text $m(number)    -width 8 -anchor w
    entry $wd.3.2 -textvariable fax(number) \
          -width 20 -font $fax(f1) -fg $fax(c1)
    label $wd.3.3 -text $m(recipient) -width 8 -anchor w
    entry $wd.3.4 -textvariable fax(recipient) \
          -width 20 -font $fax(f1) -fg $fax(c1)
    grid $wd.3.1 -row 1 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wd.3.2 -row 1 -column 2 -rowspan 1 -columnspan 1 -sticky news
    grid $wd.3.3 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wd.3.4 -row 2 -column 2 -rowspan 1 -columnspan 1 -sticky news
    grid columnconfigure $wd.3 2 -weight 1

    #
    # RECEIVE and SEND button
    button $wd.4.1 -text $m(send) -command fax_SEND \
           -width 10 -pady 4 -background #4682b4
    if { $fax(receivefax) != {} } {
      button $wd.4.0 -text $m(receive) -command fax_RECEIVE \
           -width 10 -pady 4 -background #4682b4
      pack $wd.4.0 $wd.4.1 -side left -fill x -expand yes
    } else {
      pack $wd.4.1 -side left -fill x -expand yes
    }
    # ===============================

    #
    # Dialog channel

    label $wn.b.0 -text $m(message) -pady 4
    label $wn.b.1 -anchor w -fg red -wraplength 6i -justify left
    pack $wn.b.0 $wn.b.1 -side left

    #
    # For global window calling

    set fax(pagelist) $wl.2
    set fax(messagewin) $wn.b.1

    #
    # Mouse button binding and tagging on Window

    bind $fax(pagelist) <Double-Button-1> fax_view_page

    #
    # Initialization
    # 13 Jan 2002
#    set faxes ""
#    cd $fax(tmpdir)
#    catch { set faxes [ exec sh -c "ls *.g3" ] }
#    cd $fax(curdir)
#    fax_addto_pagelist $faxes

      set file $fax(tmpdir)/pagelist
      if [file exist $file] {
           source $file
      }
     fax_update_pagelist
  
      #
      # closing proccess before deleting main window
  
      wm protocol $wn. WM_DELETE_WINDOW {\
          fax_exit
          exit
      }

}

#
# Procedures for Page Operations
#

proc fax_up_page {} {
    global fax
    if {[set t [$fax(pagelist) curselection]] != {} && $t > 0} {
        set u [expr $t-1]
        set tmp $fax($u)
        set fax($u) $fax($t)
        set fax($t) $tmp
        fax_update_pagelist
        $fax(pagelist) selection set $u
    }
}

proc fax_down_page {} {
    global fax
    if {[set t [$fax(pagelist) curselection]] != {}
        && $t < [expr $fax(c)-1]} {
        set u [expr $t+1]
        set tmp $fax($u)
        set fax($u) $fax($t)
        set fax($t) $tmp
        fax_update_pagelist
        $fax(pagelist) selection set $u
    }
}

proc fax_view_page {} {
    global fax m
    fax_message ""
    if {[set t [$fax(pagelist) curselection]] != {}} {
    fax_view_fax $fax(tmpdir)/$fax($t)
#        fax_exec_bg "$fax(viewer) $fax(tmpdir)/$fax($t)"
    } else { fax_message $m(no_pages_selected) }
}

# 4 Sep 2001 use fax_view_fax
# 25 Aug 2001 add efax
proc fax_view_all {} {
    global fax m
    fax_message ""
    if $fax(c) {
        switch -- [file tail $fax(viewer)] {
            xloadimage -
            ghfaxviewer {
                set q [tk_dialog .dialog "TkFax view page " \
                      "$m(unable_function)" {error} 0 $m(ok)]
            }
            default {
                for {set pages ""; set i 0} {$i < $fax(c)} {incr i} {
                    append pages " $fax(tmpdir)/$fax($i)"
                }
                 fax_view_fax $pages
            }
        }
    }
}

# 27 Jan 2002 initialdir
# 7 Jan 2002 use tk_getSaveFile
proc fax_save_page {} {
    global fax m
    set m(procname) $m(save)
    fax_message ""
    if {[set t [$fax(pagelist) curselection]] != {}} {

        set fax(sppn) $fax($t)
#        set fax(spfn) $fax(curdir)/$fax($t)
        set ftypes {
            { "Fax files" {.g3} }
            { "All types" * }
        }
        set fname [tk_getSaveFile -initialdir $fax(sentdir) -filetypes $ftypes  \
                  -parent . -initialfile $fax($t) -defaultextension .g3 ]
        if { $fname == "" } {
            fax_message ""
            return
        } else {
            set fax(spfn) $fname
            fax_exec "cp $fax(tmpdir)/$fax(sppn) $fax(spfn)"
            fax_message "$fax(sppn)$m(was_saved_as)$fax(spfn)."
        }
    } else { fax_message $m(no_pages_selected) }
}

# 27 Jan 2002
proc fax_save_all {} {
    global fax m
    set m(procname) $m(save)
    fax_message ""
    if $fax(c) {
        set ftypes {
            { "Fax files" {.g3} }
            { "All types" * }
        }
        set fname [tk_getSaveFile -initialdir $fax(sentdir) -filetypes $ftypes  \
                  -parent . -initialfile $fax(faxprefix) -defaultextension .g3 ]
        if { $fname == "" } {
            fax_message ""
            return
        } else {
            set fax(sppf) [file rootname $fname]
            for {set i 0} {$i < $fax(c)} {incr i} {
                set fn $fax(sppf)-[format "%02d" $i].g3
                fax_exec "cp $fax(tmpdir)/$fax($i) $fn"
            }
            fax_message "$m(all_pages_were_saved_as)$fax(sppf)-##.g3"
        }

    }
}

proc fax_print_page {} {
# 8 Sep 2001 error trap
    global fax m
    set m(procname) $m(print)
    fax_message "$m(procname):"
    if {[set i [$fax(pagelist) curselection]] != {}} {
        set code [fax_print_fax "$fax(tmpdir)/$fax($i)"]
        if $code return
        fax_message "$fax($i) $m(sent_to_printer)"
    } else { fax_message $m(no_pages_selected) }
}

proc fax_print_all {} {
    global fax m
    set m(procname) $m(print)
    fax_message "$m(procname):"
   if $fax(c) {
        for {set i 0} {$i < $fax(c)} {incr i} {
            set code [fax_print_fax "$fax(tmpdir)/$fax($i)"]
            if $code break
        }
        if $code return
        fax_message  $m(all_sent_to_printer)
    }
}

proc fax_delete_page {} {
    global fax m
    set m(procname) $m(delete)
    fax_message ""
     if {[set t [$fax(pagelist) curselection]] != {}} {
        set page $fax($t)
        set k [tk_dialog .dialog "TkFax Page Delete" \
        "$m(delete_a_page) $page?" {warning} 1 $m(confirm) $m(cancel)]
        if {$k==1} { return }
        exec rm -f $fax(tmpdir)/$page
        for {set i $t} {$i < [expr $fax(c)-1]} {incr i} {
            set fax($i) $fax([expr $i+1])
        }
        incr fax(c) -1
        fax_update_pagelist
        if {$t < $fax(c)} {
            $fax(pagelist) selection set $t
        } else {
            $fax(pagelist) selection set [expr $t-1]
        }
        fax_message "$page $m(deleted)"
    } else { fax_message $m(no_pages_selected) }
}

proc fax_delete_all {} {
    global fax m
    set m(procname) $m(delete)
    fax_message ""
#    if {$fax(c)==0} { return }
    set k [tk_dialog .dialog "TkFax Page Delete" \
    "$m(delete_all_pages)?" {warning} 1 $m(confirm) $m(cancel)]
    if {$k==1} { return }
#    for {set i 0} {$i<$fax(c)} {incr i} {
#        exec rm -f $fax(tmpdir)/$fax($i)
#    }
#    exec rm -f $fax(tmpdir)/*
    fax_clear_tmpdir
    set fax(c) 0
    $fax(pagelist) delete 0 end
    fax_message "$m(all_pages) $m(deleted)"
}

proc fax_dial { i } {
    global fax m
    if {$i=="R"} {
        if { $fax(number) != {} } {
            set line "$fax(number)\t$fax(recipient)\t\t"
            lappend fax(group-Misc) $line
            fax_message \
                "Regist: $m(fax_number) $m(is_registered_in) Misc group."
        }
    } elseif {$i=="<"} {
        set fax(number) [string range $fax(number) 0 \
                            [expr [string length $fax(number)]-2]]
    } elseif {$i=="C"} {
        fax_number_clear
    } else {
        append fax(number) $i
    }
}

proc fax_number_clear {} {
    global fax
    set fax(number) ""
    set fax(recipient) ""
    set fax(reference) ""
    set fax(description) ""
}
