# This file is a part of TkFax.
# fax-file.tcl
# This is for converting files in various format to files in fax(g3) format
# and add them to the fax page list.
#  5 Mar 2002 fax_pbm2fax
# 27 Jan 2002 initialdir
# 15 Jan 2002 multiple file selection

proc fax_file_window {} {
#
# --- File Attachment Window ---
#
# 1 Sep 2001 dithering method swich
#
    global fax m

    # The name of the window
    set wn $fax(mwn).attach
    if [winfo exists $wn] {return}
    toplevel $wn
    set m(procname) $m(attach)
#    fax_message "$m(procname):"
    fax_message ""
    wm title $wn "TkFax: File Attachment"
    wm minsize $wn 320 380
    label $wn.1 -text "TkFax: File Attachment" -width 60 -pady 4 -relief ridge
    label $wn.2 -text $m(directory) -anchor w
    checkbutton $wn.t -text $m(show_hidden) -variable fax(lookupall) \
                -anchor w
    button $wn.u -text $m(update) -width 12 -command fax_update_filelist
    entry $wn.3 -width 30 -textvariable fax(curdir) -font $fax(f1) -fg $fax(c1)
    label $wn.4 -text $m(files) -width 12 -anchor w
    label $wn.5 -text "" -width 30 -anchor w -fg red
    listbox $wn.6 -width 28 -height 12 -font $fax(f1) \
            -yscrollcommand "$wn.7 set" -xscrollcommand "$wn.8 set" \
            -selectmode extended
    mscroll $wn.6
    scrollbar $wn.7 -orient vertical   -command "$wn.6 yview"
    scrollbar $wn.8 -orient horizontal -command "$wn.6 xview"
    frame $wn.9
    button $wn.a -text $m(attach) -command fax_attach_file -width 8 -pady 5
    button $wn.b -text $m(close)  -command "destroy $wn"   -width 6 -pady 5
    label $wn.c -text "" -padx 7 -pady 0 -relief sunken
    frame $wn.d

    grid $wn.1 -row 1 -column 0 -rowspan 1 -columnspan 4 -sticky news -pady 5
    grid $wn.2 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.t -row 2 -column 1 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.u -row 2 -column 3 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.3 -row 3 -column 0 -rowspan 1 -columnspan 4 -sticky news
    grid $wn.4 -row 4 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.5 -row 4 -column 1 -rowspan 1 -columnspan 3 -sticky news
    grid $wn.6 -row 5 -column 0 -rowspan 2 -columnspan 2 -sticky news
    grid  rowconfigure    $wn 5 -weight 1
    grid  columnconfigure $wn 0 -weight 1
    grid $wn.7 -row 5 -column 2 -rowspan 2 -columnspan 1 -sticky news
    grid $wn.8 -row 7 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.9 -row 5 -column 3 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.a -row 8 -column 0 -rowspan 1 -columnspan 2 -sticky news -pady 5
    grid $wn.b -row 8 -column 2 -rowspan 1 -columnspan 2 -sticky news -pady 5
    grid $wn.c -row 7 -column 2 -rowspan 1 -columnspan 1
    grid $wn.d -row 6 -column 3 -rowspan 2 -columnspan 1 -sticky news

    # Radiobuttons for selecting file types
    label $wn.9.0 -text $m(file_type) -width 8 -pady 0 -anchor w
    radiobutton $wn.9.1 -variable fax(attachfiletype) -value auto -text auto \
                        -width 6 -pady 0 -anchor w 
    radiobutton $wn.9.2 -variable fax(attachfiletype) -value fax -text fax \
                        -width 6 -pady 0 -anchor w 
    radiobutton $wn.9.3 -variable fax(attachfiletype) -value text -text text \
                        -width 6 -pady 0 -anchor w 
    radiobutton $wn.9.4 -variable fax(attachfiletype) -value tex -text tex \
                        -width 6 -pady 0 -anchor w 
    radiobutton $wn.9.5 -variable fax(attachfiletype) -value dvi -text dvi \
                        -width 6 -pady 0 -anchor w 
    radiobutton $wn.9.6 -variable fax(attachfiletype) -value ps -text ps \
                        -width 6 -pady 0 -anchor w 
    radiobutton $wn.9.7 -variable fax(attachfiletype) -value image -text image \
                        -width 6 -pady 0 -anchor w  
   pack $wn.9.0 $wn.9.1 $wn.9.2 $wn.9.3 \
         $wn.9.4 $wn.9.5 $wn.9.6 $wn.9.7  -side top

    # Dithering Method
    set j 0
    label $wn.d.0 -text $m(dithering_method) -width 12 -pady 0 -anchor w
    foreach i $fax(pgmtopbmOptionList) {
        set j [expr $j+1]
        set k [lindex $i 0]
        set l [lindex $i 1]
        radiobutton $wn.d.$j -variable fax(dithering_method) -value $l -text $m($k) \
                        -width 6 -pady 0 -anchor w 
    }
    pack $wn.d.0 $wn.d.1 $wn.d.2 $wn.d.3

    # Globally used widgets
    set fax(attachmsg) $wn.5
    set fax(filelist)  $wn.6

    # Keyboard and mouse bindings

    bind $wn.3 <KeyPress-Return> { cd $fax(attachdir) ; fax_update_filelist }
    bind $wn.6 <Double-Button-1> fax_attach_file

    # Initialization
    cd $fax(attachdir) ; set fax(curdir) [pwd]
    set fax(attachfiletype) auto
    fax_update_filelist
}

proc fax_update_filelist {} {
#
# Fills the filelist from the current directory.
# 31 Aug 2001 swicth showing hidden files
    global fax m
    $fax(filelist) delete 0 end
    if $fax(lookupall) { set option "-a" } else { set option "" } 
    set command "ls $option $fax(curdir)"
    set filelist [ fax_exec $command ]
    if { ! $fax(lookupall) } { set filelist ".. $filelist" }
    foreach i $filelist {
        if {[file isdirectory $fax(curdir)/$i] && $i!="."} {
            if { $i == ".." } { set i "$m(parent)" }
            $fax(filelist) insert end [format "%9s  %-17s" $m(directory) $i]
        }
    }
    foreach i $filelist {
        if { [file isfile $fax(curdir)/$i] } {
#            set backup [regexp {~$} $i]
            if { $fax(lookupall) || \
                 ! ( [regexp {~$} $i] || [regexp {^#} $i] )  } {
                set size [expr [file size $fax(curdir)/$i] / 1024.0]
                $fax(filelist) insert end [format "%6.0f  %-20s" $size $i]
            }
        }
    }
}

proc fax_attach_file {} {
#
# If currently selected file is a directory, change to that directory.
# If a ordinary file, try to convert it into g3 format and add to
# the fax page list.
#
    global fax m

    # 30 Aug 2001 Clear the message
    fax_attach_msg ""

    # When no file is selected, do nothing.
    if {[$fax(filelist) curselection]=={}} { return }


    # Get filename and test if it is a directory or a file.
    # If directory, list the files in that directory and return.
    set f [lindex [selection get] 1]
    if {$f=="$m(parent)"} { set f ".." }
    if [file isdirectory $fax(curdir)/$f] {
        set xx [expr [string last / $fax(curdir)]-1]
        if {$f==".."} {
            if {$xx < 0} { set fax(curdir) "/"
            } else { set fax(curdir) [string range $fax(curdir) 0 $xx] }
        } else {
            if {$fax(curdir)=="/"} { set fax(curdir) "/$f"
            } else { set fax(curdir) "$fax(curdir)/$f" }
        }
        fax_update_filelist
        return
    }
    set converted ""
    foreach i [$fax(filelist) curselection] {
        set f [lindex [$fax(filelist) get $i] 1]
        if { ! [fax_attach_f $f] } { set converted "$converted$f " }
    }
    fax_message "$converted $m(attached)"
    destroy $fax(mwn).attach
}

proc fax_attach_f { f } {
    global fax m
    # Divide the file name into prefix and surfix
    set xx [string last . $f]
    if {$xx < 0} {
        set prefix $f
        set surfix ""
    } else {
        set prefix [string range $f 0 [expr $xx-1]]
        set surfix [string range $f [expr $xx+1] end]
    }

    # Determine the type(format) of the file (from surfix).
    if {$fax(attachfiletype)=="auto"} {
        switch $surfix {
            g3      -
            fax     {set type fax}
            txt     -
            text    {set type text}
            tex     {set type tex}
            dvi     {set type dvi}
            eps     -
            ps      {set type ps}
            jpg     -
            gif     -
            png     -
            xpm     -
            xbm     -
            pnm     -
            ppm     -
            pgm     -
            pbm     {set type image}
            default {set type unknown}
        }
    } else {
        set type $fax(attachfiletype)
    }

    # Convert the file into g3 format and add it to the page list.

    # 1 Sep 2001 check with 'file' program
    if { $type == "unknown" } {
        set filetest [fax_exec "file $fax(curdir)/$f"]
        if { [string first {image} $filetest ]  >= 0 } { set type image }
        if { [string first {dvi}     $filetest ]  >= 0 } { set type dvi }
        if { [string first {text}    $filetest ]  >= 0 } { set type text  }
        if { [string first {ps}      $filetest ]  >= 0 } { set type ps }
    }
    # 30 Aug 2001 message
    fax_attach_msg "$m(converting) $f"

    # 8 Sep 2001 error trap
    set code 0
    switch $type {
        fax {
            set code [fax_exec_flag "cp -f $fax(curdir)/$f $fax(tmpdir)"]
            if { ! $code } {
                fax_addto_pagelist $f
            }
        }
        text {
            set code [fax_text2fax $fax(curdir)/$f]
        }
        tex {
            if { $fax(latex) == "" } {
                set code [fax_text2fax $fax(curdir)/$f]
            } else {
                set code [fax_tex2dvi $fax(curdir)/$f]
                if { ! $code } {
                    set code [fax_dvi2ps $prefix.dvi]
                }
                if { ! $code } {
                    set code [fax_ps2fax $prefix.ps]
                }
            }
        }
        dvi {
            if { $fax(dvips) == "" } {
                set code [fax_text2fax $fax(curdir)/$f]
            } else {
                set code [fax_dvi2ps $fax(curdir)/$f]
                if { ! $code } {
                    set code [fax_ps2fax $prefix.ps]
                }
            }
        }
        ps {
            set code [fax_ps2fax $fax(curdir)/$f]
        }
        image {
            set code [fax_image2fax $fax(curdir)/$f]
        }
        unknown {
            fax_attach_msg "$f $m(unkown_filetype)"
            return 1
        }
    }
    if { $code } {
        fax_attach_msg ""
        return 1
    }
    fax_attach_msg "$f $m(attached)"
    fax_message "$f $m(attached)"
    return 0
}

proc fax_attach_msg { msg } {
#
# Show messages on the file attach window.
#
    global fax
    $fax(attachmsg) configure -text $msg
    update
}

#
# File converting procedures
# All processes are done in fax(tmpdir) directory.
#

proc fax_text2fax { fn } {
#
# Convert a text file into g3 file using ghostscript and
# add it to the page list.
#
# 8 Sep 2001 error check of a2ps
# 4 Sep 2001 set options for mpage
# 3 Sep 2001 return code
# 29 Aug 2001 use fax_ps2fax
    global fax
    cd $fax(tmpdir)
    set prefix [get_prefix $fn]
    if [file_exist_check $fn] { return 1 }
    set file $prefix.ps
    if { [string first "mpage" $fax(mpage)] == 0 } { 
        set options "-b$fax(faxPaper) -F$fax(mpageFont)"
        set command "cat $fn | $fax(mpage) $options - > $file"
        set code [fax_exec_flag "$command"]
   } else {
        set command "cat $fn | $fax(mpage) -o - > $file 2> $fax(tkfaxlogfile)"
        set code [fax_exec_flag "$command"]
        if { [file size $file] == 0 } {
             set fid [open $fax(tkfaxlogfile) r]
             set log [gets $fid]
             close $fid
             tk_messageBox -message "$log\nwhen excuting:\n$command" -icon error -type ok
             set code 1
        }
   }
    if $code { return $code }
    return [fax_ps2fax $file]
}

#        -- gslp.ps -f$fax(gstextfont) -B $fn 2>/dev/null </dev/null"

proc fax_tex2dvi { fn } {
#
# Generate a dvi file from a tex file.
# 3 Sep 2001
    global fax
    if { $fax(latex) == "" } { return 1 }
    cd $fax(tmpdir)
    set prefix [get_prefix $fn]
    if {$prefix==$fn} {
        set file $fn.tex
    } else {
        set file $fn
    }
    if [file_exist_check $file] { return 1 }
    return [fax_exec_xterm "$fax(latex) $file"]
}

proc fax_dvi2ps { fn } {
#
# Generate a ps file from a dvi file.
# 3 Sep 2001 return code
# 30 Aug 2001 run dvips as a filter
# 1 Jul 2001 modified by Masaki Shinomiya
    global fax
    if { $fax(dvips) == "" } { return 1 }
    cd $fax(tmpdir)
    set prefix [get_prefix $fn]
#    if {$prefix==$fn} {
#        set file $fn.dvi
#    } else {
#        set file $fn
#    }
    if [file_exist_check $fn] { return 1 }
    return [fax_exec_xterm "$fax(dvips) -f  < $fn > $prefix.ps"]
}

proc fax_ps2fax { fn } {
#
# Convert a ps file to a g3 file using ghostscript and
# add it to the page list.
    # 8 Jan 2002 remove temporal files
# 3 Sep 2001 return code
# 30 Aug 2001 use faxXreso, faxYreso, faxPaper
# 29 Aug 2001 change device by the faxagent
# 1 Jul 2001 modified by Masaki Shinomiya
    global fax
    cd $fax(tmpdir)
    set prefix [get_prefix $fn]
    if {$prefix==$fn} {
        set file $fn.ps
    } else {
        set file $fn
    }
    if [file_exist_check $file] { return 1 }
    if { $fax(faxagent) == "sendfax" } {
          set device "faxg3"
    } else {
          set device "tiffg3"
    }
    set command "$fax(ghostscript) \
        -q -dNOPAUSE -sDEVICE=$device -r$fax(faxXreso)x$fax(faxYreso) \
        -sPAPERSIZE=$fax(faxPaper) \
        -sOutputFile=$prefix.%03d.g3 $file </dev/null"
    set code [fax_exec_flag $command]
    if { $code } { return $code }
    fax_exec_flag "rm -f  $prefix.pbm"
    set faxes [fax_exec "ls $prefix.\[0-9\]\[0-9\]\[0-9\].g3"]
    if { $faxes == "" } { return 1 }
    fax_addto_pagelist $faxes
    fax_exec "rm -f  $fax(tmpdir)/*.ps"
    return 0  
}

proc fax_pbm2fax { fn } {
# Dummy entry for TkScan   5 Mar 2002
    fax_image2fax $fn
}

proc fax_image2fax { fn } {
# Convert any image file into a pbm file using convert from ImageMagic.
# Dither by pgmtopbm
# Convert a pbm file into a g3 file using pbm2g3
# and add it to the page list.
#
# 2 Sep 2001
#
    global fax
    cd $fax(tmpdir)
    set prefix [get_prefix $fn]
    if [file_exist_check $fn] { return 1 }

    # maesure the image size
    set XY [get_image_size $fn ]
    set org(X) [lindex $XY 0]
    set org(Y) [lindex $XY 1]
    if $fax(debug) {
         tk_messageBox -message "$X x $Y"  -type ok
    }
    if { $org(X) <=0 } {return 1}

    # determin the scale factor
    foreach i {X Y} {
        set frame($i) $fax(fax${i}dots)
        set reso($i) $fax(fax${i}reso)
    }
    # means '$org(Y)*$orgReso(X)*reso(Y)/($org(X).0*$orgReso(Y)*reso(X))'
    # but asuming '$orgReso(X) == $orgReso(Y)'
    set aspect [expr $org(Y)*$reso(Y)/($org(X).0*$reso(X))]
    set zoom 0
    # need to enlarge ?  
    foreach i $fax(resoList) {
        set new(X) [expr 8*int($reso(X)*$org(X)/($i*8))]
        set new(Y) [expr int($aspect*$new(X))]
        if { $new(X) <= $frame(X) && $new(Y) <= $frame(Y) } {
               set zoom 1
               break
        }
    }
    if { $zoom < 1 } {
        # try to keep the original size
        if { $org(X) <= $frame(X) && $org(Y) <= $frame(Y) } {
            # but source width must be multiple of 8
            set new(X) [expr 8*int($org(X)/8)]
            if { $new(X) == $org(X) } {
                set new(Y) $org(Y)
                set zoom 0
            } else {
                set new(Y) [expr int($aspect*$new(X))]
                set zoom -1
            }
        } else {
            # zoom out
            set new(X) [expr 8*int($frame(X)/8)]
            set new(Y) [expr int($aspect*$new(X))]
            if { $new(Y) > $frame(Y) } {
                set new(X) [expr 8*int($frame(Y)/($aspect*8))]
                set new(Y) [expr int($aspect*$new(X))]
            }
            set zoom -1
        }
    }

    # adjust the size and convert into PGM
    set command "$fax(convert)  -geometry $new(X)x$new(Y)!  $fn $prefix.pgm"
    set code [fax_exec_flag  "$command"]
    if $code { return $code }

    # dither and make PBM
    set option "-$fax(dithering_method)"
    set command "pgmtopbm $option  $prefix.pgm > $prefix.pbm"
    set code [fax_exec_flag  "$command"]
    if $code { return $code }
    exec rm -f $prefix.pgm

    # ajusting position
    set option ""
    if { $fax(faxagent) == "efax" && $zoom != 0 } {
        set option "-r $fax(faxXreso)x$fax(faxYreso)"
        # calcurate displacements
        foreach i {X Y} {
            set disp($i) [expr ($frame($i)-$new($i))/(2*$reso($i))]
            set margin $fax(fax${i}margin)
            if { $margin &&  $margin < $disp($i) } {
                 set disp($i) $margin
            }
            set newin($i) [expr $new($i)/$reso($i)+$disp($i)]
        }
            set option "$option -p $newin(X)x$newin(Y) -d $disp(X)x$disp(Y)"
    }

# tk_messageBox -message "$frame(X)x$frame(Y)\n$new(X)x$new(Y)\n$option"  -type ok

    # convert into a fax file
    set command "$fax(pbm2g3) $option $prefix.pbm > $prefix.g3"
    if { $fax(faxagent) == "efax" } {
        set code [fax_exec_efix "$command"]
    } else {
        set code [fax_exec_flag  "$command"]
    }
    if $code { return $code }
    exec rm -f $prefix.pbm

    # add the page in the list 
    set faxes [fax_exec "ls $prefix.g3"]
    fax_addto_pagelist $faxes
    return 0
}

proc file_exist_check { fn } {
    global m
    if [file exists $fn] { return 0 }
    tk_messageBox -icon error -message "$fn $m(does_not_exist)"
    return 1
}
