# This file is a part of TkFax.
# fax-mkpg.tcl   28 Jan 2002

#
# This make a cover page.

proc fax_mkpg_custom {} {
#
# This procedure generate custom style fax.
#
# 19 Sep 2001 make the window expandable
#     look up mackfile and eliminate styfile
# 3 Sep 2001 Masaki Shinomiya
# 4 Jul 2001 Ryoji Kawagishi
# Oct 1998 Hang-Bae Kim

    global fax m lc

   set fax(tmpcover) $fax(tmpdir)/cover
   # If file already exists, ask whether to use old one or replace it
   if { [fax_check_cover] } { return 1 }

#    set file "tmp.cover"
#    if [file exist $file] {
#        after idle {.dialog.msg configure -wraplength 4i}
#        set i [tk_dialog .dialog "TkFax Dialog" \
#        "$file $m(is_already_exists)  $m(will_you_use_it_or_make_new_one)" \
#            {question} 0 $m(make_new_one) $m(use_exsiting_one) $m(cancel) ]
#        update
#    }

    set lc [ custom_locale ]
    set covmacro "covermacro-${lc}.tex"
    set macfile  "$fax(texdir)/$covmacro"
    if {![file exists $macfile]} { set macfile "$fax(systexdir)/$covmacro" }
    if {![file exists $macfile]} { 
         fax_message "MkPg: Fax custom macro file $macfile is not found."
         return 1
    }


    foreach i  { header cfax_number crecipient creference cdate cfrom ctitle contents } {
        if { [ info exists m(${i}_${lc})] } {
             set m(${i}_LC)  $m(${i}_${lc})
        } else {
             set m(${i}_LC)  $m(${i})
        }
    }

   fax-mkpg-win $covmacro $macfile

}
#--------------------------------------------------------------------------
# making fax cover page
#--------------------------------------------------------------------------
# 30 Sep 2001 change oder of 'from' item.
#
proc fax-mkpg-win { covmacro macfile } {

  global  fax m lc cover cmd_SetPageParm covfnsize

  toplevel .mkpg
  wm title .mkpg $m(mkpg)

  label  .mkpg.file   -text $m(file)   -background skyblue -relief raised 
  button .mkpg.date   -text $m(insert_date)      -background skyblue \
                      -command { InsertDate "" [ custom_locale ] }
  button .mkpg.time   -text $m(insert_time)      -background skyblue \
                      -command { InsertTime "" [ custom_locale ] }
  label  .mkpg.patn   -text $m(insert_phrase) -background skyblue -relief raised
  button .mkpg.cancel -text $m(cancel)   -background skyblue \
                      -command { destroy .mkpg }
  set cmd_SetPageParm [list SetPageParm $lc $covmacro $macfile]
  button .mkpg.make   -text $m(finish)   -background skyblue \
                      -command { eval $cmd_SetPageParm
                                 destroy .mkpg }

  menu   .mkpg.popupF -tearoff no
  .mkpg.popupF add command -label $m(insert_file) \
                           -command { InsertFile .mkpg.body }
  .mkpg.popupF add command -label $m(load_all_item) \
                           -command { LoadCovFile }
  .mkpg.popupF add command -label $m(save_all_item) \
                           -command { SaveCovFile }
  .mkpg.popupF add command -label $m(save_header) \
                           -command { SaveHeader }
  .mkpg.popupF add command -label $m(new_cover) \
                           -command { NewCover }

  menu   .mkpg.popupP -tearoff no
  .mkpg.popupP add command -label "$m(phrase) 1" -command {InsertPatn .mkpg.body 1}
  .mkpg.popupP add command -label "$m(phrase) 2" -command {InsertPatn .mkpg.body 2}
  .mkpg.popupP add command -label "$m(phrase) 3" -command {InsertPatn .mkpg.body 3}
  .mkpg.popupP add command -label "$m(phrase) 4" -command {InsertPatn .mkpg.body 4}
  .mkpg.popupP add command -label "$m(phrase) 5" -command {InsertPatn .mkpg.body 5}
  .mkpg.popupP add command -label "$m(phrase) 6" -command {InsertPatn .mkpg.body 6}

  bind   .mkpg.file <Button-1> {
      set x [ expr [ winfo rootx %W ] + %x ]
      set y [ expr [ winfo rooty %W ] + %y ]
      tk_popup .mkpg.popupF $x $y
  }
  bind   .mkpg.patn <Button-1> {
      set x [ expr [ winfo rootx %W ] + %x ]
      set y [ expr [ winfo rooty %W ] + %y ]
      tk_popup .mkpg.popupP $x $y
  }

  label       .mkpg.font   -text $m(char_size)
  radiobutton .mkpg.font10 -text "10$m(points)" -background skyblue \
                            -relief raised -variable covfnsize -value 10
  radiobutton .mkpg.font11 -text "11$m(points)" -background skyblue \
                            -relief raised -variable covfnsize -value 11
  radiobutton .mkpg.font12 -text "12$m(points)" -background skyblue  \
                            -relief raised -variable covfnsize -value 12
  button .mkpg.help  -text $m(help) -background skyblue \
                     -command { DispMkpgHelp }
  .mkpg.font10 select

  label  .mkpg.l1    -text "$m(header) 1"
  entry  .mkpg.head1 -textvariable header1 -width 80 -relief sunken
         .mkpg.head1 delete 0 end

  label  .mkpg.l2    -text "$m(header) 2"
  entry  .mkpg.head2 -textvariable header2 -width 80 -relief sunken
         .mkpg.head2 delete 0 end

  label  .mkpg.l3    -text "$m(header) 3"
  entry  .mkpg.head3 -textvariable header3 -width 80 -relief sunken
         .mkpg.head3 delete 0 end

  label  .mkpg.l4    -text "$m(cfax_number_LC):" -anchor e
  entry  .mkpg.faxno -textvariable fax(number) -width 40 -relief sunken \
                     -background cornsilk

  button .mkpg.fnbat -text $m(phone_book) -background skyblue \
                     -command {fax_phonebook}

  label  .mkpg.l5    -text "$m(crecipient_LC):" -anchor e
  entry  .mkpg.recip -textvariable fax(recipient) -width 80 -relief sunken \
                     -background cornsilk

  label  .mkpg.l6    -text "$m(creference_LC):" -anchor e
  entry  .mkpg.refer -textvariable fax(reference) -width 80 -relief sunken \
                     -background cornsilk

  label  .mkpg.l7    -text "$m(cdate_LC):" -anchor e
  entry  .mkpg.dtbox -textvariable date  -width 40 -relief sunken \
                     -background cornsilk
         .mkpg.dtbox delete 0 end

  label  .mkpg.l8    -text "$m(cfrom_LC):" -anchor e
  entry  .mkpg.from  -textvariable from  -width 80 -relief sunken
         .mkpg.from delete 0 end

  label  .mkpg.l9    -text "$m(ctitle_LC):" -anchor e
  text   .mkpg.title -width 80 -height 3 -background cornsilk \
         -yscrollcommand ".mkpg.title_s set"
         .mkpg.title delete 1.0 end
  scrollbar .mkpg.title_s -command ".mkpg.title yview" -orient vertical

  label  .mkpg.l10  -text "$m(contents_LC):" -anchor e
  text   .mkpg.body -width 80 -height 15 -background cornsilk \
         -yscrollcommand ".mkpg.body_s set"
         .mkpg.body delete 1.0 end
  scrollbar .mkpg.body_s -command ".mkpg.body yview" -orient vertical

  radiobutton .mkpg.bodytxt -text "Text" -background skyblue \
              -relief raised -variable cover(bodytype) -value text
  radiobutton .mkpg.bodyTeX -text "TeX" -background skyblue \
              -relief raised -variable cover(bodytype) -value TeX
   radiobutton .mkpg.lyx      -text "LyX" -background skyblue \
              -relief raised -variable cover(bodytype) -value LyX
 .mkpg.bodytxt select

  label  .mkpg.l15  -text ""


  grid .mkpg.file    -column 1 -columnspan 1 -row 0 -sticky news
  grid .mkpg.date    -column 2 -columnspan 1 -row 0 -sticky we
  grid .mkpg.time    -column 3 -columnspan 1 -row 0 -sticky we
  grid .mkpg.patn    -column 4 -columnspan 1 -row 0 -sticky news
  grid .mkpg.cancel  -column 5 -columnspan 1 -row 0 -sticky we
  grid .mkpg.make    -column 6 -columnspan 2 -row 0 -sticky we

  grid .mkpg.font    -column 0 -columnspan 1 -row 1 -sticky we
  grid .mkpg.font10  -column 1 -columnspan 1 -row 1 -sticky we
  grid .mkpg.font11  -column 2 -columnspan 1 -row 1 -sticky we
  grid .mkpg.font12  -column 3 -columnspan 1 -row 1 -sticky we
  grid .mkpg.help    -column 6 -columnspan 2 -row 1 -sticky we

  grid .mkpg.l1      -column 0 -columnspan 1 -row 2 -sticky we
  grid .mkpg.head1   -column 1 -columnspan 6 -row 2 -sticky we
  grid .mkpg.l2      -column 0 -columnspan 1 -row 3 -sticky we
  grid .mkpg.head2   -column 1 -columnspan 6 -row 3 -sticky we
  grid .mkpg.l3      -column 0 -columnspan 1 -row 4 -sticky we
  grid .mkpg.head3   -column 1 -columnspan 6 -row 4 -sticky we

  set fromto [string compare [string range $lc 0 1]  "ja"]
  set r 4
  if $fromto {
      set r [expr $r+1]
      grid .mkpg.l8      -column 0 -columnspan 1 -row $r -sticky we
      grid .mkpg.from    -column 1 -columnspan 6 -row $r -sticky we
 }
  set r [expr $r+1]
  grid .mkpg.l4      -column 0 -columnspan 1 -row $r -sticky we
  grid .mkpg.faxno   -column 1 -columnspan 4 -row $r -sticky we
  grid .mkpg.fnbat   -column 5 -columnspan 2 -row $r -sticky we

  set r [expr $r+1]
  grid .mkpg.l5      -column 0 -columnspan 1 -row $r -sticky we
  grid .mkpg.recip   -column 1 -columnspan 6 -row $r -sticky we

  set r [expr $r+1]
  grid .mkpg.l6      -column 0 -columnspan 1 -row $r -sticky we
  grid .mkpg.refer   -column 1 -columnspan 6 -row $r -sticky we

  set r [expr $r+1]
  grid .mkpg.l7      -column 0 -columnspan 1 -row $r -sticky we
  grid .mkpg.dtbox   -column 1 -columnspan 6 -row $r -sticky we

  if { ! $fromto} {
      set r [expr $r+1]
      grid .mkpg.l8      -column 0 -columnspan 1 -row $r -sticky we
      grid .mkpg.from    -column 1 -columnspan 6 -row $r -sticky we
 }

  grid .mkpg.l9      -column 0 -columnspan 1 -row 10 -sticky we
  grid .mkpg.title   -column 1 -columnspan 6 -row 10 -sticky we
  grid .mkpg.title_s -column 7 -columnspan 1 -row 10 -sticky ns

  grid .mkpg.l10     -column 0 -columnspan 1 -row 11 -sticky we
  grid .mkpg.body    -column 1 -columnspan 6 -row 11 -rowspan 4 -sticky wens
  grid .mkpg.body_s  -column 7 -columnspan 1 -row 11 -rowspan 4 -sticky ns
 
 grid .mkpg.bodytxt -column 0 -columnspan 1 -row 12 -sticky wen

  if { $fax(latex) != "" } {
      grid .mkpg.bodyTeX -column 0 -columnspan 1 -row 13 -sticky wen
      grid .mkpg.lyx     -column 0 -columnspan 1 -row 14 -sticky wen
  }

  grid .mkpg.l15     -column 0 -columnspan 1 -row 15 -sticky we

  grid rowconfigure .mkpg 11 -weight 1
  foreach i "1 2 3 4 5" {
      grid columnconfigure .mkpg $i -weight 1
  }

  balloonhelp_for .mkpg.popupP "\[$m(phrase) 1\]\n$cover(pat1)\n\[$m(phrase) 2\]\n$cover(pat2)\n\[$m(phrase) 3\]\n$cover(pat3)\n\[$m(phrase) 4\]\n$cover(pat4)\n\[$m(phrase) 5\]\n$cover(pat5)\n\[$m(phrase) 6\]\n$cover(pat6)"

  set address {number recipient reference}
  foreach i $address {
      set cover($i) $fax($i)
  }
  if [file exist $fax(tmpcover)] {
      load_cover $fax(tmpcover)
      if  { "$fax(number)" != "" } {
          foreach i $address {
              set cover($i) $fax($i)
         }
     }
     update_cover
  } else {
      .mkpg.head1 insert 0 $cover(head1)
      .mkpg.head2 insert 0 $cover(head2)
      .mkpg.head3 insert 0 $cover(head3)
      .mkpg.from  insert 0 $cover(from)
  }
    newtime_cover

  focus .mkpg.faxno
  set   curfocus .mkpg.faxno ;# Widget currently focused

  bind Text <ButtonRelease-1> { 
      set curfocus %W 
  }
  bind Entry <ButtonRelease-1> { 
      set curfocus %W
  }

}

proc new_cover {} {
  global  fax m lc cover cmd_SetPageParm covfnsize

  # ---- Display headers, date, from
#  .mkpg.head1 insert 0 $cover(head1)
#  .mkpg.head2 insert 0 $cover(head2)
#  .mkpg.head3 insert 0 $cover(head3)
#  .mkpg.from  insert 0 $cover(from)
#  InsertDate  .mkpg.dtbox $lc
#  InsertTime  .mkpg.dtbox $lc

#  foreach i { number recip refer dtbox from title body } { set  cover($i) "" }
  foreach i { number recipient reference } { set  cover($i) "$fax($i)" }
  foreach i { dtbox title body } { set  cover($i) "" }
  update_cover
  newtime_cover

  focus .mkpg.faxno
  set   curfocus .mkpg.faxno ;# Widget currently focused

#  bind Text <ButtonRelease-1> { 
#      set curfocus %W 
#  }
#  bind Entry <ButtonRelease-1> { 
#      set curfocus %W
#  }

}

proc NewCover {} {
  global  fax m lc cover cmd_SetPageParm covfnsize
  if { [tk_dialog .dialog "TkFax: NewCover" \
            "$m(abandon_cover) $m(is_it_ok)" {warning} 1 $m(ok) $m(cancel) ] } {
            return 1
  }
  new_cover
}
#--------------------------------------------------------------------------
# Insert text form a file
#--------------------------------------------------------------------------
# 27 Jan 2002
proc InsertFile { box } {
  global  fax m
  set ftypes {
       {"All types"           *       }
       {"Texts"     {.txt}  }
       {"C sources"  {.c}    }
       {"C headers"     {.h}    }
       {"Hyper texts"         {.html} }
  }
  set fname \
      [tk_getOpenFile -initialdir $fax(attachdir) -filetypes $ftypes -parent .]
  if { $fname == "" } {
      return
  } else {
      if { [ file readable $fname ] } {
           set   fileid   [ open $fname "r" ]
           set   contents [ read -nonewline $fileid ]
           close $fileid
           set   idx [ $box index insert ]
           $box insert $idx $contents
      }
  }
}
#--------------------------------------------------------------------------
# Save headers
#--------------------------------------------------------------------------
# 27 Jan 2002
proc SaveHeader {} {
  global  fax m cover

  if { [file exists $fax(userconfigfile)] != 1} {
       fax_error "SaveHeader: $fax(userconfigfile) $m(does_not_exits)"
  } else {
      set cover(head1) [.mkpg.head1 get]
      set cover(head2) [.mkpg.head2 get]
      set cover(head3) [.mkpg.head3 get]
      set cover(from)  [.mkpg.from  get]
      set new_head1 "set cover\(head1\) \{$cover(head1)\}"
      set new_head2 "set cover\(head2\) \{$cover(head2)\}"
      set new_head3 "set cover\(head3\) \{$cover(head3)\}"
      set new_from  "set cover\(from\)  \{$cover(from)\}"

      set rfileid  [open $fax(userconfigfile) r]
      set wfileid  [open $fax(userconfigfile).temp w+]
      while { [gets $rfileid line] >= 0 } {
          switch -regexp -- $line {
              ^$               { puts $wfileid $line  ;# null lines       }
              ^#               { puts $wfileid $line  ;# comment lines }
              {cover\(head1\)} { puts $wfileid $new_head1 }
              {cover\(head2\)} { puts $wfileid $new_head2 }
              {cover\(head3\)} { puts $wfileid $new_head3 }
              {cover\(from\)}  { puts $wfileid $new_from  }
              default          { puts $wfileid $line  ;# others }
          }
      }
      close $rfileid
      close $wfileid
      file rename -force $fax(userconfigfile) $fax(userconfigfile).old
      file rename $fax(userconfigfile).temp   $fax(userconfigfile)
  }
}
#--------------------------------------------------------------------------
# Load from *.cover file
#--------------------------------------------------------------------------
# 27 Jan 2002
proc LoadCovFile {} {
  global  fax m cover

  set ftypes {
      { "TkFax covers"  {.cover} }
      { "All types" * }
  }
  set fname [tk_getOpenFile -initialdir $fax(coverdir) -filetypes $ftypes \
                            -parent . ]
  if { $fname == "" } {
      return
  } else {
      load_cover $fname
      update_cover
  }
}

proc load_cover { fname } {
  global  fax m cover

  # for backward compatibility
  set old {faxno recip refer}
  set new {number recipient reference}
  foreach b $old { set cover($b) ""}
  source $fname
  set i 0; foreach b $old {
      if { "$cover($b)" != "" } { set cover([lindex $new $i]) "$cover($b)" }
      incr i
  }

#  update_cover
}

proc update_cover {} {
   global  fax m cover

  .mkpg.head1 delete 0 end   ; .mkpg.head1 insert 0   $cover(head1)
  .mkpg.head2 delete 0 end   ; .mkpg.head2 insert 0   $cover(head2)
  .mkpg.head3 delete 0 end   ; .mkpg.head3 insert 0   $cover(head3)
  .mkpg.faxno delete 0 end   ; .mkpg.faxno insert 0   $cover(number)
  .mkpg.recip delete 0 end   ; .mkpg.recip insert 0   $cover(recipient)
  .mkpg.refer delete 0 end   ; .mkpg.refer insert 0   $cover(reference)
  .mkpg.dtbox delete 0 end   ; .mkpg.dtbox insert 0   $cover(dtbox)
  .mkpg.from  delete 0 end   ; .mkpg.from  insert 0   $cover(from)
  .mkpg.title delete 1.0 end ; .mkpg.title insert 1.0 $cover(title)
  .mkpg.body  delete 1.0 end ; .mkpg.body  insert 1.0 $cover(body)
}

proc newtime_cover {} {
   global  fax lc m cover
  .mkpg.dtbox delete 0 end 
  InsertDate  .mkpg.dtbox $lc
  InsertTime  .mkpg.dtbox $lc
}

#--------------------------------------------------------------------------
# Save items to  *.cover file
#--------------------------------------------------------------------------
# 27 Jan 2002
proc SaveCovFile {} {
  global  fax m cover
  set current  [ clock seconds ]
  set datetime [ clock format $current -format "%Y_%m%d_%H%M.cover" ]

  set ftypes {
      { "TkFax covers" {.cover} }
      { "All types" * }
  }
  set fname [tk_getSaveFile -initialdir $fax(coverdir) -filetypes $ftypes \
                  -parent . -initialfile $datetime -defaultextension .cover ]
  if { $fname == "" } {
      return
  } else {
      save_cover $fname
  }
  return
}

# 17 Jan 2002 use \{ \} instead of \" \"
proc save_cover { fname } {
  global  fax m cover

  set cover(head1) [.mkpg.head1 get]
  set cover(head2) [.mkpg.head2 get]
  set cover(head3) [.mkpg.head3 get]
  set cover(number) [.mkpg.faxno get]
  set cover(recipient) [.mkpg.recip get]
  set cover(reference) [.mkpg.refer get]
  set cover(dtbox) [.mkpg.dtbox get]
  set cover(from)  [.mkpg.from  get]
  set cover(title) [string trimright [.mkpg.title get 1.0 end]]
  set cover(body)  [string trimright [.mkpg.body  get 1.0 end]]

  set head1 "set cover\(head1\) \{$cover(head1)\}"
  set head2 "set cover\(head2\) \{$cover(head2)\}"
  set head3 "set cover\(head3\) \{$cover(head3)\}"
  set faxno "set cover\(number\) \{$cover(number)\}"
  set recip "set cover\(recipient\) \{$cover(recipient)\}"
  set refer "set cover\(referce\) \{$cover(reference)\}"
  set dtbox "set cover\(dtbox\) \{$cover(dtbox)\}"
  set from  "set cover\(from\)  \{$cover(from)\}"
  set title "set cover\(title\) \{$cover(title)\}"
  set body  "set cover\(body\)  \{$cover(body)\}"

  set   contents "  $head1\n  $head2\n  $head3\n  $faxno\n  $recip\n \
                    $refer\n  $dtbox\n  $from\n   $title\n  $body"
  set   fileid   [ open $fname "w" ]
  puts  -nonewline $fileid $contents
  close $fileid
}

#--------------------------------------------------------------------------
# Make TeX file and convert into DVI, PS and FAX file
#--------------------------------------------------------------------------
# 28 Jan 2002 behavior in error
# 15 jan 2002 bypass fax_tex_char if plane
# 8 Jan 2002 save cover data
# 19 Sep 2001 use $lc
#
proc SetPageParm { lc covmacro macfile } {
  global fax m cover covfnsize

  save_cover $fax(tmpcover)

  append fsize $covfnsize "pt"

  set HEAD1    [.mkpg.head1 get]
  set HEAD2    [.mkpg.head2 get]
  set HEAD3    [.mkpg.head3 get]
  set RECIPIENT [.mkpg.recip get]
  set REFERENCE [.mkpg.refer get]
  set DATE      [.mkpg.dtbox get]
  set FROM      [.mkpg.from  get]
  set TITLE     [string trimright [.mkpg.title get 1.0 end]]

  set MESSAGE [string trimright [.mkpg.body  get 1.0 end]]

  set NUMBER  [num_encode [.mkpg.faxno get] ]
  set prefix cvr$NUMBER
    if { $fax(latex) == "" || $fax(latex) == "none" } {
        set suffix "text" } else { set suffix "tex"
    }
    set file     $fax(tmpdir)/$prefix.$suffix
    set NUMBER [fax_tex_char  [num_decode $NUMBER ]]

# Use plain text if TeX not available
#set fax(latex) ""
if { $fax(latex) == "" || $fax(latex) == "none" } {

   set work "\

      $HEAD1
      $HEAD2
      $HEAD3
==========================================================================
     $m(cfrom_LC): $FROM

     $m(cfax_number_LC):  $NUMBER
     $m(crecipient_LC): $RECIPIENT
     $m(creference_LC): $REFERENCE

     $m(cdate_LC): $DATE
==========================================================================
     $m(ctitle_LC): $TITLE
==========================================================================
     $m(contents_LC):

     $MESSAGE\n" 

  set file     $fax(tmpdir)/$prefix.txt
  set   fileid [ open $file "w" ]
  puts  -nonewline $fileid $work
  close $fileid
  set code [fax_text2fax $file]; if $code { return $code }

 } else {

  set HEAD1     [fax_tex_char $HEAD1]
  set HEAD2     [fax_tex_char $HEAD2]
  set HEAD3     [fax_tex_char $HEAD3]
  set RECIPIENT [fax_tex_char $RECIPIENT]
  set REFERENCE [fax_tex_char $REFERENCE]
  set DATE      [fax_tex_char $DATE]
  set FROM      [fax_tex_char $FROM]
  set TITLE     [fax_tex_char $TITLE]

# 8 Jan 2002 do not use {jarticle} for Japanese
  set article article
#  if {  $lc == "ja" } { set article jarticle } 
  append work \
      "%% LaTeX file generated by TkFax\n" \
      "\\documentclass\[$fsize\]\{$article\}\n"

  if { ($cover(bodytype) == "text") || ($cover(bodytype) == "TeX")} {
   append work \
    "\\input $macfile\n" \
    "\\HeadA\{$HEAD1\}\n" \
    "\\HeadB\{$HEAD2\}\n" \
    "\\HeadC\{$HEAD3\}\n" \
    "\\From\{$FROM\}\n" \
    "\\Faxnumber\{$NUMBER\}\n" \
    "\\Recipient\{$RECIPIENT\}\n" \
    "\\Reference\{$REFERENCE\}\n\n" \
    "\\Date\{$DATE\}\n" \
    "\\Title\{$TITLE\}\n" \
    "\\begin\{document\}\n" \
    "\\faxcontent\n"

    if { $cover(bodytype) == "text" } {
        append work \
        "\\begin\{verbatim\}\n" \
        "$MESSAGE\n" \
        "\\end\{verbatim\}\n" \
        "\\end\{document\}"
    } else {
        append work \
        "$MESSAGE\n" \
         "\\end\{document\}"
    }
  } else {
      append work \
      "\\textwidth 180mm\n" \
      "\\textheight 250mm\n" \
      "\\oddsidemargin -11mm\n" \
      "\\evensidemargin -7mm\n" \
      "\\topmargin -20mm\n" \
      "\\begin\{document\}\n" \
      "$HEAD1 \\\\ " \
      "$HEAD2 \\\\ " \
      "$HEAD3 \\\\ " \
      "$m(cfrom_LC): $FROM \\\\" \
      "$m(cfax_number_LC): $NUMBER \\\\" \
      "$m(crecipient_LC): $RECIPIENT \\\\" \
      "$m(creference_LC): $REFERENCE \\\\" \
      "$m(cdate_LC): $DATE \\\\" \
      "$m(ctitle_LC): $TITLE \\\\" \
      "$m(contents_LC): $MESSAGE \\\\" \
      "\\end\{document\}"
  }

  set file     $fax(tmpdir)/$prefix.tex
  set   fileid [ open $file "w" ]
  puts  -nonewline $fileid $work
  close $fileid

  if { $cover(bodytype) == "LyX" } {
      cd $fax(tmpdir)
      fax_exec_xterm "reLyX $file"
      fax_exec_xterm "lyx [file rootname $file].lyx"
  }

  # Running LaTeX and converting to fax
  # 28 Jan 2002 behavior in error
  # 3 Sep 2001 file names
  set prefix [get_prefix $file]
  set code [fax_tex2dvi $file]; if $code { return $code }
  set code [fax_dvi2ps $prefix.dvi]; if $code { return $code }
  set code [fax_ps2fax $prefix.ps]; if $code { return $code }
  }
  fax_exec "rm -f  $fax(tmpdir)/*.tex $fax(tmpdir)/*.aux $fax(tmpdir)/*.log \
                  $fax(tmpdir)/*.dvi $fax(tmpdir)/*.ps"
  fax_message "$prefix $m(attached)"
  return 0
}
#--------------------------------------------------------------------------
# Insert phrases
#--------------------------------------------------------------------------
proc InsertPatn { box num } {

  global  cover

  switch $num {
      1       { set pattern $cover(pat1) }
      2       { set pattern $cover(pat2) }
      3       { set pattern $cover(pat3) }
      4       { set pattern $cover(pat4) }
      5       { set pattern $cover(pat5) }
      6       { set pattern $cover(pat6) }
      default { set pattern "" }
  }
  set  idx [ $box index insert ]
  $box insert $idx $pattern
}
#--------------------------------------------------------------------------
# Insert date
#--------------------------------------------------------------------------
# 16 Dec 2001 japanese format
proc InsertDate { box lc } {
  global  curfocus

  set current [ clock seconds ]
  set year  [ clock format $current -format "%Y" ]
  set month [ clock format $current -format "%m" ]
  set day   [ clock format $current -format "%d" ]
  set months { Nul Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec }
  if { $lc=="ja" } {
    set week {        }
  } else {
    # 25 Aug 2001 to convert values from strings
    if { [ string range $month 0 0 ] == "0" } {
      set month [ string range $month 1 1 ]
    } 
    set month [ lindex $months $month ]
    set week { Sun Mon Tue Wed Thu Fri Sat }
  }
  set youbi   [ lindex $week [ clock format $current -format "%w" ]]

  if { $lc=="ja" } {
    set date "${year}ǯ${month}${day}($youbi) "
#    set date [clock format $current -format "%Yǯ%m%d($youbi) "]
  } elseif { $lc=="en" } {
    set date [clock format $current -format "$youbi, $month %d, %Y "]
  } else {
    set date [clock format $current -format "$youbi, %d $month %Y "]
  }
  if { $box == "" } {
      set idx [ $curfocus index insert ]
      $curfocus insert $idx $date
  } else {
      set  idx [ $box index insert ]
      $box insert $idx $date
  }
}
#--------------------------------------------------------------------------
# Insert time
#--------------------------------------------------------------------------
# 16 Dec 2001 japanese format
proc InsertTime { box lc } {
  global  curfocus

  set current [ clock seconds ]
  set hour  [ clock format $current -format "%H" ]
  set min   [ clock format $current -format "%M" ]
  if { $lc=="ja" } {
    set time "${hour}${min}ʬ "
  } else {
    set time [ clock format $current -format "%H:%M " ]
  }
  if { $box == "" } {
      set idx [ $curfocus index insert ]
      $curfocus insert $idx $time
  } else {
      set idx [ $box index insert ]
      $box insert $idx $time
  }
}
#--------------------------------------------------------------------------
# check locale for the cover page
#--------------------------------------------------------------------------
proc custom_locale {} {
    global fax
    set lc  [lindex [lindex $fax(custom) $fax(customstyle)] 1]
    return $lc
}

#--------------------------------------------------------------------------
# help for makeing cover page
#--------------------------------------------------------------------------
proc DispMkpgHelp {} {
  global m

  toplevel  .mkpghelp
  wm title  .mkpghelp "Tkfax Cover Page Help"

  text      .mkpghelp.txt -width 78 -height 30 \
                          -yscrollcommand ".mkpghelp.scr set"
  mscroll   .mkpghelp.txt
  scrollbar .mkpghelp.scr -command ".mkpghelp.txt yview" -orient vertical
  grid      .mkpghelp.txt .mkpghelp.scr -sticky news
  button    .mkpghelp.but -text $m(close) -command { destroy .mkpghelp }
  grid      .mkpghelp.but -padx 10 -pady 2

  .mkpghelp.txt insert end [ format "%s" $m(mkpghlp) ]
  .mkpghelp.txt insert end [ format "%s" $m(texhlp) ]
  .mkpghelp.txt configure -state disabled

  tkwait visibility .mkpghelp    ;# Ļ֤ˤʤΤԤ
}
#--------------------------------------------------------------------------
