# This file is a part of TkFax.
# fax-received.tcl
# 27 Jan 2002
proc fax_received_window {} {
#
# --- Fax Received Window ---
#
    global fax m

    if [info exist fax(mwn)] {
        set wn $fax(mwn).frw
        set wnn $wn
        if [winfo exist $wn] { return }
        toplevel $wn
        wm title $wn "TkFax: Fax Received"
    } else {
        set wn {}
        set wnn .
        wm title . "TkFax: Fax Received"
    }

    # Label of this window
    frame $wn.0 -bd 5
    pack $wn.0 -side top -fill x
    label $wn.0.1 -text "TkFax: Fax Received" \
          -padx 10 -pady 2 -relief ridge
    pack $wn.0.1 -side left -fill x -expand yes

    # Fax List
    frame $wn.4
    pack $wn.4 -side top

    frame $wn.4.0
    label $wn.4.0.0 -text $m(received_fax_list)
    checkbutton $wn.4.0.1 -variable fax(receivedcollectpages) \
                -text $m(collect_pages) -width 15
    button $wn.4.0.2 -text $m(update) -command fax_received_update \
           -width 8 -pady 2
    pack $wn.4.0.0 -side left
    pack $wn.4.0.2 $wn.4.0.1 -side right

    frame $wn.4.1
    label $wn.4.1.1 -text $m(time)  -anchor w -width 12 -padx 3 -relief ridge
    label $wn.4.1.2 -text $m(from)  -anchor w -width 19 -padx 3 -relief ridge
    label $wn.4.1.3 -text $m(pages) -anchor w -width  5 -padx 3 -relief ridge
    label $wn.4.1.4 -text $m(files) -anchor w -width 32 -padx 3 -relief ridge
    pack $wn.4.1.1 $wn.4.1.2 $wn.4.1.3 $wn.4.1.4 -side left -fill x

    text $wn.4.2 -width 72 -height 10 -state disabled \
         -tabs {3.2c left 8.5c left 9.5c left} -wrap none \
         -xscroll "$wn.4.3 set" -yscroll "$wn.4.4 set" \
         -relief sunken -font $fax(f1) 
    set fax(receivedlist) $wn.4.2
    scrollbar $wn.4.3 -command "$wn.4.2 xview" -orient horizontal
    scrollbar $wn.4.4 -command "$wn.4.2 yview"

    label $wn.4.5 -text "" -padx 7 -pady 0 -relief sunken
    label $wn.4.6 -text "" -padx 7 -pady 0 -relief sunken

    grid $wn.4.0  -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.4.1  -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.2  -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.3  -row 3 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.4  -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.5  -row 3 -column 1 -rowspan 1 -columnspan 1
    grid $wn.4.6  -row 1 -column 1 -rowspan 1 -columnspan 1

    # Message
    frame $wn.5 -bd 2
    pack $wn.5 -side top -fill x
    label $wn.5.1 -text $m(selected_files) -width 72 -anchor w
    entry $wn.5.2 -textvariable fax(receivedfile) -width 72 \
          -font $fax(f1) -fg $fax(c1)
    label $wn.5.3 -width 72 -pady 4 -relief ridge -anchor w \
          -wraplength 7.2i -justify left
    set fax(receivedmessage) $wn.5.3
    pack $wn.5.1 $wn.5.2 $wn.5.3 -side top -expand yes -fill x

    # Buttons for fax file operations
    frame $wn.6 -bd 5
    pack $wn.6 -side top -fill x
    button $wn.6.1 -text $m(view)   -command fax_received_view   -width 6
    button $wn.6.2 -text $m(print)  -command fax_received_print  -width 6
    button $wn.6.3 -text $m(save)   -command fax_received_save   -width 6
    button $wn.6.4 -text $m(delete) -command fax_received_delete -width 6
    button $wn.6.5 -text $m(attach) -command fax_received_attach -width 6
    button $wn.6.6 -text $m(close)  -command "destroy $wnn"      -width 6
    pack $wn.6.1 $wn.6.2 $wn.6.3 $wn.6.4 $wn.6.5 $wn.6.6 -side left -expand yes

    # When standalone, disable Attach button.
    if {$wn == {}} {
        $wn.6.5 configure -state disabled
    }

    # Mouse bindings
    bind $fax(receivedlist) <Button> fax_received_setcur
    bind $fax(receivedlist) <Double-Button> fax_received_view

    # Fill the received list
    fax_received_update

}

proc fax_received_setcur {} {
    global fax
    $fax(receivedlist) tag delete cur
    $fax(receivedlist) tag configure cur -foreground red -background skyblue
    $fax(receivedlist) tag add cur {current linestart} {current lineend +1 char}
    set line [$fax(receivedlist) get {current linestart} {current lineend}]
    set elements [split $line \t]
    set fax(receivedfile) [lindex $elements 3]
}

# 23 Aug 2001 Masaki Shinomiya
proc fax_received_update {} {
    global fax

    # Clear the received list window.
    $fax(receivedlist) configure -state normal
    $fax(receivedlist) delete 1.0 end

    # Get the received list from fax incoming directory.
    set faxr [open "|ls -l -t $fax(incomingdir)"]
    # Discard the first line.
    gets $faxr

    # Display the list.
    set rline [gets $faxr]
    while {"$rline" != {}} {
        set size  [lindex $rline 4]
        set time "[lindex $rline 5] [lindex $rline 6] [lindex $rline 7]"
        set name [lindex $rline 8]
        set prefix [lindex [split $name '.'] 0]
        set pages 1
        if { $size <256 } { set pages "ERR" }
        set files $name
        if $fax(receivedcollectpages) {
            while 1 {
                set rline [gets $faxr]
                set nname [lindex $rline 8]
                set nprefix [lindex [split $nname '.'] 0]
                if {"$nprefix" == "$prefix" } {
                    incr pages
                    set files "$nname $files"
                } else {
                    break
                }
            }
        } else {
            set rline [gets $faxr]
        }
        set sender [lindex [split $prefix '_'] 1]
        if { ( [regexp "^\[0-9\]" $files] || [regexp "_" $files] ) } {
           if {  ! $fax(receivedcollectpages) || $pages != "ERR" } {
               $fax(receivedlist) insert end "$time\t$sender\t$pages\t$files\n"
           }
        }
    }

    close $faxr
    $fax(receivedlist) delete {end -1 char}
    $fax(receivedlist) configure -state disabled
    set fax(receivedfile) ""
}

proc fax_received_view {} {
    global fax
    if {$fax(receivedfile) == {}} {return}
    set files ""
    foreach file $fax(receivedfile) {
        set files "$files $fax(incomingdir)/$file"
    }
    fax_view_fax $files
    fax_received_message "View: $fax(receivedfile)"
}

proc fax_received_print_each {files} { 
       global fax
        foreach file $files {
            fax_print_fax "$fax(incomingdir)/$file"
        }
}

proc fax_received_print {} {
    global fax m
    set m(procname) $m(print)
    if {$fax(receivedfile) == {}} {return}
    set wn .fp
    if [winfo exist $wn] { return }
    toplevel $wn
    wm title $wn "TkFax: Print"

    set fax(fpwn) $wn
    label $wn.0 -text "Print the fax \n$fax(receivedfile)\n" \
          -width 40 -wraplength 3.5i -pady 5
    button $wn.2 -text $m(ok)     -width 10 -command {
         fax_received_print_each $fax(receivedfile)
         destroy $fax(fpwn)
         fax_received_message "$fax(receivedfile) $m(sent_to_printer)"
    }
    button $wn.3 -text $m(cancel) -width 10 -command {
        destroy $fax(fpwn)
    }
    grid $wn.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.2 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 4
    grid $wn.3 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 4
}

# 27 Jan 2002
proc fax_received_save {} {
    global fax m
    fax_received_message ""
    if {$fax(receivedfile) == {}} {return}

       set prefix "fax"
#    set fax(sppf) $fax(curdir)
     set fname [tk_getSaveFile -initialdir $fax(rcvdir)  -parent .  -initialfile $fax(rcvprefix) ]
     if { $fname == "" } { return }
     set fax(sppf) [file rootname $fname]
      foreach i $fax(receivedfile) {
                set fn $fax(sppf)-$i
                fax_exec "cp $fax(incomingdir)/$i $fn"
       }
       fax_received_message "Saved: $fax(receivedfile)"
}

proc fax_received_delete {} {
    global fax m
    if {$fax(receivedfile) == {}} {return}
    set files ""
    foreach file $fax(receivedfile) {
        set files "$files $fax(incomingdir)/$file"
    }
    set k [tk_dialog .dialog "TkFax Fax Delete" \
        "$m(delete_the_fax)\n$fax(receivedfile)?" {warning} 0 $m(confirm) $m(cancel)]
    if {$k==1} { return }
    set command "rm -f $files"
    fax_exec $command
    fax_received_message "$fax(receivedfile) $m(deleted)"
    fax_received_update
}

proc fax_received_attach {} {
    global fax m
    if {$fax(receivedfile) == {}} {return}
    foreach file $fax(receivedfile) {
        fax_exec "cp -f $fax(incomingdir)/$file $fax(tmpdir)"
    }
    fax_addto_pagelist $fax(receivedfile)
    fax_received_message "$fax(receivedfile) sent to the page list"
    fax_message "$fax(receivedfile) $m(attached)"
}

proc fax_received_message { msg } {
    global fax
    $fax(receivedmessage) configure -text $msg
}

