#------------------------------------------------------------------------
# Epson scanner via SANE - epson.tcl - ver 0.12
# 22 Jun 2001 - Masaki SHINOMIYA <shino@pos.to>
#               OGAWA Hideo <fwht1046@mb.infoweb.ne.jp>
# This script supports only essential functions 
# just for the lmodel GT-7600S
# For other modeles, please add-on options  by yourself.
# 'scanimage --help' shows what options your scanner supports.
#------------------------------------------------------------------------

# Full scanning size in mm.
set s(mmx)           215.9
set s(mmy)           297.18
set s(mmperinch)      25.4
# Full scanning size. This should be in inches.
set s(scanwidth)	[expr $s(mmx)/$s(mmperinch)]
set s(scanheight)	[expr $s(mmy)/$s(mmperinch)]

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{5 600 5}
# resolution range which your scanner realy supports
set s(resolutionSupported) {50 2400}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"scanimage"

# Scanner device (leave empty for autodetection)
set s(device)		"epson"

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Speed}          m  speed       {yes no}       yes }
    { {Brightness}     r   brightness {-3 +3 1}         0 }
    { {Gamma}          r  gamma      {0.5 2.5 0.1}  1.0 }
}

set s(brightnessList) {
   {"Very light"} {Lighter} {Light} {Normal} {Dark} {Darker} {"Very dark"}
}

set s(modedepoptionList) {gamma}

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {}  }
    { Halftone  pbm   1  {gamma}      }
    { Gray      pgm   8  {gamma}      }
    { Color     ppm  24  {gamma}      }
}

# Options the driver supports
# 1 : support by scanner driver
# 0 : support by external (image editor, image converter) commands
set s(halftoning_support)	1
set s(gamma_support)	   0

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set prefix $file
    set tempfile  "$c(tkscandir)/$file.tmp"
    set file "$c(tkscandir)/$file.pnm"

    foreach j {tx ty bx by} { set $j [pixelto mm [expr $s($j$i)-$s(o)]] }
    if { $bx > $s(mmx) } { set bx $s(mmx) }
    if { $by > $s(mmy) } { set by $s(mmy) }
    set wd [expr $bx-$tx]
    set ht [expr $by-$ty]
    set geometry "-l $tx -t $ty -x $wd -y $ht"

    switch $s(mode) { 
        Lineart		{ 
             if $s(halftoning_support) {
                      set mode "--mode Binary --halftoning None"
              } else {
                      set mode "--mode Binary"
               }
                      set post "$tempfile pbm:$file"
        }
        Halftone    { 
               if $s(halftoning_support) {
                      set mode "--mode Lineart"
                      set post "$tempfile pbm:$file"
               } else {
                      set mode "--mode Gray"
                      set post "-dither -monocrome $tempfile pbm:$file"
              }
        }
        Gray		{ set mode "--mode Gray"
                      set post "$tempfile pgm:$file" }
        Color		{ set mode "--mode Color"
                      set post "$tempfile ppm:$file" }
    }

    set reso $s(resolution)
    set reso_min [lindex $s(resolutionSupported) 0 ]
    set reso_max [lindex $s(resolutionSupported) end ]
    if       { $reso < $reso_min } { set reso $reso_min
    } elseif { $reso > $reso_max } { set reso $reso_max }    
    set resolution "--resolution $reso"

    if { $s(device) != "" } {
             set device "--device-name $s(device)"
    } else { set device "" }

    set option ""
    if { $s(speed) != "yes" } {append option " --speed $s(speed)"}
    if { $s(brightness) } {
        set brightness [lindex $s(brightnessList) [expr 3-$s(brightness)]]
        append option "--brightness $brightness"
    }
    foreach i $s($s(mode)option) { switch $i {
      gamma { if $s(gamma_support) {
                  append option " --gamma $s(gamma)"}}
           }
    }

    set unit mm
    set wd [expr int($s(resolution)*$wd/$s(c$unit))] 
    set ht [expr int($s(resolution)*$ht/$s(c$unit))]

    set cmdline "$command $device $mode $resolution $option $geometry \
                 > $tempfile; convert -geometry ${wd}x${ht} $post &"
### for debugging
#
#     tk_messageBox -message $cmdline  -type ok
###
    exec sh -c "$cmdline"
}

