//-< CONTAINER.H >---------------------------------------------------*--------*
// GigaBASE                  Version 1.0         (c) 1999  GARRET    *     ?  *
// (Post Relational Database Management System)                      *   /\|  *
//                                                                   *  /  \  *
//                          Created:     04-Jun-2000  K.A. Knizhnik  * / [] \ *
//                          Last update: 04-Jun-2000  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// B-Tree object container
//-------------------------------------------------------------------*--------*

#ifndef __CONTAINER_H__
#define __CONTAINER_H__

BEGIN_GIGABASE_NAMESPACE

enum SpatialSearchType { 
    SPATIAL_SEARCH_EQUAL,
    SPATIAL_SEARCH_OVERLAPS,
    SPATIAL_SEARCH_SUPERSET,
    SPATIAL_SEARCH_PROPER_SUPERSE,
    SPATIAL_SEARCH_SUBSET,
    SPATIAL_SEARCH_PROPER_SUBSET
};

class GIGABASE_DLL_ENTRY dbAnyContainer : public dbAnyReference {
  protected:
    dbFieldDescriptor* fd;

    void create(dbDatabase& db, bool caseInsensitive);
    void purge(dbDatabase& db);
    void free(dbDatabase& db);
    void add(dbDatabase& db, dbAnyReference const& ref);
    void remove(dbDatabase& db, dbAnyReference const& ref);
    int  search(dbAnyCursor& cursor, void const* from, void const* till);
    int  spatialSearch(dbAnyCursor& cursor, rectangle const& r, SpatialSearchType type);

    dbAnyContainer(char_t const* fieldName, dbTableDescriptor& desc);
};

template<class T>
class dbContainer : public dbAnyContainer {
  public:
    int search(dbCursor<T>& cursor, void const* from, void const* till) {
	return dbAnyContainer::search(cursor, from, till);
    }
    int search(dbCursor<T>& cursor, void const* key) {
	return dbAnyContainer::search(cursor, key, key);
    }
    int search(dbCursor<T>& cursor) {
	return dbAnyContainer::search(cursor, NULL, NULL);
    }
    int spatialSearch(dbCursor<T>& cursor, rectangle const& r, SpatialSearchType type) { 
	return dbAnyContainer::spatialSearch(cursor, r, type);
    }
	
    
    void create(bool caseInsensitive = false) {
	dbAnyContainer::create(T::dbDescriptor.db, caseInsensitive);
    }

    void purge() {
	dbAnyContainer::purge(T::dbDescriptor.db);
    }

    void free() {
	dbAnyContainer::free(T::dbDescriptor.db);
    }

    void add(dbReference<T> const& ref) {
	dbAnyContainer::add(T::dbDescriptor.db, ref);
    }
    void remove(dbReference<T> const& ref) {
	dbAnyContainer::remove(T::dbDescriptor.db, ref);
    }

    dbContainer(const char_t* fieldName) : dbAnyContainer(fieldName, T::dbDescriptor) {}
};

END_GIGABASE_NAMESPACE

#endif




