/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class Unicode {
    private String url;
    private String user;
    private String password;

    private static void usage() {
        Unicode.log("usage: example.Unicode <url> <user> <password>");
    }

    private static void log(String string) {
        System.err.println(string);
    }

    private static void log(String string, Exception exception) {
        System.err.println(string);
        exception.printStackTrace();
    }

    public Unicode(String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.password = string3;
    }

    private Connection getConnection() throws SQLException, ClassNotFoundException {
        Class.forName("org.postgresql.Driver");
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", this.user);
        ((Hashtable)properties).put("password", this.password);
        ((Hashtable)properties).put("charSet", "utf-8");
        return DriverManager.getConnection(this.url, properties);
    }

    private String getSqlSafeUnicodeBlock(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("blockNum must be from 0 to 255: " + n);
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n2 = n * 256;
        int n3 = n2 + 256;
        int n4 = n2;
        while (n4 < n3) {
            char c = (char)n4;
            if (c != '\u0000' && c != '\'' && c != '\\') {
                stringBuffer.append(c);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    private boolean isValidUnicodeBlock(int n) {
        return n < 216 || n > 219;
    }

    private void reportRetrievalError(int n, String string, String string2) {
        String string3 = "Block " + n + " returned incorrectly: ";
        int n2 = 0;
        n2 = 0;
        while (n2 < string.length()) {
            if (n2 >= string2.length()) {
                string3 = string3 + "too short";
                break;
            }
            if (string2.charAt(n2) != string.charAt(n2)) {
                string3 = string3 + "first changed character at position " + n2 + ", sent as 0x" + Integer.toHexString(string.charAt(n2)) + ", retrieved as 0x" + Integer.toHexString(string2.charAt(n2));
                break;
            }
            ++n2;
        }
        if (n2 >= string.length()) {
            string3 = string3 + "too long";
        }
        Unicode.log(string3);
    }

    public void runTest() {
        Connection connection = null;
        Statement statement = null;
        int n = 0;
        int n2 = 0;
        try {
            Object object;
            Object object2;
            String string;
            connection = this.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("CREATE TABLE test_unicode ( blockNum INT PRIMARY KEY, block TEXT );");
            n2 = 1;
            n = 0;
            while (n < 256) {
                if (this.isValidUnicodeBlock(n)) {
                    string = this.getSqlSafeUnicodeBlock(n);
                    statement.executeUpdate("INSERT INTO test_unicode VALUES ( " + n + ", '" + string + "');");
                }
                ++n;
            }
            n2 = 2;
            n = 0;
            while (n < 256) {
                if (this.isValidUnicodeBlock(n)) {
                    string = this.getSqlSafeUnicodeBlock(n);
                    object2 = statement.executeQuery("SELECT block FROM test_unicode WHERE blockNum = " + n + ";");
                    if (!object2.next()) {
                        Unicode.log("Could not retrieve block " + n);
                    } else {
                        object = object2.getString(1);
                        if (!((String)object).equals(string)) {
                            this.reportRetrievalError(n, string, (String)object);
                        }
                    }
                }
                ++n;
            }
            n2 = 3;
            n = 0;
            while (n < 256) {
                if (this.isValidUnicodeBlock(n)) {
                    string = this.getSqlSafeUnicodeBlock(n);
                    object2 = "%" + string.substring(2, string.length() - 3) + "%";
                    object = statement.executeQuery("SELECT blockNum FROM test_unicode WHERE block LIKE '" + (String)object2 + "';");
                    if (!object.next()) {
                        Unicode.log("Could get block " + n + " using LIKE");
                    }
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            switch (n2) {
                case 0: {
                    Unicode.log("Exception creating database", sQLException);
                    break;
                }
                case 1: {
                    Unicode.log("Exception inserting block " + n, sQLException);
                    break;
                }
                case 2: {
                    Unicode.log("Exception selecting block " + n, sQLException);
                    break;
                }
                case 3: {
                    Unicode.log("Exception doing LIKE on block " + n, sQLException);
                    break;
                }
                default: {
                    Unicode.log("Exception", sQLException);
                    break;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Unicode.log("Unable to load driver", classNotFoundException);
            return;
        }
        try {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            Unicode.log("Exception closing connections", sQLException);
        }
        if (n2 > 0) {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate("DROP TABLE test_unicode;");
            }
            catch (Exception exception) {
                Unicode.log("*** ERROR: unable to delete test table test_unicode; must be deleted manually", exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            Unicode.usage();
            System.exit(1);
        }
        new Unicode(stringArray[0], stringArray[1], stringArray[2]).runTest();
    }
}

