/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.SQLException;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.ResultSet;
import org.postgresql.jdbc2.Connection;
import org.postgresql.jdbc2.PBatchUpdateException;
import org.postgresql.util.PSQLException;

public class Statement
extends org.postgresql.Statement
implements java.sql.Statement {
    private Connection connection;
    private Vector batch = null;
    private int resultsettype;
    private int concurrency;

    public Statement(Connection connection) {
        this.connection = connection;
        this.resultsettype = 1004;
        this.concurrency = 1007;
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.execute(string);
        while (this.result != null && !((ResultSet)((Object)this.result)).reallyResultSet()) {
            this.result = ((ResultSet)((Object)this.result)).getNext();
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult");
        }
        return this.result;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute(string);
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public void setCursorName(String string) throws SQLException {
        this.connection.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        java.sql.ResultSet resultSet;
        if (this.escapeProcessing) {
            string = org.postgresql.Statement.escapeSQL(string);
        }
        if (this.result != null && (resultSet = this.getResultSet()) != null) {
            resultSet.close();
        }
        this.result = this.connection.ExecSQL(string, this);
        ((org.postgresql.jdbc2.ResultSet)this.result).setStatement(this);
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            return -1;
        }
        return ((ResultSet)((Object)this.result)).getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.result = ((ResultSet)((Object)this.result)).getNext();
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public void addBatch(String string) throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        this.batch.addElement(string);
    }

    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.removeAllElements();
        }
    }

    public int[] executeBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        int n = this.batch.size();
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            try {
                n2 = 0;
                while (n2 < n) {
                    nArray[n2] = this.executeUpdate((String)this.batch.elementAt(n2));
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                int[] nArray2 = new int[n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                PBatchUpdateException pBatchUpdateException = new PBatchUpdateException("postgresql.stat.batch.error", new Integer(n2), this.batch.elementAt(n2), nArray2);
                pBatchUpdateException.setNextException(sQLException);
                throw pBatchUpdateException;
            }
            Object var8_4 = null;
            this.batch.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.batch.removeAllElements();
            throw throwable;
        }
        return nArray;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        throw new PSQLException("postgresql.psqlnotimp");
    }

    public int getFetchSize() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultsettype;
    }

    public void setFetchDirection(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setFetchSize(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setResultSetConcurrency(int n) throws SQLException {
        this.concurrency = n;
    }

    public void setResultSetType(int n) throws SQLException {
        this.resultsettype = n;
    }
}

