/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.postgresql.Connection;
import org.postgresql.util.PSQLException;

public class Driver
implements java.sql.Driver {
    protected static final int DEBUG = 0;
    protected static final int INFO = 1;
    protected static final int WARN = 2;
    protected static final int ERROR = 3;
    protected static final int FATAL = 4;
    private static int logLevel = 4;
    private Properties props;
    private static String[] protocols;

    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        this.props = this.parseURL(string, properties);
        if (this.props == null) {
            Driver.debug("Error in url" + string);
            return null;
        }
        try {
            Driver.debug("connect " + string);
            Connection connection = (Connection)Class.forName("org.postgresql.jdbc2.Connection").newInstance();
            connection.openConnection(this.host(), this.port(), this.props, this.database(), string, this);
            return (java.sql.Connection)((Object)connection);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Driver.debug("error", classNotFoundException);
            throw new PSQLException("postgresql.jvm.version", classNotFoundException);
        }
        catch (PSQLException pSQLException) {
            throw pSQLException;
        }
        catch (Exception exception) {
            Driver.debug("error", exception);
            throw new PSQLException("postgresql.unusual", exception);
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.parseURL(string, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Properties properties2 = this.parseURL(string, properties);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{};
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 2;
    }

    public static String getVersion() {
        return "PostgreSQL 7.2.1 JDBC2";
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String string, Properties properties) throws SQLException {
        int n = -1;
        Properties properties2 = new Properties(properties);
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/;=&?", true);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (n2 <= 3) {
                if (n2 % 2 != 1 || !string4.equals(":")) {
                    if (n2 % 2 != 0) return null;
                    boolean bl = n2 == 0;
                    int n3 = 0;
                    while (n3 < protocols.length) {
                        if (string4.equals(protocols[n3]) && n2 == 2 && n3 > 0) {
                            ((Hashtable)properties2).put("Protocol", string4);
                            bl = true;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        return null;
                    }
                }
            } else if (n2 > 3) {
                if (n2 == 4 && string4.equals("/")) {
                    n = 0;
                } else if (n2 == 4) {
                    ((Hashtable)properties2).put("PGDBNAME", string4);
                    n = -2;
                } else if (n2 == 5 && n == 0 && string4.equals("/")) {
                    n = 1;
                } else {
                    if (n2 == 5 && n == 0) {
                        return null;
                    }
                    if (n2 == 6 && n == 1) {
                        ((Hashtable)properties2).put("PGHOST", string4);
                    } else if (n2 == 7 && string4.equals(":")) {
                        n = 2;
                    } else if (n2 == 8 && n == 2) {
                        try {
                            Integer n4 = Integer.decode(string4);
                            ((Hashtable)properties2).put("PGPORT", n4.toString());
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    } else if (!(n2 != 7 && n2 != 9 || n != 1 && n != 2 || !string4.equals("/"))) {
                        n = -1;
                    } else if (n == -1) {
                        ((Hashtable)properties2).put("PGDBNAME", string4);
                        n = -2;
                    } else if (n <= -2 && n2 % 2 == 1) {
                        if (string4.equals(";") || string4.equals("?") || string4.equals("&")) {
                            n = -3;
                        } else if (string4.equals("=")) {
                            n = -5;
                        }
                    } else if (n <= -2 && n2 % 2 == 0) {
                        if (n == -3) {
                            string2 = string4;
                        } else if (n == -5) {
                            string3 = string4;
                            ((Hashtable)properties2).put(string2, string3);
                            n = -2;
                        }
                    }
                }
            }
            ++n2;
        }
        return properties2;
    }

    public String host() {
        return this.props.getProperty("PGHOST", "localhost");
    }

    public int port() {
        return Integer.parseInt(this.props.getProperty("PGPORT", "5432"));
    }

    public String database() {
        return this.props.getProperty("PGDBNAME");
    }

    public String property(String string) {
        return this.props.getProperty(string);
    }

    public static SQLException notImplemented() {
        return new PSQLException("postgresql.unimplemented");
    }

    public static void debug(String string) {
        if (logLevel <= 0) {
            DriverManager.println(string);
        }
    }

    public static void debug(String string, Exception exception) {
        if (logLevel <= 0) {
            DriverManager.println(string + exception != null ? exception.getMessage() : "null Exception");
        }
    }

    public static void info(String string) {
        if (logLevel <= 1) {
            DriverManager.println(string);
        }
    }

    public static void info(String string, Exception exception) {
        if (logLevel <= 1) {
            DriverManager.println(string + exception != null ? exception.getMessage() : "null Exception");
        }
    }

    public static void warn(String string) {
        if (logLevel <= 2) {
            DriverManager.println(string);
        }
    }

    public static void warn(String string, Exception exception) {
        if (logLevel <= 2) {
            DriverManager.println(string + exception != null ? exception.getMessage() : "null Exception");
        }
    }

    public static void error(String string) {
        if (logLevel <= 3) {
            DriverManager.println(string);
        }
    }

    public static void error(String string, Exception exception) {
        if (logLevel <= 3) {
            DriverManager.println(string + exception != null ? exception.getMessage() : "null Exception");
        }
    }

    public static void fatal(String string) {
        if (logLevel <= 4) {
            DriverManager.println(string);
        }
    }

    public static void fatal(String string, Exception exception) {
        if (logLevel <= 4) {
            DriverManager.println(string + exception != null ? exception.getMessage() : "null Exception");
        }
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        protocols = new String[]{"jdbc", "postgresql"};
    }
}

