/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.postgresql.Connection;
import org.postgresql.Field;
import org.postgresql.util.PGtokenizer;

public abstract class ResultSet {
    protected Vector rows;
    protected Field[] fields;
    protected String status;
    protected boolean binaryCursor = false;
    protected int updateCount;
    protected long insertOID;
    protected int current_row;
    protected byte[][] this_row;
    protected Connection connection;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected ResultSet next = null;

    public ResultSet(Connection connection, Field[] fieldArray, Vector vector, String string, int n, long l, boolean bl) {
        this.connection = connection;
        this.fields = fieldArray;
        this.rows = vector;
        this.status = string;
        this.updateCount = n;
        this.insertOID = l;
        this.this_row = null;
        this.current_row = -1;
        this.binaryCursor = bl;
    }

    public ResultSet(Connection connection, Field[] fieldArray, Vector vector, String string, int n) {
        this(connection, fieldArray, vector, string, n, 0L, false);
    }

    public boolean reallyResultSet() {
        return this.fields != null;
    }

    public java.sql.ResultSet getNext() {
        return (java.sql.ResultSet)((Object)this.next);
    }

    public void append(ResultSet resultSet) {
        if (this.next == null) {
            this.next = resultSet;
        } else {
            this.next.append(resultSet);
        }
    }

    public int getResultCount() {
        return this.updateCount;
    }

    public int getTupleCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.fields.length;
    }

    public String getStatusString() {
        return this.status;
    }

    public int getColumnOID(int n) {
        return this.fields[n - 1].getOID();
    }

    public int getInsertedOID() {
        return (int)this.getLastOID();
    }

    public long getLastOID() {
        return this.insertOID;
    }

    public abstract void close() throws SQLException;

    public abstract boolean next() throws SQLException;

    public abstract String getString(int var1) throws SQLException;

    public String getFixedString(int n) throws SQLException {
        String string = this.getString(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (string.charAt(0) == '(') {
            string = "-" + PGtokenizer.removePara(string).substring(1);
        }
        if (string.charAt(0) == '$') {
            string = string.substring(1);
        }
        return string;
    }
}

