/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.CallableStatement;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.jdbc2.DatabaseMetaData;
import org.postgresql.jdbc2.PreparedStatement;
import org.postgresql.jdbc2.ResultSet;
import org.postgresql.jdbc2.Statement;
import org.postgresql.jdbc2.UpdateableResultSet;
import org.postgresql.util.PSQLException;

public class Connection
extends org.postgresql.Connection
implements java.sql.Connection {
    protected DatabaseMetaData metadata;
    protected Map typemap;
    private static final String[] jdbc2Types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "date", "time", "abstime", "timestamp", "timestamptz", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea"};
    private static final int[] jdbc2Typei = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, -7, 91, 92, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003};

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1004, 1007);
    }

    public java.sql.Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = new Statement(this);
        statement.setResultSetType(n);
        statement.setResultSetConcurrency(n2);
        return statement;
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1004, 1007);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = new PreparedStatement(this, string);
        preparedStatement.setResultSetType(n);
        preparedStatement.setResultSetConcurrency(n2);
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1004, 1007);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new PSQLException("postgresql.con.call");
    }

    public boolean isClosed() throws SQLException {
        if (this.pg_stream == null) {
            return true;
        }
        try {
            java.sql.ResultSet resultSet = this.ExecSQL(" ");
            if (resultSet != null) {
                resultSet.close();
            }
            return false;
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new DatabaseMetaData(this);
        }
        return this.metadata;
    }

    public java.sql.ResultSet getResultSet(org.postgresql.Connection connection, java.sql.Statement statement, Field[] fieldArray, Vector vector, String string, int n, long l, boolean bl) throws SQLException {
        if (statement != null && statement.getResultSetConcurrency() == 1008) {
            return new UpdateableResultSet((Connection)connection, fieldArray, vector, string, n, l, bl);
        }
        return new ResultSet((Connection)connection, fieldArray, vector, string, n, l, bl);
    }

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typemap = map;
    }

    public Object getObject(String string, String string2) throws SQLException {
        SQLData sQLData;
        if (this.typemap != null && (sQLData = (SQLData)this.typemap.get(string)) != null) {
            throw Driver.notImplemented();
        }
        return super.getObject(string, string2);
    }

    public int getSQLType(String string) {
        int n = 1111;
        int n2 = 0;
        while (n2 < jdbc2Types.length) {
            if (string.equals(jdbc2Types[n2])) {
                n = jdbc2Typei[n2];
                break;
            }
            ++n2;
        }
        return n;
    }
}

