/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.SQLException;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.util.PSQLException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    Vector rows;
    Field[] fields;

    public ResultSetMetaData(Vector vector, Field[] fieldArray) {
        this.rows = vector;
        this.fields = fieldArray;
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 1111: {
                return true;
            }
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        String string = this.getField(n).getPGType();
        return string.equals("cash") || string.equals("money");
    }

    public int isNullable(int n) throws SQLException {
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        Field field = this.getField(n);
        String string = field.getPGType();
        int n2 = field.getSQLType();
        int n3 = field.getMod();
        if (string.equals("int2")) {
            return 6;
        }
        if (string.equals("int4") || string.equals("oid")) {
            return 11;
        }
        if (string.equals("int8")) {
            return 20;
        }
        if (string.equals("money")) {
            return 12;
        }
        if (string.equals("float4")) {
            return 11;
        }
        if (string.equals("float8")) {
            return 20;
        }
        if (string.equals("char")) {
            return 1;
        }
        if (string.equals("bool")) {
            return 1;
        }
        if (string.equals("date")) {
            return 14;
        }
        if (string.equals("time")) {
            return 8;
        }
        if (string.equals("timestamp")) {
            return 22;
        }
        n3 -= 4;
        if (string.equals("bpchar") || string.equals("varchar")) {
            return n3;
        }
        if (string.equals("numeric")) {
            return (n3 >> 16 & 0xFFFF) + 1 + (n3 & 0xFFFF);
        }
        return field.getLength();
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        Field field = this.getField(n);
        if (field != null) {
            return field.getName();
        }
        return "field" + n;
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field field = this.getField(n);
                if (field != null) {
                    return (0xFFFF0000 & field.getMod()) >> 16;
                }
                return 0;
            }
        }
        return 0;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 5: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field field = this.getField(n);
                if (field != null) {
                    return (0xFFFF & field.getMod()) - 4;
                }
                return 0;
            }
        }
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        return "";
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        return this.getField(n).getSQLType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.getField(n).getPGType();
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    private Field getField(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        return this.fields[n - 1];
    }

    public String getColumnClassName(int n) throws SQLException {
        throw Driver.notImplemented();
    }
}

