;;; color-mate.emacs.add -- Coloring mule/emacs to more easier and more fun. -*-emacs-lisp-*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Coloring mule/emacs to more easier and more fun.
;;   mule / emacs ǡѤƸ䤹̤ˤޤ
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Author: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.0
;; Keywords: color hilit19 font-lock color-mate
;; Content-Type: text/plain; charset=x-euc-jp

;$Id: Dot.emacs.default.in,v 10.1 1999/08/05 23:06:28 elca Exp $

;----------------------------------;
; եɤ߹ߥѥ
;----------------------------------;
; Add "~/elisp/color-mate" to your load path.
;
; Color-Mate Υե뤬 ~/elisp/color-mate ʳξͭϤ
; ѹƲ
;(setq load-path
;      (cons
;       (expand-file-name
;	"~/elisp/color-mate") load-path))
(setq load-path
      (append
       (list "/usr/local/lib/xemacs/site-packages/lisp/color-mate"
	     "/usr/local/lib/xemacs/site-packages/lisp/color-mate/theme"
	     "/usr/local/lib/xemacs/site-packages/lisp/color-mate/contrib"
	     "/usr/local/lib/xemacs/site-packages/lisp/color-mate/kanakan-cursor")
       load-path))

;----------------------------------;
;               
;----------------------------------;
;; theme file name (default "SunnyDay")
(setq color-mate:theme-file "SunnyDay")
;(load "cm_select")

;--------------------------;
;  եȥå
;--------------------------;
; load fontset
;; mule
(if (and (= (string-to-int emacs-version) 19)
	 (boundp 'MULE)
	 (eq window-system 'x))
    (load "color-mate-mule-fontset"))
;; emacs 20
(if (and (>= (string-to-int emacs-version) 20)
	 (not (string-match "XEmacs" emacs-version))
	 (eq window-system 'x))
    (load "color-mate-e20-fontset"))
;; mule for windows
(if (and (boundp 'MULE)
	 (eq window-system 'win32))
    (load "win32fontset"))


;------------------------------------------;
; Drag & Drop Support for "Mule for Win32"
;------------------------------------------;
(if (and (boundp 'MULE)
	 (eq window-system 'win32))
    (load "win32dropfiles"))


;-----------------;
; Color-Mate ư
;-----------------;
; start Color-Mate
(if (and (>= (string-to-int emacs-version) 19)
	 window-system )
    (progn
      (require 'color-mate)
      (color-mate)
      (require 'color-mate-face)
      (color-mate:face)
      ))

;----------------------;
; kanakan-cursor λ
;----------------------;
;; cursor color with Input Method. (for mule/emacs20/xemacs20)
;
(if (and (>= (string-to-int emacs-version) 19)
	 window-system )
    (progn

      ;; color-mate:theme 饫뿧ȴ褦ˤ롣
      (require 'assoc)
      (require 'color-mate-util)

      ;; skk (mule/xemacs)
      ;; skk version 9.6 Υ忧ǽѤ롣
      ;;  skk 򤷤Ƥ
      ;; skk-cursor2 Ͽκ򤷤ƤʤΤ skk ѤƤʤƤ
      ;; ¾˰ƶͿϤʤ
      (if (and (fboundp 'skk-mode)
	      (not (color-mate:is-xemacs)))
	  (require 'skk-cursor2))

      ;;  skk version 8 
;      (if (fboundp 'skk-mode)
;	  (progn
;	    ;;  Color-Mate ȹ碌
;	    (setq skk-cursor-color-for-default     color-mate-cursor-color)
;	    (global-unset-key "\C-x\C-j")
;	    (global-unset-key "\C-xj")
;	    (global-set-key   "\C-x\C-j" 'skk-mode-with-color-cursor)
;	    (global-set-key   "\C-xj" 'skk-auto-fill-mode-with-color-cursor)
;	    (autoload 'skk-mode-with-color-cursor "skk-cursor" nil t)
;	    (autoload 'skk-auto-fill-mode-with-color-cursor "skk-cursor" nil t)
;	    ))

      ;; leim
      ;; leim Ȥ Emacs/XEmacs20 Ѥ¿ϥ饤֥Ǥ
      ;; leim-cursor ܸǤʤ¾θϻˤͭȤʤޤ
      ;;  leim  Emacs19  skk ȵǽͤ뤿ᡢ Emacs20 
      ;;  leim  skk ƱѤޤ
      (if (>= (string-to-int emacs-version) 20)
	  (progn
	    (setq leim-mode-off-cursor-color
		  (aget color-mate:theme 'cursor-background-color))
	    (require 'leim-cursor)))

      ;; Wnn
      (if (and (boundp 'WNN)
	       (not (color-mate:is-xemacs)))
	  (progn
	    ;;  Color-Mate ȹ碌
	    (setq egg-mode-off-cursor-color
		  (aget color-mate:theme 'cursor-background-color))
	    (require 'egg-cursor)))

      ;; canna
      ;; Canna  mule Ǥ canna.el ˤ˥ɤƤΤ
      ;; (featurep 'canna) Ǥ (canna) ¹Ԥʬʤ
      ;; Ǥɤʬʤ canna-empty-info
      ;; Ȥѿ Canna ư t ˤʤѤ
      ;; 桼 Canna ȤäƤ뤫(˵ưƤ뤫)Ƚꤹ롣
      ;;
      (if (and (boundp 'CANNA) canna-empty-info
	       (not (color-mate:is-xemacs)))
	  (progn
	    ;;  Color-Mate ȹ碌
	    (setq canna-mode-off-cursor-color
		  (aget color-mate:theme 'cursor-background-color))
	    (require 'canna-cursor)))

      ;; SJ3
      (if (and (boundp 'SJ3)
	       (not (color-mate:is-xemacs)))
	  (progn
	    ;;  Color-Mate ȹ碌
	    (setq sj3-mode-off-cursor-color
		  (aget color-mate:theme 'cursor-background-color))
	    (require 'sj3-cursor)))

      ;; Windows IME (Mule for Windows)
      (if (and (boundp 'MULE)
	       (eq window-system 'win32))
          (progn
            (setq win32-ime-mode-off-cursor-color
                  (aget color-mate:theme 'cursor-background-color))
            (require 'win32-cursor)))
      ))

;;; color-mate.emacs.add ends here
(provide 'color-mate-startup)
