;;; color-mate-emacs-frame.el -- Coloring routine for emacs/mule.

;; Copyright (C) YOKOTA Hiroshi

;; Author: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.0
;; Keywords: color hilit19 font-lock color-mate
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Coloring mule/emacs to more easier and more fun.
;;   mule / emacs ǡѤƸ䤹̤ˤޤ
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;$Id: color-mate-emacs-frame.el,v 10.1 1999/08/05 23:12:41 elca Exp $

;;; Code:

;; Color-Mate 忧롼 emacs/mule 

(require 'assoc)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;               ե졼δͤ롣
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ե졼δͤ롣â⡼ɥ饤ȥ꡼
; ϻ;ͤǤʤߤΥե졼οˤȿǤ롣
;
(defun color-mate:emacs-set-default-frame (alist)
  "Set default settings to coloring mule/emacs."

  (progn
    (require 'color-mate-util)
    ;; ⡼ɥ饤ϰϤο
    ;; color-mate-set-current-frame Ʊ
    ;; ϴͤǤʤߤΥե졼οˤȿǤ
    ;;
    ;; modeline
    (set-face-underline-p 'modeline (aget alist 'modeline-underlined))
    (color-mate:_set-face-if-string alist 'modeline-background-color 'modeline-foreground-color 'modeline)

    ;; region
    (set-face-underline-p 'region (aget alist 'region-underlined))
    (color-mate:_set-face-if-string alist 'region-background-color 'region-foreground-color 'region)

    ;; ɥεͤϢۥꥹȤˤϿ
    ;; ɲä褦ˤ
    (color-mate:_set-alist-if-string alist 'default-frame-alist 'frame-background-color 'background-color)
    (color-mate:_set-alist-if-string alist 'default-frame-alist 'frame-foreground-color 'foreground-color)
    (color-mate:_set-alist-if-string alist 'default-frame-alist 'cursor-background-color 'cursor-color)
    (color-mate:_set-alist-if-string alist 'default-frame-alist 'mouse-foreground-color  'mouse-color)

    (color-mate:_set-alist-if-integer alist 'default-frame-alist 'menu-bar-lines 'menu-bar-lines)
    (color-mate:_set-alist-if-integer alist 'default-frame-alist 'frame-height 'height)
    (color-mate:_set-alist-if-integer alist 'default-frame-alist 'frame-width  'width)

    (color-mate:_set-alist-if-string alist 'default-frame-alist 'line-space 'line-space)

    (color-mate:_set-alist-if-string alist 'default-frame-alist 'font 'font)
    ))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                 ߤΥե졼οѹ롣
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ߤΥե졼Ρѹ롣δؿˤäƿѤΤ
; ߤΥե졼Ǥꡢcolor-mate-set-default-frame ˤä
; 줿ͤϢۥꥹȤˤˤϱƶʤ
;
(defun color-mate:emacs-set-current-frame (alist)
  "Coloring current frame."

  (progn
    (require 'color-mate-util)
    ;; face
    (color-mate:_set-face-if-string alist 'modeline-background-color 'modeline-foreground-color 'modeline)    
    (color-mate:_set-face-if-string alist 'region-background-color 'region-foreground-color 'region)
    ;; bg
    (if (stringp (aget alist 'frame-background-color))
	(set-background-color (aget alist 'frame-background-color)))
    ;; fg
    (if (stringp (aget alist 'frame-foreground-color))
	(set-foreground-color (aget alist 'frame-foreground-color)))
    ;; cursor
    (if (stringp (aget alist 'cursor-background-color))
	(set-cursor-color (aget alist 'cursor-background-color)))
    ;; mouse
    (if (stringp (aget alist 'mouse-foreground-color))
	(set-mouse-color (aget alist 'mouse-foreground-color)))
    ))

;; feature ˤ
(provide 'color-mate-emacs-frame)

;;; color-mate-emacs-frame.el ends here
