;;; color-mate-face.el -- Coloring mule/emacs to more easier and more fun.

;; Copyright (C) YOKOTA Hiroshi

;; Author: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.0.1
;; Keywords: color hilit19 font-lock color-mate paren
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0.1
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Coloring mule/emacs to more easier and more fun.
;;   mule / emacs ǡѤƸ䤹̤ˤޤ
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Commentary:
;; (1) This Library require hilit19.el and font-lock.el.
;; (2) Write these lines to your ~/.emacs
;;        (if (and (>= (string-to-int emacs-version) 19)
;;	           window-system )
;;            (progn
;;               (require 'color-mate-face)
;;               (color-mate-face)
;;               ))
;;     or Add "color-mate.emacs.add"'s contents to your ~/.emacs
;;
;;  If you use mule, and you want to more, see skk-cursor.el, egg-cursor.el,
;; canna-cursor.el and sj3-cursor.el

;$Id: color-mate-face.el,v 10.2 1999/08/07 21:58:23 elca Exp $

;; -*-mode: emacs-lisp-*-

;;; Code:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                          ʸؤ忧
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; hilit19  font-lock Ȥäʸ忧롣
;; Canna ȤäƤʤ顢 Canna 忧ǽͭˤ롣
;;

;; hilit19, font-lock Ѥɲꡣ (mule FAQ )

; Color-Mate  hilit19  font-lock Ʊ˻ѤƤΤǡ
; δ֤ǤĴΤʸΥ顼򾡼˽񤭴Ƥޤ
; ⤷ʤ hilit19  font-lock ȤäƤʤ顢꤬Ѥä
; ޤ줬ޤλ .emacs ˵Ҥ줿
;
;   (require 'color-mate-face)
;   (color-mate:face)
;
; ƤεǽȤʤ褦ˤƲ

(require 'color-mate-util)

(defun color-mate:face ()
  "Color-Mate's face utility routine. This routine use with Color-Mate."
  (interactive)
  (progn
    ;; ưå
    (message "Loading Color-Mate face utility...")

    ;; xemacs Ǥ hilit19.el ϻȤʤ褦
    (if (not (color-mate:is-xemacs))
	(color-mate:face:hilight19))
    (color-mate:face:font-lock)

    (color-mate:face:paren)
    ;(color-mate:face:region)
    (color-mate:face:kanakan)

    ;; ưλå
    (message "Loading Color-Mate face utility...done")
    ))

;---------------------------------------------------------------------------;

;;----------------;
;; hilit19 
;;----------------;
;;
;; hilit19 ɲ忧
;;
;; hilit-translate ϴؿǤϤʤޥǤΤǥХȥѥ
;; emacs/mule ˥ޥǤǧɬפ롣
;; ܤ color-mate-compile.el 򻲾ȡ
;;
(defun color-mate:face:hilight19 ()
  "Set up \"hilit19.el\""
  (progn
    (require 'hilit19)
    ;; ø int ʤɤѿؤ忧
    (hilit-translate type     'RoyalBlue)
    ))

;---------------------------------------------------------------------------;

;;------------------;
;; font-lock 
;;------------------;
(defun color-mate:face:font-lock ()
  "Set up \"font-lock.el\""
  (progn
    (require 'font-lock)

    ;; Ť emacs/mule °Ƥ font-lock.el ˤ font-lock-mode 
    ;; ưƤӤ롼󤬤ʤΤɲä롣
    (if (string< emacs-version "19.29")
	(defun turn-on-font-lock ()
	  "Hook routine for font-lock. (By color-mate-face.el)"
	  (font-lock-mode 1)))

    ;; font-lock.el ˤʸ忧ư
    (add-hook 'find-file-hooks 'turn-on-font-lock)

    (if (boundp 'MULE)
	(color-mate:face:font-lock:mule-face)
      (color-mate:face:font-lock:emacs-face))
      ))


;; hilit19 Ʊˤʤ褦ˤ
(defun color-mate:face:font-lock:mule-face ()
  (progn
    ;; øˤ define ѿ̾ʤ
    (make-face           'keyword-face)
    (set-face-foreground 'keyword-face "purple")
    (set-face-bold-p     'keyword-face t)

    ;; 
    (make-face           'comment-face)
    (set-face-foreground 'comment-face "firebrick")

    ;; ʸ
    (make-face            'string-face)
    (set-face-foreground  'string-face "grey40")
    (set-face-underline-p 'string-face t)

    ;; ؿ̾
    (make-face           'function-face)
    (set-face-foreground 'function-face "blue")
    (set-face-bold-p     'function-face t)

    ;; ѿ
    (make-face           'c-type-face)
    (set-face-foreground 'c-type-face "RoyalBlue")

    (add-hook 'font-lock-mode-hook
	      '(lambda ()
		 (setq font-lock-keyword-face 'keyword-face)
		 (setq font-lock-comment-face 'comment-face)
		 (setq font-lock-string-face 'string-face)
		 (setq font-lock-function-name-face 'function-face)
		 (setq font-lock-type-face 'c-type-face)
		 ))))

(defun color-mate:face:font-lock:emacs-face ()
  (progn
    ;; եȺ
    ;; øˤ define ѿ̾ʤ
    (make-face            'keyword-face)
    (set-face-foreground  'keyword-face "purple")
    (make-face-bold       'keyword-face)

    ;; 
    (make-face            'comment-face)
    (set-face-foreground  'comment-face "firebrick")

    ;; ʸ
    (make-face            'string-face)
    (set-face-foreground  'string-face "grey40")
    (set-face-underline-p 'string-face t)

    ;; ؿ̾
    (make-face            'function-face)
    (set-face-foreground  'function-face "blue")
    (make-face-bold       'function-face)

    ;; ѿ
    (make-face            'c-type-face)
    (set-face-foreground  'c-type-face "RoyalBlue")

    ;; 
    (add-hook 'font-lock-mode-hook
	      '(lambda ()
		 (setq font-lock-keyword-face       'keyword-face)
		 (setq font-lock-comment-face       'comment-face)
		 (setq font-lock-string-face        'string-face)
		 (setq font-lock-function-name-face 'function-face)
		 (setq font-lock-type-face          'c-type-face)
		 ))))

;---------------------------------------------------------------------------;

;;--------------;;
;; paren 
;;--------------;;
(defun color-mate:face:paren ()
  "Set up \"paren.el\""
  (progn
    (require 'paren)
    (if (color-mate:is-xemacs)
	(if (< (color-mate:emacs-version) 20)
	    (setq paren-mode 'sexp) ; xemacs 19
	  (paren-set-mode 'sexp)))  ; xemacs 20
    (if (and (>= (color-mate:emacs-version) 20) ; emacs 20
	     (not (color-mate:is-xemacs)))
	(custom-set-variables
	 '(show-paren-style 'mixed)
	 '(show-paren-mode t nil (paren))))
    ))

;---------------------------------------------------------------------------;

;;------------------------;
;; ꡼Ļ벽
;;------------------------;
(defun color-mate:face:region ()
  "Visualize region"
  (progn
    (setq transient-mark-mode t)))

;---------------------------------------------------------------------------;

;;------------------------;
;; ̾Ѵΰ忧
;;------------------------;
(defun color-mate:face:kanakan ()
  "Set up Kana-Kanji conversion region"
  (progn
    ;; face Ѱ
    (color-mate:face:kanakan:make-face)

    ; canna
    ;; canna 忧ǽͭˤ롣
    ;; Canna  mule Ǥ canna.el ˤ˥ɤƤΤ
    ;; (featurep 'canna) Ǥ (canna) ¹Ԥʬʤ
    ;; Ǥɤʬʤ canna-empty-info
    ;; Ȥѿ Canna ư t ˤʤѤ
    ;; 桼 Canna ȤäƤ뤫(˵ưƤ뤫)Ƚꤹ롣
    ;;
    ;; mule
    (if (and (boundp 'CANNA)
	     canna-empty-info)
	(progn
	  (setq canna-use-color t)
	  (cond
	   ((boundp 'egg-version)
	    (require 'can-n-egg)
	    (can-n-egg))
	   (t
	    (require 'canna)
	    (canna))
	   )))
    ;; emacs20 / xemacs20
    (if (>= (color-mate:emacs-version) 20)
	(setq canna-use-color t))

    ; skk
    (if (or (fboundp 'skk-mode)
	    (color-mate:is-xemacs))
	(color-mate:face:kanakan:skk))

    (if (and (not (color-mate:is-xemacs))
	     (>= (color-mate:emacs-version) 20))
	(color-mate:face:kanakan:skk-emacs20))

    ; Wnn
    (if (or (boundp 'WNN)
	    (>= (color-mate:emacs-version) 20))
	(color-mate:face:kanakan:wnn))

    ; Sj3
    (if (boundp 'SJ3)
	  (color-mate:face:kanakan:sj3))
    ))

(defun color-mate:face:kanakan:make-face ()
  (progn
    ;; Ѵΰ
    (make-face           'color-mate:firebrick1)
    (set-face-foreground 'color-mate:firebrick1 "firebrick1")
    ;; ܤñ
    (make-face           'color-mate:RoyalBlue2-lavender)
    (set-face-foreground 'color-mate:RoyalBlue2-lavender "RoyalBlue2")
    (set-face-background 'color-mate:RoyalBlue2-lavender "lavender")))


;; skk 忧ǽ (mule/xemacs)
;; Ѵʸο canna Ʊˤ
(defun color-mate:face:kanakan:skk ()
  (progn
    (setq skk-use-face t)
    (setq skk-henkan-face 'color-mate:RoyalBlue2-lavender)))

;; skk 9.6 ξϤɤ
;    (if (fboundp 'skk-mode)
;	(progn
;	  (require 'skk-e19)
;	  (skk-make-face 'RoyalBlue2/lavender)
;	  (setq skk-henkan-face 'RoyalBlue2/lavender)))

;; emacs 20  skk ⡼
(defun color-mate:face:kanakan:skk-emacs20 ()
  (progn
    (setq kkc-overlay-head (make-overlay 0 0 nil nil t))
    (overlay-put kkc-overlay-head 'face 'color-mate:RoyalBlue2-lavender)
    (delete-overlay kkc-overlay-head)
    (setq quail-conv-overlay (make-overlay 0 0 nil nil t))
    (overlay-put quail-conv-overlay  'face 'color-mate:firebrick1)
    (delete-overlay quail-conv-overlay)))


;; wnn 忧ǽ
;; canna 忧Ʊ褦ˤ
(defun color-mate:face:kanakan:wnn ()
  (progn
    (setq egg:*fence-face*         'color-mate:firebrick1)
    (setq egg:*henkan-face*        'color-mate:firebrick1)
    (setq egg:*fence-face-in-cont* 'color-mate:RoyalBlue2-lavender)
    (setq egg:*dai-bunsetu-face*   'color-mate:RoyalBlue2-lavender)
    (setq egg:*sho-bunsetu-face*   'color-mate:RoyalBlue2-lavender)))

;; sj3 忧ǽ
;; canna 忧Ʊ褦ˤ
;; ޤĤʤ
(defun color-mate:face:kanakan:sj3 ()
  (progn
    (setq egg:*fence-face*         'color-mate:firebrick1)
    (setq egg:*henkan-face*        'color-mate:firebrick1)
    (setq egg:*fence-face-in-cont* 'color-mate:RoyalBlue2-lavender)))

(provide 'color-mate-face) ; feature ȤϿ

;;; color-mate-face.el ends here
