;; color-mate-mule-fontset.el fontset difinition file for mule

;; Copyright (C) YOKOTA Hiroshi

;; Author: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: YOKOTA Hiroshi <yokota@netlab.is.yokota.ac.jp>
;; Version: 10.0
;; Keywords: color color-mate
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0
;;         by  ͵ (yokota@netlab.is.yokota.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Coloring mule/emacs to more easier and more fun.
;;   mule / emacs ǡѤƸ䤹̤ˤޤ
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This file is part of Color-Mate

;; $Id: color-mate-mule-fontset.el,v 10.1 1999/08/05 23:15:20 elca Exp $

(if (and window-system (not noninteractive) (eq window-system 'x)
	 (fboundp 'fontset-string-to-vector))
    (let ((buf (get-buffer-create " color-mate:*temp")))
      (save-excursion
	(set-buffer buf)
	;; 12 dot
	(if (not (fontsetp "12"))
	    (new-fontset "12"
			 (fontset-string-to-vector
			  "-*-fixed-medium-r-*--12-*-*-*-*-*-iso8859-1,
                           -*-*-medium-r-*--12-*-*-*-*-*-gb2312.1980-*,
                           -*-fixed-medium-r-*--12-*-*-*-*-*-jisx0208.1983-*,
                           -*-mincho-medium-r-*--12-*-*-*-*-*-ksc5601.1987-*,
                           -*-fixed-medium-r-*-*-12-*-*-*-*-*-jisx0201.1976-*,
                           -*-*-*-*-*-*-12-*-*-*-*-*-jisx0212.1990-*,
                           -*-*-*-*-*-*-12-*-*-*-*-*-*-*"
			  (make-vector 128 nil) )))
	;; 14 dot
	(if (not (fontsetp "14"))
	    (new-fontset "14"
			 (fontset-string-to-vector
			  "-*-fixed-medium-r-*--14-*-*-*-*-*-iso8859-1,
                           -*-*-medium-r-*--14-*-*-*-*-*-gb2312.1980-*,
                           -*-fixed-medium-r-*--14-*-*-*-*-*-jisx0208.1983-*,
                           -*-mincho-medium-r-*--14-*-*-*-*-*-ksc5601.1987-*,
                           -*-fixed-medium-r-*-*-14-*-*-*-*-*-jisx0201.1976-*,
                           -*-*-*-*-*-*-14-*-*-*-*-*-jisx0212.1990-*,
                           -*-*-*-*-*-*-14-*-*-*-*-*-*-*"
			  (make-vector 128 nil) )))
	;; 16 dot
	(if (not (fontsetp "16"))
	    (new-fontset "16"
			 (fontset-string-to-vector
			  "-*-fixed-medium-r-*--16-*-*-*-*-*-iso8859-1,
                           -*-*-medium-r-*--16-*-*-*-*-*-gb2312.1980-*,
                           -*-fixed-medium-r-*--16-*-*-*-*-*-jisx0208.1983-*,
                           -*-mincho-medium-r-*--16-*-*-*-*-*-ksc5601.1987-*,
                           -*-fixed-medium-r-*-*-16-*-*-*-*-*-jisx0201.1976-*,
                           -*-*-*-*-*-*-16-*-*-*-*-*-jisx0212.1990-*,
                           -*-*-*-*-*-*-16-*-*-*-*-*-*-*"
			  (make-vector 128 nil) )))
	;; 16 dot italic (̵å)
	(if (not (fontsetp "16i"))
	    (new-fontset "16i"
			 (fontset-string-to-vector
			  "-*-fixed-medium-i-*--16-*-*-*-*-*-iso8859-1,
                           -*-*-medium-r-*--[16 0 8 16]-*-*-*-*-*-gb2312.1980-*,
                           -*-fixed-medium-r-*--[16 0 8 16]-*-*-*-*-*-jisx0208.1983-*,
                           -*-mincho-medium-r-*--[16 0 8 16]-*-*-*-*-*-ksc5601.1987-*,
                           -*-fixed-medium-r-*-*-[16 0 8 16]-*-*-*-*-*-jisx0201.1976-*,
                           -*-*-*-*-*-*-[16 0 8 16]-*-*-*-*-*-jisx0212.1990-*,
                           -*-*-*-*-*-*-[16 0 8 16]-*-*-*-*-*-*-*"
			  (make-vector 128 nil) )))
	;; 24 dot
	(if (not (fontsetp "24"))
	    (new-fontset "24"
			 (fontset-string-to-vector
			  "-*-fixed-medium-r-*--24-*-*-*-*-*-iso8859-1,
                           -*-*-medium-r-*--24-*-*-*-*-*-gb2312.1980-*,
                           -*-fixed-medium-r-*--24-*-*-*-*-*-jisx0208.1983-*,
                           -*-mincho-medium-r-*--24-*-*-*-*-*-ksc5601.1987-*,
                           -*-fixed-medium-r-*-*-24-*-*-*-*-*-jisx0201.1976-*,
                           -*-*-*-*-*-*-24-*-*-*-*-*-jisx0212.1990-*,
                           -*-*-*-*-*-*-24-*-*-*-*-*-*-*"
			  (make-vector 128 nil) ))) )
      (kill-buffer buf)
      ))

;; color-mate-mule-fontset.el ends here
