;;; color-mate-util.el -- Color-Mate utility routines.  -*-emacs-lisp-*-

;; Copyright (C) YOKOTA Hiroshi

;; Author: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.0
;; Keywords: color-mate
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; $Id: color-mate-util.el,v 10.1 1999/08/05 23:16:24 elca Exp $

(require 'assoc)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ʪؿ
(defun color-mate:emacs-version ()
  "return emacs major version"
  (progn
   (string-to-int emacs-version)))

(defun color-mate:is-xemacs ()
  "return t if you using XEmacs."
  (progn
    (string-match "XEmacs" emacs-version)))

; xemacs Ѥ emacs ߴؿ
(if (color-mate:is-xemacs)
;; from skk-foreword.el
(defun set-cursor-color (color-name)
  "Compatibility routine for xemacs."
  (set-frame-property (selected-frame) 'cursor-color
                      (if (color-instance-p color-name)
                          color-name
                        (make-color-instance color-name))))
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; emacs/xemacs κۼĤĥƥफ鸽ߤοФؿ
;;
(defun color-mate:face-background (emacs-face xemacs-face)
  "Get background face color."
  (progn
    (if (color-mate:is-xemacs)
	(face-background-name xemacs-face)
      (face-background emacs-face))))
(defun color-mate:face-foreground (emacs-face xemacs-face)
  "Get foreground face color."
  (progn
    (if (color-mate:is-xemacs)
	(face-foreground-name xemacs-face)
      (face-foreground emacs-face))))
(defun color-mate:frame-param-or-face-background (emacs-param xemacs-face)
  "Get background face color from an alist(emacs) or a function(xemacs)"
  (progn
    (if (color-mate:is-xemacs)
	(face-background-name xemacs-face)
      (aget (frame-parameters (selected-frame)) emacs-param))))
(defun color-mate:frame-param-or-face-foreground (emacs-param xemacs-face)
  "Get foreground face color from an alist(emacs) or a function(xemacs)"
  (progn
    (if (color-mate:is-xemacs)
	(face-foreground-name xemacs-face)
      (aget (frame-parameters (selected-frame)) emacs-param))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ǻѤؿ
;--------------------------------------------------------------------
; emacs
;
; from-alist  from-key бͤ ʸʤ to-alist 
; to-key Ͽ
(defun color-mate:_set-alist-if-string (from-alist to-alist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (stringp val)
	  (aput to-alist to-key val)
	))))


; from-alist  from-key бͤ ʤ to-alist 
; to-key Ͽ
(defun color-mate:_set-alist-if-integer (from-alist to-alist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (integerp val)
	  (aput to-alist to-key val)
	))))

;-----------------------------------------------------------------
; xemacs
;
; from-alist  from-key бͤ ʸʤ to-plist 
; to-key Ͽ
(defun color-mate:_set-plist-if-string (from-alist to-plist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (stringp val)
	  (eval
	   (list
	    'setq to-plist (list 'quote (append (symbol-value to-plist)
				  (list to-key val)))))
	))))

; from-alist  from-key бͤ ʤ to-plist 
; to-key Ͽ
(defun color-mate:_set-plist-if-integer (from-alist to-plist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (integerp val)
	  (eval
	   (list
	    'setq to-plist (list 'quote (append (symbol-value to-plist)
						(list to-key val)))))
	))))

;---------------------------------------------------------------

(defun color-mate:_set-face-if-string (alist bg-key fg-key face-name)
  "This is Color-Mate's internal function. Don't use it."
  (progn
    (let ((bg-val (aget alist bg-key))
	  (fg-val (aget alist fg-key)))
      (if (stringp bg-val)
	  (set-face-background face-name bg-val))
      (if (stringp fg-val)
	  (set-face-foreground face-name fg-val)))))

(provide 'color-mate-util)

;;; color-mate-util.el ends here.
