;;; color-mate-xemacs-frame.el -- Coloring routine for xemacs.

;; Copyright (C) HIROSHI Yokota

;; Author: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.0
;; Keywords: color hilit19 font-lock color-mate
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Coloring mule/emacs to more easier and more fun.
;;   mule / emacs ǡѤƸ䤹̤ˤޤ
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;$Id: color-mate-xemacs-frame.el,v 10.1 1999/08/05 23:17:11 elca Exp $

;;; Code:

(require 'assoc)

;;----------------------------------------------------------------
;; xemacs ǤϤʤʬfaceǿŤƤΤǡemacs/mule
;; ưʤ㤦

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;               ե졼δͤ롣
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
(defun color-mate:xemacs-set-default-frame (alist)
  "Set default settings to coloring xemacs."

  (progn
    (require 'color-mate-util)
    ;; Ǥ color-mate-xemacs-set-current-frame Ʊ򤹤Τ
    ;; Ʊٽɬפ⤢ޤ
    (color-mate:xemacs-set-current-frame alist)

    (color-mate:_set-plist-if-integer alist 'default-frame-plist 'menu-bar-lines 'menu-bar-lines)
    (color-mate:_set-plist-if-integer alist 'default-frame-plist 'frame-height 'height)
    (color-mate:_set-plist-if-integer alist 'default-frame-plist 'frame-width  'width)
    (color-mate:_set-plist-if-string  alist 'default-frame-plist 'line-space 'line-space)

    ;; եȤ
    (if (listp (aget alist 'font))
	(set-face-font 'default (aget alist 'font))
      (color-mate:_set-plist-if-string alist 'default-frame-plist 'font 'font))
    ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                 ߤΥե졼οѹ롣
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; xemacs ǤϸߤΥե졼࿧ѹȤʤʬͤ
;; ˤȿǤƤޤ
;;
(defun color-mate:xemacs-set-current-frame (alist)
  "Coloring current frame."

  (progn
    (require 'color-mate-util)
    ;; XEmacs Ͽ face ѤƤ褦Ǥ롣
    ;; emacs/mule ȰäƤ롣

    ;; ޥݥ󥿤ȥ뿧
    (color-mate:_set-face-if-string alist 'mouse-background-color 'mouse-foreground-color 'pointer)
    (color-mate:_set-face-if-string alist 'cursor-background-color 'cursor-foreground-color 'text-cursor)

    ;; region
    (set-face-underline-p 'zmacs-region (aget alist 'region-underlined))
    (color-mate:_set-face-if-string alist 'region-background-color 'region-foreground-color 'zmacs-region)
    ;; modeline #1
    (set-face-underline-p 'modeline (aget alist 'modeline-underlined))
    (color-mate:_set-face-if-string alist 'modeline-background-color 'modeline-foreground-color 'modeline)

    ;; modeline #2
    (color-mate:_set-face-if-string alist nil 'modeline-buffer-id-foreground-color 'modeline-buffer-id)
    (color-mate:_set-face-if-string alist nil 'modeline-mousable-foreground-color 'modeline-mousable)
    (color-mate:_set-face-if-string alist nil 'modeline-mousable-minor-mode-foreground-color 'modeline-mousable-minor-mode)

    ;; background/foreground
    (color-mate:_set-face-if-string alist 'frame-background-color 'frame-foreground-color 'default)
    ))


;; feature ˤ
(provide 'color-mate-xemacs-frame)

;;; color-mate-xemacs-frame.el ends here
