;;; color-mate.el -- Coloring mule/emacs to more easier and more fun.

;; Copyright (C) YOKOTA Hiroshi

;; Author: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.0
;; Keywords: color hilit19 font-lock color-mate
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Coloring mule/emacs/xemacs to more easier and more fun.
;;   mule / emacs / xemacs ǡѤƸ䤹̤ˤޤ
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Commentary:
;; (1) Add one of "theme/*.X"'s contents to your ~/.Xdefaults.
;; (2) Make color-mate-rgb.el. This file make from rgb.txt and rgb2el.pl
;;     (Perl script).
;; (3) Write these lines to your ~/.emacs
;;        (if (and (>= (string-to-int emacs-version) 19)
;;	           window-system )
;;            (progn
;;               (require 'color-mate)
;;               (color-mate)
;;               ))
;;     or Add "color-mate.emacs.add"'s contents to your ~/.emacs.
;;
;;  If you want to more, see color-mate-face.el.
;;
;;
;; <feature tree>
;; Color-Mate
;;   |
;;   +- color-mate.el
;;   |    +- color-mate-rgb.el
;;   |    +- color-mate-emacs-frame.el
;;   |    +- color-mate-xemacs-frame.el
;;   |    +- color-mate-util.el
;;   |
;;   +- color-mate-face.el
;;   |    +- <hilit19.el>
;;   |    +- <font-lock.el>
;;   |    +- <paren.el>
;;   |    +- <canna.el>
;;   |    +- <can-n-egg.el>
;;   |
;;   +- kanakan-cursor/skk-cursor.el
;;   |    +- color-mate-util.el
;;   +- kanakan-cursor/skk-cursor2.el
;;   +- kanakan-cursor/egg-cursor.el
;;   |    +- color-mate-util.el
;;   |    +- <egg.el>
;;   +- kanakan-cursor/canna-cursor.el
;;   |    +- color-mate-util.el
;;   |    +- <canna.el>
;;   +- kanakan-cursor/sj3-cursor.el
;;   |    +- color-mate-util.el
;;   |    +- <egg.el>
;;   +- kanakan-cursor/leim-cursor.el
;;   +- kanakan-cursor/win32-cursor.el

;$Id: color-mate.el,v 10.1 1999/08/05 23:20:32 elca Exp $

;; -*-mode: emacs-lisp-*-

;;; Code:

;;
;; Color-Mate.el
;;

;----------------;
; Сɽ
;----------------;
(defconst color-mate:version-string "Color-Mate Ver.10.0 based on mule 2.3(emacs 19.34.1) / emacs 20.3 / xemacs 21.1 / Mule for Win32 1.22 / Meadow 1.00 : color-mate.el 1999/Jun/13")

(require 'assoc)
(require 'color-mate-util)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                       СɽѴؿ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun color-mate:version ()
  "Show Color-Mate version."
  (interactive)
  (message
   (concat
    (substring color-mate:version-string 0 (- (frame-width) 4)) " ...")))

;----------------------------------------------------------------------;
;                         Color-Mate ѿ
;----------------------------------------------------------------------;
(defvar color-mate:theme '() "Color-Mate color settings")
(defvar color-mate:theme-file "SunnyDay"
  "Color-Mate definition file name")
(defvar color-mate:color-history nil
  "Color-Mate color history buffer")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                        ؿ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ؿΡmule/emacs ˿ɤ롣
;
(defun color-mate ()
  "Coloring mule/emacs."
  (interactive)
  (if window-system
      (progn
	(message "Loading Color-Mate coloring system...")

	(load color-mate:theme-file) ; եɤ߹

	(color-mate:set-default-frame)

	(message "Loading Color-Mate coloring system...done"))
    (progn
      (error "color-mate.el requires window system. stop."))
    ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;               ե졼δͤ롣
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun color-mate:set-default-frame ()
  "Set default settings to coloring."
  (progn
    (if (color-mate:is-xemacs)
	;; XEmacs λ
	(progn
	  (require 'color-mate-xemacs-frame)
	  (color-mate:xemacs-set-default-frame color-mate:theme))
      ;; Emacs/Mule λ
      (progn
	(require 'color-mate-emacs-frame)
	(color-mate:emacs-set-default-frame color-mate:theme)))
    ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                 ߤΥե졼οѹ롣
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun color-mate:set-current-frame (alist)
  "Coloring current frame."
  (progn
    (if (color-mate:is-xemacs)
	;; XEmacs λ
	(progn
	  (require 'color-mate-xemacs-frame)
	  (color-mate:xemacs-set-current-frame alist))
      ;; Emacs/Mule λ
      (progn
	(require 'color-mate-emacs-frame)
	(color-mate:emacs-set-current-frame alist)))
    ))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                  󥿥饯ƥѴؿ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 󥿥饯ƥˤäͤƤ줾ѿ
;  color-mate-set-current-frame ؿˤäƸߤΥե졼ο
; ѹ롣
;
(defun color-mate:set-color ( modeline-bg modeline-fg
			      region-bg   region-fg
			      frame-bg    frame-fg
			      cursor
			      mouse )
  "Change current frame color interactively.
Just press return key to use old value."
  
  ; ͤ롣ͤǥեͤȤɽ롣
  ; TAB, SPACE ˤ˥塼 M-n, M-p ˤλȤǽ
  (interactive
   (progn
     (require 'color-mate-rgb)      ; rgb ơ֥θƤӽФ
     
     (mapcar '(lambda (x)
		(completing-read x color-mate:rgb-table nil nil nil
				 'color-mate:color-history))
	     
	     (list
	      (format "Modeline background color (default %s): "
		      (color-mate:face-background 'modeline 'modeline))
	      (format "Modeline foreground color (default %s): "
		      (color-mate:face-foreground 'modeline 'modeline))
	      (format "Region background color (default %s): "
		      (color-mate:face-background 'region 'zmacs-region))
	      (format "Region foreground color (default %s): "
		      (color-mate:face-foreground 'region 'zmacs-region))
	      (format "Frame background color (default %s): "
		      (color-mate:frame-param-or-face-background
		       'background-color 'default))
	      (format "Frame foreground color (default %s): "
		      (color-mate:frame-param-or-face-foreground
		       'foreground-color 'default))
	      (format "Cursor color (default %s): "
		      (color-mate:frame-param-or-face-background
		       'cursor-color 'text-cursor))
	      (format "Mouse cursor name (default %s): "
		      (color-mate:frame-param-or-face-foreground
		       'mouse-color 'pointer))
	    ))))
  (progn
    (let (tmp-alist)

      ;; ͤꤵƤФͤ򡢤ƤʤͤѤ
      (if (not (equal modeline-bg ""))
	  (aput 'tmp-alist
		'modeline-background-color modeline-bg))
      (if (not (equal modeline-fg ""))
	  (aput 'tmp-alist
		'modeline-foreground-color modeline-fg))

      (if (not (equal region-bg ""))
	  (aput 'tmp-alist
		'region-background-color region-bg))
      (if (not (equal region-fg ""))
	  (aput 'tmp-alist
		'region-foreground-color region-fg))

      (if (not (equal frame-bg ""))
	  (aput 'tmp-alist
		'frame-background-color frame-bg))
      (if (not (equal frame-fg ""))
	  (aput 'tmp-alist
		'frame-foreground-color frame-fg))

      (if (not (equal cursor ""))
	  (aput 'tmp-alist
		'cursor-background-color cursor))
      (if (not (equal mouse ""))
	  (aput 'tmp-alist
		'mouse-foreground-color mouse))

      ;; 忧
      (color-mate:set-current-frame tmp-alist)
    )))


(provide 'color-mate) ; feature ȤϿ

;;; color-mate.el ends here
