;;; sj3-cursor.el -- Specify current input mode: In sj3-egg or out of sj3-egg.

;; Author: Masatake YAMATO <scs30154@bkc.ritsumei.ac.jp>
;;         Kazutaka SHIGENO <shigeno@vacation.kyushu-id.ac.jp>
;;         Hiroshi YOKOTA <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: Hiroshi YOKOTA <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 1.1
;; Keywords: egg sj3 color color-mate kanakan-cursor
;; Content-Type: text/plain; charset=x-euc-jp

;;; This code is derived from skk-cursor.el.

;;; This program is distributed under the GNU GENERAL PUBLIC LICENSE.

;;;; Usage
;;; Put this file in emacs-lisp directory.
;;; And put (require 'sj3-cursor) in your .emacs.
;;;  From edtion 4th, when the color map exhausting error occurs, The cursor 
;;; color is set sj3-mode-off-cursor-color. And if the variable, 
;;; cursor-color-error-report-always is t, the error message is displayed on the
;;; mini-buffer always. This means: 
;;; 
;;;  1) Don't setq sj3-mode-off-cursor-colors in mule session.(?)
;;;

;;;; Note
;;; This code will work with mule2.x / {X,GNU}Emacs 20 running on window system.
;;; If you want to change the color for each input mode into "yellow",
;;; put (setq sj3-mode-on-cursor-color "yellow") in your .emacs.

;;; History:
;; sj3-cursor.el for Color-Mate Ver.1.1:
;;    o xemacs fix.
;; sj3-cursor.el for Color-Mate Ver.1.0.1:
;;    o Small change for leim conflict detect.
;; sj3-cursor.el for Color-Mate Ver.1.0:
;;    o Port to Color-Mate.

;$Id: sj3-cursor.el,v 1.7 1999/08/05 23:35:52 elca Exp $

; This code is derived from egg-cursor.el.

;;;; Code

(require 'egg)
(require 'color-mate-util)

;; Entry point, key
(global-set-key "\C-\\" 'toggle-sj3-mode-with-cursor-color)

;;-------------------;
;; sj3-cursor ѿ
;;-------------------;
;; Color Setup
(defvar sj3-mode-on-cursor-color "forestgreen"
  "Cursor color for sj3-egg mode")
(defvar sj3-mode-off-cursor-color nil
  "Cursor color for mode out of sj3-egg")

(defvar sj3-cursor-color-bound-to-each-buffer nil
  "This variable will be referred when buffer is selected.
This is sj3-cursor's buffer-local variable. Don't use it!")
(make-variable-buffer-local 'sj3-cursor-color-bound-to-each-buffer)


;; ̵꤬ϽΥ뿧Ѥ
(if (not sj3-mode-off-cursor-color)
    (setq sj3-mode-off-cursor-color
	  (if (color-mate:is-xemacs)
	      (face-background-name 'text-cursor)
	    (cdr (assoc 'cursor-color (frame-parameters (selected-frame)))))
	  ))

;;
;; ¾ kanakan-cursor ץȤϢѤѿ
;;
(defvar canna-cursor-japanese-mode "init" "If \"on\", you are input words with canna.")
(defvar egg-cursor-japanese-mode "init" "If \"on\", you are input words with egg.")
(defvar skk-cursor-japanese-mode "init" "If \"on\", you are input words with skk.")
(defvar sj3-cursor-japanese-mode "init" "If \"on\", you are input words with sj3.")
(defvar leim-cursor-mode         "init" "If \"on\", you are input words with leim")
(make-variable-buffer-local 'canna-cursor-japanese-mode)
(make-variable-buffer-local 'egg-cursor-japanese-mode)
(make-variable-buffer-local 'skk-cursor-japanese-mode)
(make-variable-buffer-local 'sj3-cursor-japanese-mode)
(make-variable-buffer-local 'leim-cursor-mode)


;;--------------------------------------------------------------------------;
;; sj3-corsor δؿ
;;--------------------------------------------------------------------------;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 뿧
;; set cursor color
;;
;; canna, egg, skk, sj3 Τɤ줫Ĥδϥ⡼ɤ on ˤʤäƤ
;; 뿧򸵤᤹ʤʤ褦ˤƤ롣
;;
(defun sj3-cursor-set (mode)
  "Cursor color changer with conflict management."
  (progn
    (cond
     ((equal mode "on")
      (set-cursor-color sj3-cursor-color-bound-to-each-buffer))
     ((equal mode "off")
      (if (not (or (equal canna-cursor-japanese-mode "on")
		   (equal egg-cursor-japanese-mode "on")
		   (equal leim-cursor-mode "on")
		   (equal skk-cursor-japanese-mode "on")))
	  (set-cursor-color sj3-cursor-color-bound-to-each-buffer)))
     ((equal mode "init")
      (if (not (or (equal canna-cursor-japanese-mode "on")
		   (equal egg-cursor-japanese-mode "on")
		   (equal leim-cursor-mode "on")
		   (equal skk-cursor-japanese-mode "on")))
	  (set-cursor-color sj3-mode-off-cursor-color)))
     )))


; "C-\\" 򲡤˸ƤФ
(defun toggle-sj3-mode-with-cursor-color ()
  "Wrapper function of toggle-egg-mode(sj3) for cursor color management."
  (interactive)
  (toggle-egg-mode)
  (if (and egg:*mode-on* egg:*input-mode*)
      (progn
	(setq sj3-cursor-color-bound-to-each-buffer
	      sj3-mode-on-cursor-color)
	(setq sj3-cursor-japanese-mode "on"))
    (progn
      (setq sj3-cursor-color-bound-to-each-buffer
	    sj3-mode-off-cursor-color)
      (setq sj3-cursor-japanese-mode "off"))
    )
  (sj3-cursor-set sj3-cursor-japanese-mode)
  )


;; sj3 ǤѴ⡼ɤˤȲΤ뿧Τǡɤ

;; ǽѴ򲡤
;; redifine 1st "Henkan" key.
(defun sj3-cursor-henkan-fence-region-or-single-space ()

  (interactive)
  (progn
    (henkan-fence-region-or-single-space)
    (sj3-cursor-set sj3-cursor-japanese-mode)
    )
  )
(define-key fence-mode-map " " 'sj3-cursor-henkan-fence-region-or-single-space)

;; 2ܤѴ򲡤
;; redifine 2nd "Henkan" key.
(defun sj3-cursor-henkan-next-kouho ()
  (interactive)
  (progn
    (henkan-next-kouho)
    (sj3-cursor-set sj3-cursor-japanese-mode)))
(define-key henkan-mode-map " "    'sj3-cursor-henkan-next-kouho)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; re-define egg:select-window-hook
;;
; select-window-hook եå
; ¾ kanakan-cursor ⥸塼Ȥζͤƣʹˤ
(setq select-window-hook 
      '(lambda (old new)
	 (run-hook-with-args 'kanakan-cursor-select-window-hooks old new)))
(add-hook 'kanakan-cursor-select-window-hooks 'sj3-egg:select-window-hook)

(defun sj3-egg:select-window-hook (old new)
  (if (and (eq old (minibuffer-window))
	   (not (eq new (minibuffer-window))))
      (save-excursion
	(set-buffer (window-buffer (minibuffer-window)))
	(setq minibuffer-preprompt nil
	      egg:*mode-on* (default-value 'egg:*mode-on*)
	      egg:*input-mode* (default-value 'egg:*input-mode*)
	      egg:*in-fence-mode* (default-value 'egg:*in-fence-mode*))))
  (if (eq new (minibuffer-window))
      (setq minibuffer-window-selected t)
	  (setq minibuffer-window-selected nil))
  (save-excursion
    (set-buffer (window-buffer new))
    (sj3-cursor-set sj3-cursor-japanese-mode)))

;; add hook
(defadvice bury-buffer (after add-sj3-cursor-set first activate)
  (sj3-cursor-set sj3-cursor-japanese-mode))
(defadvice kill-buffer (after add-sj3-cursor-set first activate)
  (sj3-cursor-set sj3-cursor-japanese-mode))
(defadvice switch-to-buffer (after add-sj3-cursor-set first activate)
  (sj3-cursor-set sj3-cursor-japanese-mode))

;; add hook
(add-hook 'after-make-frame-hook
	  (function
	   (lambda ()
	     (sj3-cursor-set sj3-cursor-japanese-mode))))


;; feature ȤϿ
(provide 'sj3-cursor)

;;;;End Code

;;; sj3-cursor.el ends here
