;;; SunnyDay.el Color-Mate standard definition file -*-emacs-lisp-*-

;; Copyright (C) HIROSHI Yokota

;; Author: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.0
;; Keywords: color color-mate theme
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.0
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Coloring mule/emacs/xemacs to more easier and more fun.
;;   mule / emacs / xemacs ǡѤƸ䤹̤ˤޤ
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This file is part of Color-Mate

;; $Id: SunnyDay.el,v 10.1 1999/08/05 23:44:23 elca Exp $

(require 'assoc)

(setq color-mate:theme
      '(
	(frame-background-color .          "AntiqueWhite")
	;(frame-foreground-color .         "black")
	;(frame-height . 40)
	;(frame-width . 80)
	(modeline-background-color . "green4")
	(modeline-foreground-color . "white")
	;(modeline-underlined . nil)
	(modeline-buffer-id-foreground-color . "cyan2")
	(modeline-mousable-foreground-color . "pink")
	(modeline-mousable-minor-mode-foreground-color . "palegreen")
	;(region-underlined . nil)
	(region-background-color . "white")
	(region-foreground-color . "navy")
	(cursor-background-color . "navy")
	(cursor-foreground-color . "white")
	(mouse-background-color . "white")
	(mouse-foreground-color . "red")
	;(menu-bar-lines . 1)
	;(font . "default-fontset")
	;(line-space . "1+1")
	))

;; for Emacs20
(if (and (>= (string-to-int emacs-version) 20)
	 (not (string-match "XEmacs" emacs-version))
	 (eq window-system 'x))
    (aput 'color-mate:theme 'font "fontset-standard"))

;; for XEmacs20
(if (and (>= (string-to-int emacs-version) 20)
	 (string-match "XEmacs" emacs-version))
    (aput 'color-mate:theme 'font
	  '("-misc-*-medium-r-normal-*-16-*-*-*-*-*-iso8859-1"
	    "-*-fixed-medium-r-*--16-*-jisx0201.1976-*"
	    "-*-fixed-medium-r-*--16-*-jisx0208.1983-*"
	    "-*-fixed-medium-r-*--16-*-jisx0212.1990-*")))

;; for "Mule for Windows"
;(if (eq window-system 'win32)
;    (aput 'color-mate:theme 'font "default"))

;; for Meadow
;(if (featurep 'meadow)
;    (aput 'color-mate:theme 'font "default-fontset"))

;;; SunnyDay.el ends here
