;; a startup elisp for YaTeX
;;   -- S. Taoka <taoka@FreeBSD.org>

;;;;;;;;;;; YaTeX (Ver.1.70) ;;;;;;;;;;;

(setq load-path (append (list 
        "/usr/local/share/mule/site-lisp/yatex"
        ) load-path))
(setq auto-mode-alist
     (cons (cons "\\.tex$" 'yatex-mode) auto-mode-alist))
(autoload 'yatex-mode "yatex" "Yet Another LaTeX mode" t)
;;
;(setq tex-command "latex")
;(setq dvi2-command "xdvi -geo +0+0 -s 3")
;; If you use dvipsk as default, you should use the following three lines.
;(setq dviprint-from-format "-p %b")
;(setq dviprint-to-format "-l %b")
;(setq dviprint-command-format "dvips %f %t %s | lpr")
;; specifying a Kanji code for Mule
;;   (1=Shift JIS, 2=JIS, 3=EUC)
;(setq YaTeX-kanji-code 3)
;;

;; To highlight buffer, LaTeX commands (e.g. \section{foo})
(if (featurep 'xemacs)
    (progn
      ;;;;;; XEmacs 21 or later ;;;;;;
    	(setq YaTeX-use-font-lock t)
      )
  (if (string-match  "19.34" emacs-version)
      (progn
	;;;;;; Emacs 19.34 ;;;;;
	(setq YaTeX-use-hilit19 t)
	)
    (progn
      ;;;;;; Emacs 20 or later ;;;;;;
;	(setq YaTeX-use-hilit19 t)
    	(setq YaTeX-use-font-lock t)
	)))

;;
;;;;;;;; Yahtml (another html-mode) ;;;;;;
;(setq auto-mode-alist
;      (cons (cons "\\.html$" 'yahtml-mode) auto-mode-alist))
;(autoload 'yahtml-mode "yahtml" "Yet Another HTML mode" t)
;; Write your favorite browser.  But netscape is advantageous.
;(setq yahtml-www-browser "netscape")
;; Write correspondence alist from ABSOLUTE unix path name to URL path.
;(setq yahtml-path-url-alist
;      '(("/home/yuuji/public_html" . "http://www.mynet/~yuuji")
;	("/home/staff/yuuji/html" . "http://www.othernet/~yuuji")))

(provide 'yatex-startup)
