#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import gtk, GTK
import os
import main

class AboutWindow:

	dialog = None

	def __init__ (self):

		self.dialog = gtk.GtkDialog ()
		self.dialog.set_title ("ftpcube - About")
		self.dialog.set_policy (gtk.FALSE, gtk.FALSE, gtk.TRUE)
		self.dialog.set_position (gtk.WIN_POS_CENTER)
		self.dialog.show ()

		packer = gtk.GtkPacker ()
		packer.show ()
		self.dialog.action_area.add (packer)

		button = gtk.GtkButton ("Ok")
		button.set_usize (50, 25)
		button.connect ("clicked", self.ok)
		packer.add (button, options=GTK.EXPAND)
		button.show ()

		table = gtk.GtkTable (2, 1)
		table.show ()
		self.dialog.vbox.add (table)

		cube_pixmap, cube_mask = gtk.create_pixmap_from_xpm (self.dialog, None, main.ICONS_PREFIX + os.sep + "ftpcube_big.xpm")
		pixmap = gtk.GtkPixmap (cube_pixmap, cube_mask)
		pixmap.set_usize (32, 32)
		pixmap.show ()
		table.attach (pixmap, 0, 1, 0, 1, xoptions=GTK.EXPAND, yoptions=GTK.EXPAND, xpadding=25)

		frame = gtk.GtkFrame ()
		frame.set_border_width (10)
		frame.set_shadow_type (gtk.SHADOW_ETCHED_OUT)
		frame.show ()
		hbox = gtk.GtkHBox ()
		hbox.show ()
		frame.add (hbox)
		label = gtk.GtkLabel ()
		label.set_text (self.about_text ())
		label.show ()
		hbox.pack_start (label, padding=10)
		table.attach (frame, 1, 2, 0, 1)

	def ok (self, button):

		self.dialog.hide ()
		self.dialog.destroy ()

	def about_text (self):
		return \
			"""FtpCube - A graphical FTP Client\n
			   FtpCube is a graphical ftp client written in Python with GTK bindings, and based on LeechFTP by Jan Debis.
			   Feel free to visit the homepage at: http://ftpcube.sourceforge.net.\n
			   Michael Gilfix <mgilfix@eecs.tufts.edu>
			   Copyright (C) 2001
			   Licensing: ARTISTIC"""
