#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import gtk

class CmdWin:

	text = None
	scroll = None

	def __init__ (self, container):

		table = gtk.GtkTable (2, 1)
		container.add (table)
		table.show ()

		self.text = gtk.GtkText ()
		self.text.set_editable (gtk.FALSE)
		table.attach (self.text, 0, 1, 0, 1)
		self.text.show ()

		vadj = self.text.get_vadjustment ()
		self.scroll = gtk.GtkVScrollbar (vadj)
		table.attach (self.scroll, 1, 2, 0, 1, xoptions=gtk.FILL)
		self.scroll.show ()
		vadj.connect ("changed", self.scroll_check)

		self.display_banner ()

	def scroll_check (self, adj):

		if adj.upper - adj.lower <= adj.page_size:
			self.scroll.hide()
		else:
			self.scroll.show()

	def display_banner (self):

		self.insert_local_text ("Welcome to FtpCube v0.1.1")
		self.insert_local_text ("Copyright (C) 2001  Michael Gilfix")
		self.insert_local_text ("==========================================")
		self.insert_local_text ("")

	def insert_local_text (self, text):
		self.text.insert_defaults (self.beautify_local (text))

	def insert_remote_text (self, text):
		self.text.insert_defaults (self.beautify_remote (text))

	def beautify_local (self, text):
		return "LOCAL>  %s\n" %text

	def beautify_remote (self, text):
		return "REMOTE> %s\n" %text
