#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import sys, getopt, gtk
import os.path
import app

# Try to figure out where the icon directory might be.
# For now we look in a few simple places
if os.name == "posix":
	if os.path.exists ("/usr/local/share/ftpcube"):
		PREFIX = "/usr/local/share/ftpcube"
	elif os.path.exists ("/usr/share/ftpcube"):
		PREFIX = "/usr/share/ftpcube"
	else:
		PREFIX = "."
else:
	print "ftpcube can't determine the location of it's icons on your OS."
	print "Please set the prefix manually in main.py"
	sys.exit (1)

ICONS_PREFIX = PREFIX + os.sep + "icons"

cmdline_opts = { }

def main ():

	try:
		opts, args = getopt.getopt (sys.argv[1:], 'h', [
			'help',         # Print out help usage info
			'debug-level=', # The debugging output level to use
		])
	except getopt.GetoptError:
		usage ()
		sys.exit (1)

	for o, a in opts:
		if o in ("-h", "--help"):
			usage ()
			sys.exit (1)
		elif o == "--debug-level":
			cmdline_opts['debug_level'] = a

	# Instantiate the application and enter the main loop
	create_global_app (app.Application ("ftpcube"))

	gtk.threads_enter ()
	gtk.mainloop ()
	gtk.threads_leave ()

def create_global_app (a):

	global app
	app = a

def usage ():
	pass
