#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import gtk, GTK
import main

class OptionWindow:

	dialog = None
	notebook = None

	# Options hash
	opts = None

	connect_tab = None
	logging_tab = None
	external_tab = None

	def __init__ (self):

		self.opts = main.app.load_config (main.app.get_config_file ())

		self.dialog = gtk.GtkDialog ()
		self.dialog.set_title ("ftpcube - Options")
		self.dialog.set_policy (gtk.FALSE, gtk.FALSE, gtk.TRUE)
		self.dialog.set_position (gtk.WIN_POS_CENTER)
		self.dialog.show ()

		box = gtk.GtkHBox (spacing=75)
		box.show ()
		self.dialog.action_area.add (box, padding=95)

		button = gtk.GtkButton ("Accept")
		button.set_usize (50, 25)
		button.connect ("clicked", self.accept)
		box.pack_start (button, expand=gtk.FALSE)
		button.show ()

		button = gtk.GtkButton ("Cancel")
		button.set_usize (50, 25)
		button.connect ("clicked", self.cancel)
		box.pack_start (button, expand=gtk.FALSE)
		button.show ()

		self.notebook = gtk.GtkNotebook ()
		self.notebook.set_tab_pos (gtk.POS_TOP)
		self.dialog.vbox.add (self.notebook)
		self.notebook.show ()

		# Create the tabs and add them and show them
		self.connection_tab = ConnectionTab (self.opts)
		label = gtk.GtkLabel ("Connections")
		label.set_padding (2, 2)
		label.show ()
		self.notebook.append_page (self.connection_tab.get_page (), label)

		self.logging_tab = LoggingTab (self.opts)
		label = gtk.GtkLabel ("Logging")
		label.set_padding (2, 2)
		label.show ()
		self.notebook.append_page (self.logging_tab.get_page (), label)

		self.external_tab = ExternalTab (self.opts)
		label = gtk.GtkLabel ("Externals")
		label.set_padding (2, 2)
		label.show ()
		self.notebook.append_page (self.external_tab.get_page (), label)

	def accept (self, button):

		options = self.get_options ()
		self.opts.update (options)
		main.app.save_config (main.app.get_config_file (), self.opts)
		self.cancel (button)

	def cancel (self, button):

		self.dialog.hide ()
		self.dialog.destroy ()

	def get_options (self):

		opts = { }
		opts.update (self.connection_tab.get_options ())
		opts.update (self.logging_tab.get_options ())
		opts.update (self.external_tab.get_options ())
		return opts

class ConnectionTab:

	page = None

	timeout = None
	idle = None
	delay = None
	retries = None

	def __init__ (self, opts):

		self.page = gtk.GtkFrame ("Default Connection Settings")
		self.page.set_border_width (10)
		self.page.set_shadow_type (gtk.SHADOW_ETCHED_OUT)
		self.page.show ()

		vbox = gtk.GtkVBox ()
		vbox.show ()
		table = gtk.GtkTable (3, 4)
		table.set_row_spacings (7)
		table.show ()
		vbox.add (table, padding=15)
		self.page.add (vbox)

		# Create the timeout slot
		label = gtk.GtkLabel ("Connection timeout:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (200, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W, i_pad_x=15)
		table.attach (packer, 0, 1, 0, 1)
		self.timeout = gtk.GtkEntry ()
		self.timeout.set_usize (40, -1)
		if opts is not None and opts['timeout']:
			self.timeout.set_text ("%s" %opts['timeout'])
		self.timeout.show ()
		table.attach (self.timeout, 1, 2, 0, 1)
		label = gtk.GtkLabel ("(seconds)")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W, i_pad_x=7)
		table.attach (packer, 2, 3, 0, 1)

		# Create the idle slot
		label = gtk.GtkLabel ("Idle timeout for threads:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (200, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W, i_pad_x=15)
		table.attach (packer, 0, 1, 1, 2)
		self.idle = gtk.GtkEntry ()
		self.idle.set_usize (40, -1)
		if opts is not None and opts['thread_idle']:
			self.idle.set_text ("%s" %opts['thread_idle'])
		self.idle.show ()
		table.attach (self.idle, 1, 2, 1, 2)
		label = gtk.GtkLabel ("(seconds)")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W, i_pad_x=7)
		table.attach (packer, 2, 3, 1, 2)

		# Create the delay slot
		label = gtk.GtkLabel ("Delay between login retries:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (200, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W, i_pad_x=15)
		table.attach (packer, 0, 1, 2, 3)
		self.delay = gtk.GtkEntry ()
		self.delay.set_usize (40, -1)
		if opts is not None and opts['delay']:
			self.delay.set_text ("%s" %opts['delay'])
		self.delay.show ()
		table.attach (self.delay, 1, 2, 2, 3)
		label = gtk.GtkLabel ("(seconds)")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W, i_pad_x=7)
		table.attach (packer, 2, 3, 2, 3)

		# Create the retries slot
		label = gtk.GtkLabel ("Number of login attempts:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (225, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W, i_pad_x=15)
		table.attach (packer, 0, 1, 3, 4)
		self.retries = gtk.GtkEntry ()
		self.retries.set_usize (40, -1)
		if opts is not None and opts['retries']:
			self.retries.set_text ("%s" %opts['retries'])
		self.retries.show ()
		table.attach (self.retries, 1, 2, 3, 4)

	def get_options (self):

		opts = { }
		if self.timeout.get_text ():
			opts['timeout'] = int (self.timeout.get_text ())
		if self.idle.get_text ():
			opts['thread_idle'] = int (self.idle.get_text ())
		if self.delay.get_text ():
			opts['delay'] = int (self.delay.get_text ())
		if self.retries.get_text ():
			opts['retries'] = int (self.retries.get_text ())
		return opts

	def get_page (self):
		return self.page

class LoggingTab:

	page = None

	activate_button = None
	deactive_button = None

	cmds = None
	downloads = None
	uploads = None

	def __init__ (self, opts):

		# Create instance variables
		self.log = 0

		self.page = gtk.GtkFrame ("FTP Logging")
		self.page.set_border_width (10)
		self.page.set_shadow_type (gtk.SHADOW_ETCHED_OUT)
		self.page.show ()

		vbox = gtk.GtkVBox ()
		vbox.show ()
		hbox = gtk.GtkHBox ()
		hbox.show ()
		table = gtk.GtkTable (2, 4)
		table.set_row_spacings (7)
		table.set_row_spacing (0, 0)
		table.show ()
		hbox.add (table, padding=15)
		vbox.add (hbox, padding=2)
		self.page.add (vbox)

		frame = gtk.GtkFrame ("Activate Logging")
		frame.set_border_width (10)
		frame.set_shadow_type (gtk.SHADOW_ETCHED_OUT)
		frame.show ()
		packer = gtk.GtkPacker ()
		packer.show ()
		hbox = gtk.GtkHBox ()
		hbox.show ()
		packer.add (hbox)
		frame.add (packer)
		self.activate_button = gtk.GtkRadioButton (None, "Turn ON")
		self.activate_button.connect ("clicked", self.activate_clicked)
		self.activate_button.show ()
		self.deactivate_button = gtk.GtkRadioButton (self.activate_button, "Turn OFF")
		self.deactivate_button.connect ("clicked", self.deactivate_clicked)
		self.deactivate_button.show ()
		if opts is not None and opts['logging']:
			active = int (opts['logging'])
			if active:
				self.activate_button.set_active (gtk.TRUE)
			else:
				self.deactivate_button.set_active (gtk.TRUE)
		hbox.pack_start (self.activate_button)
		hbox.pack_start (self.deactivate_button)
		table.attach (frame, 0, 2, 0, 1)

		label = gtk.GtkLabel ("FTP command log:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (75, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W)
		table.attach (packer, 0, 1, 1, 2)
		self.cmds = gtk.GtkEntry ()
		if opts is not None and opts['cmd_log']:
			self.cmds.set_text (opts['cmd_log'])
		self.cmds.show ()
		table.attach (self.cmds, 1, 2, 1, 2)

		label = gtk.GtkLabel ("Download log:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (75, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W)
		table.attach (packer, 0, 1, 2, 3)
		self.downloads = gtk.GtkEntry ()
		if opts is not None and opts['download_log']:
			self.downloads.set_text (opts['download_log'])
		self.downloads.show ()
		table.attach (self.downloads, 1, 2, 2, 3)

		label = gtk.GtkLabel ("Upload log:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (75, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W)
		table.attach (packer, 0, 1, 3, 4)
		self.uploads = gtk.GtkEntry ()
		if opts is not None and opts['upload_log']:
			self.uploads.set_text (opts['upload_log'])
		self.uploads.show ()
		table.attach (self.uploads, 1, 2, 3, 4)

	def activate_clicked (self, button):
		self.log = 1

	def deactivate_clicked (self, button):
		self.log = 0

	def get_page (self):
		return self.page

	def get_options (self):

		return {
			'logging' : self.log,
			'cmd_log' : self.cmds.get_text (),
			'download_log' : self.downloads.get_text (),
			'upload_log'   : self.uploads.get_text (),
		}

class ExternalTab:

	page = None

	launcher = None
	viewer = None

	def __init__ (self, opts):

		self.page = gtk.GtkFrame ("External Helpers")
		self.page.set_border_width (10)
		self.page.set_shadow_type (gtk.SHADOW_ETCHED_OUT)
		self.page.show ()

		vbox = gtk.GtkVBox ()
		vbox.show ()
		hbox = gtk.GtkHBox ()
		hbox.show ()
		table = gtk.GtkTable (2, 3)
		table.set_row_spacings (7)
		table.show ()
		hbox.add (table, padding=10)
		vbox.add (hbox, padding=45)
		self.page.add (vbox)

		label = gtk.GtkLabel ("Launching Apps:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (35, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W)
		table.attach (packer, 0, 1, 0, 1)
		self.launcher = gtk.GtkEntry ()
		if opts is not None and opts['launcher']:
			self.launcher.set_text (opts['launcher'])
		self.launcher.show ()
		table.attach (self.launcher, 1, 2, 0, 1)

		label = gtk.GtkLabel ("Viewer:")
		label.show ()
		packer = gtk.GtkPacker ()
		packer.set_usize (35, -1)
		packer.show ()
		packer.add (label, anchor=GTK.ANCHOR_W)
		table.attach (packer, 0, 1, 1, 2)
		self.viewer = gtk.GtkEntry ()
		if opts is not None and opts['viewer']:
			self.viewer.set_text (opts['viewer'])
		self.viewer.show ()
		table.attach (self.viewer, 1, 2, 1, 2)

	def get_options (self):

		return {
			'launcher' : self.launcher.get_text (),
			'viewer'   : self.viewer.get_text (),
		}

	def get_page (self):
		return self.page
