# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 420 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/compare.al)"
;#
;# Compare($x, $y) compares two references for y-structure.
;# This routine returns
;#	-1 if $x < $y
;#	 1 if $x > $y;
;#	 0 otherwise ($x == $y).
;# Both of $x and $y must have y_path parameter.
;#
sub compare ($$) {
	my $x = shift; 
	my $y = shift;

	# DEBUG purpose only.
	confess("x=$x must be an Fan::Attrib")
		unless ref($x) && $x->isa('Fan::Attrib');
	confess("y=$y must be an Fan::Attrib")
		unless ref($y) && $y->isa('Fan::Attrib');

	# $z->{y_type} eq '.' means "$z is very large".
	return  0 if $x->{y_type} eq '.' && $y->{y_type} eq '.';
	return -1 if $y->{y_type} eq '.';	# == ($x < $y)
	return  1 if $x->{y_type} eq '.';	# == ($x > $y)

	# Temporary pathnames are required to use `cmp' operator.
	my $z;
	for $z ($x, $y) {
		if (!defined($z->{y_temp})) {
			# DEBUG purpose only.
			confess("$z has no path") if !defined($z->{y_path});
			$z->{y_temp} = $z->{y_path};
			$z->{y_temp} =~ y|/|\001|;
			$z->{y_temp} .= "\001\377" if $z->{y_type} eq 'U';
		}
	}

	# Now, we can compare with `cmp'.
	return $x->{y_temp} cmp $y->{y_temp};
}

# end of Fan::Attrib::compare
1;
