# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 521 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/fill.al)"
;#
;#
sub fill ($;$) {
	my $y = shift;					# hash reference
	my $realpath = @_ ? shift : $y->{y_realpath};	# real pathname

	# no need to fill out
	if ($y->{y_type} eq '.' || $y->{y_type} eq 'U') {
		return $y; # good. return myself.
	}

	# get file status...
	my @s;
	if ((@s = lstat($realpath)) == 0) {
		warn("lstat($realpath): $!\n") if $LOG > 5;
		return undef;
	} elsif (-l _) {
		$y->{y_type} = 'L';
		$y->{y_linkto} = readlink($realpath);
	} elsif (-d _) {
		$y->{y_type} = 'D';
	} elsif (-f _) {
		my $change = 0;
		$change++ if $y->{y_size} != $s[7];
		$change++ if $y->{y_mtime} != $s[9];

		$y->{y_type} = 'F';
		$y->{y_size} = $s[7];
		$y->{y_mtime} = $s[9];
# MD5 checksum is very expensive.
# Do not calculate checksum in this version.
#		if ($change || $y->{y_checksum} !~ /^[a-f0-9]{32}$/) {
#			$y->fill_checksum;
#		}
	} else { # unkown types...
		return undef;
	}

	# fill out...
	$y->{y_perm} = $s[2] & 0777;
	$y->{y_owner} = $s[4];
	$y->{y_group} = $s[5];

	# get basename of the path
	$realpath =~ m%([^/]+)$%;
	$y->{y_name} = $1;
	$y->{y_realpath} = $realpath;

	# and result is hash ref.
	$y;
}

# end of Fan::Attrib::fill
1;
