# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 584 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/from_line.al)"
;#
;#
sub from_line ($$) {
	my $y = shift;
	my $str = shift;

	$y->cleanup;
	$y->{y_flag} = $1 if $str =~ s/^(-|\+|=)//o;
	$str =~ s/^(\S)\s*//o
		or carp("$y: can't detect file type"), return undef;
	$y->{y_type} = $1;
	my @x = split(/\s+/, $str);
	while (@x && $x[$[] =~ s/^(.)=//) {
		my($z, $val) = ($1, $');
		shift(@x);
		if ($z eq 'p') {
			$y->{y_perm} = oct($val);
		} elsif ($z eq 'o') {
			($y->{y_owner}, $y->{y_group}) =
				$val =~ /\./ ? ($`, $') : ($val, undef);
		} elsif ($z eq 'm') {
			$y->{y_mtime} = &get_mtime($val);
		} elsif ($z eq 's') {
			$y->{y_size} = $val;
		} elsif ($z eq 'c') {
			$y->{y_checksum} = $val;
		} elsif ($z eq 'l') {
			$y->{y_linkto} = attr_decode($val);
		} else {
			warn("$y: unknown attribute `$z', ignored.\n");
		}
	}

	if (@x == 0) {
		; # no filename is given
	} elsif (@x == 1) {
		$y->{y_name} = attr_decode(shift(@x));
	} else {
		carp("$y: illegal line: $str"), return undef;
	}
	$y;
}

# end of Fan::Attrib::from_line
1;
