# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 164 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/new.al)"
;#
;# creat a Attrib new object.
;#	attr_path => /where/file/exists	or
;#	attr_line => attribute line	or
;#	attr_list => hogehoge		or
;#	dictionary...
;#
;#	attr_keys => reference to a hash $p.
;#		by default, \%y_keys is used.
;#
;# An Attrib object has some of following values.
;#	y_type
;#	y_name
;#	y_path
;#	y_realpath
;#	y_perm
;#	y_owner
;#	y_group
;#	y_size
;#	y_time0
;#	y_date
;#	y_checksum
;#	y_linkto
;#
sub new ($%) {
	my $this = shift;
	my $class = ref($this) || $this;
	my %params = @_;

	# Bless myself.
	my $y = bless {}, $class;
	ref($y) or return undef;

	# Count up # of objects.
	$seq_obj++;
	$n_obj++;
	$max_obj = $n_obj if $max_obj < $n_obj;

	# Select initializer
	if (defined($params{attr_path})) {	# from a real file
		$y->from_path($params{attr_path}) or return undef;
	} elsif (defined($params{attr_line})) {	# from a line
		$y->from_line($params{attr_line}) or return undef;
	} elsif (defined($params{attr_list})) {	# from ls format
		$y->from_list($params{attr_list}) or return undef;
	} else {				# from %params
		for my $tag (keys %params) {
			$y->{$tag} = $params{$tag} if $tag =~ /^y_/;
		}
	}

	# Can we trust this?
	$y && $y->validate or return undef;

	# For debugging purpose
	if ($LOG > 5) {
		my $t = $y->type;
		$t .= ' '.$y->name if $t ne '.' && $t ne 'U';
		carp("Attrib CREATING $y ($t)");
	}

	# Return this object.
	$y;
}

# end of Fan::Attrib::new
1;
