# NOTE: Derived from ../blib/lib/Fan/Cool.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Cool;

#line 311 "../blib/lib/Fan/Cool.pm (autosplit into ../blib/lib/auto/Fan/Cool/timezone.al)"
;#
;# Usage: &timezone
;#
;# Find local timezone like "+0900" or "GMT".
;# To calculate timezone, we use UTC clock of `946684800'
;# which means "2000-01-01 00:00:00".
;#
sub timezone () {
	local($[); # for zero-based array
	my($sec, $min, $hour, $day, $mon, $year) = localtime(946684800);
	my $sign = '+';
	my $offset = $hour * 60 + $min;

	if ($year == 99) {
		$sign = '-';
		$offset = 24 * 60 - $offset;
	}
	$offset++ if $offset % 10;
	return 'GMT' if !$offset;
	return $sign.'2359' if $offset >= 24 * 60;
	$sign.sprintf("%02d%02d", $offset / 60, $offset % 60);
}

# end of Fan::Cool::timezone
1;
