# NOTE: Derived from ../blib/lib/Fan/DIR.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::DIR;

#line 124 "../blib/lib/Fan/DIR.pm (autosplit into ../blib/lib/auto/Fan/DIR/load.al)"
;#
;# Load entries from a file, and fill %{$self->{dir_hash}}.
;# $dir = DIR->new(dir_path => $directory);
;# $dir->load;
;#
;# You can specify a filename rather than a directory name.
;# $dir->load("$temp/tmp_dirinfo");
;#
sub load ($$) {
	my $self = shift;
	my $dir = @_ ? shift : $self->{dir_path};
	my $dirinfo = -d $dir ? "$dir/.dirinfo" : $dir;
	my %assoc = ();
	local(*FILE, $_);

	# get directory info if exists
	-f $dirinfo or warn("$dirinfo is not a plain file."), return undef;
	open(FILE, $dirinfo) or warn("open($dirinfo): $!"), return undef;

	#
	my $pp = undef;
	while (<FILE>) {
		s/^\s+//; s/\s+$//; next if /^$/ || /^#/;
		/\s*=\s*/ || next;
		my($key, $val) = ($`, $');
		if (defined($typemap{$key})) {
			$pp = \%{$assoc{$val}};
			$pp->{y_type} = $typemap{$key};
			$pp->{y_name} = $val;
		} elsif ($key eq 'modified') {
			$pp->{y_mtime} = $val;
		} elsif ($key eq 'mode') {
			$pp->{y_perm} = oct($val);
		} elsif ($key eq 'owner') {
			my $u = getpwnam($val) if $val !~ /^\d+$/;
			$val = $u if $u ne '';
			$pp->{y_owner} = $val;
		} elsif ($key eq 'group') {
			my $g = getgrnam($val) if $val !~ /^\d+$/;
			$val = $g if $g ne '';
			$pp->{y_group} = $val;
		} elsif ($key eq 'md5checksum') {
			$pp->{y_checksum} = $val if $val =~ /^[a-f0-9]{32}$/;
		} else { # others...
			$key =~ tr/-/_/;
			$pp->{"y_$key"} = $val;
		}
	}
	close(FILE);

	# DO NOT clear hash, but clean array
	# $self->{dir_hash} = {};
	$self->{dir_array} = [];

	# register all entires..
	my $name;
	for $name (sort keys %assoc) {
		next if $name eq '' || $name eq '.' || $name eq '..';
		next if $name /\//;
		my $y = Fan::Attrib->new(%{$assoc{$name}});
		if (defined($y) && ref($y) eq 'Fan::Attrib') {
			$self->add($y);
# warn("load: $name... added\n") if $LOG > 7;
			push(@{$self->{dir_array}}, $name);
		} else {
			warn("Can't create Fan::Attrib object.");
		}
	}

	# success value
	1;
}

# end of Fan::DIR::load
1;
