# NOTE: Derived from ../blib/lib/Fan/DIR.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::DIR;

#line 252 "../blib/lib/Fan/DIR.pm (autosplit into ../blib/lib/auto/Fan/DIR/store.al)"
;# Write directory information(in %{$self->{dir_hash}})
;# to the file.
;# $dir = DIR->new($directory);
;# $dir->fill;
;# $dir->store;
;#
;# This routine will return zero if nothing has been modified,
;# or non-zero value will be returned.
sub store ($;$) {
	my $self = shift;
	my $dir = @_ ? shift : $self->{dir_path};
	my $dirinfo = -d $dir ? "$dir/.dirinfo" : $dir;
	my $temp = "$dirinfo.$$";
	local(*FILE, *TEMP, $_);

	# next, we open the file with write mode
	open(TEMP, ">$temp")
		or carp("open($temp): $!"), return undef;

	# current directory information
	my $y;
	if (defined($y = $self->get('.'))) {
		&putdata($y, \*TEMP);
	}

	#
	my $name;
	for $name (@{$self->{dir_array}}) {
		$y = $self->get($name);

		# check filename
		# we hate illegal filenames, but '.' is a special filename
		# which contains current directory information.
		# shall we store information for '.' first?
		next if $name eq '' || $name eq '.' || $name eq '..';
		next if $name =~ /^\.dirinfo/;
		next if $name =~ /\//;

# warn("store: ".$y->name."...\n") if $LOG > 7;
		&putdata($y, \*TEMP);
	}

	# close temporary info file once.
	close(TEMP);

	# comapre old and new files.
	if (open(FILE, $dirinfo) && open(TEMP, $temp)) {
		my $comp = 0;
		my $cont = 1;
		while ($cont) {
			$cont = 0;
			my $x = <FILE>;
			my $y = <TEMP>;
			if (defined($x) && defined($y)) {
				$x =~ s/\s+$//;
				$y =~ s/\s+$//;
				$cont++ if !($comp = $x cmp $y);
			} else {
				$comp = defined($x) || defined($y);
			}
		}
		close(FILE); close(TEMP);
		if (!$comp) {
			warn("$dir: no change\n") if $LOG > 6;
			unlink($temp), return 0; ## NO CHANGE
		}
	}

	# Now, we try to rename from temporary file to the real one.
	if (!rename($temp, $dirinfo)) {
		unlink($temp);
		warn("rename($temp, $dirinfo): $!\n") if $LOG > 4;
		return undef;
	}

	# We have changed!
	warn("store: $dir was updated") if $LOG > 6;
	return 1; # CHANGED
}

# end of Fan::DIR::store
1;
