# NOTE: Derived from ../blib/lib/Fan/FTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::FTP;

#line 276 "../blib/lib/Fan/FTP.pm (autosplit into ../blib/lib/auto/Fan/FTP/do_login.al)"
;# connecting the server.
sub do_login ($) {
	my $self = shift;

	# close existing connection first.
	$self->quit;

	# force to clear status.
	$self->clearerror(1);

	# clear some FTP flags
	delete($self->{no_size});
	delete($self->{no_mdtm});
	delete($self->{no_chmod});
	delete($self->{no_umask});
	delete($self->{no_idle});

	# get values.
	my $user = $self->{ftp_user};
	my $pass = $self->{ftp_pass};
	my $server = $self->{ftp_server};
	my $port = $self->{ftp_port} || $ftp_port;
	my $bindaddr = $self->{ftp_bindaddr};
	my $group = $self->{ftp_group};
	my $gpass = $self->{ftp_gpass};
	my $passive = $self->{ftp_passive};
	my $idle = $self->{ftp_idle};
	my $dir = $self->{ftp_directory};

	# check default values.
	if ($user eq '') {
		$user = 'anonymous';
	}
	if ($pass eq '') {
		$pass = getpwuid($<).'@'.$hostname;
	}
	if ($server eq '') {
		carp("FTP server not defined"), return undef;
	}
	if ($self->{ftp_gateway} ne '') {
		$user .= '@'.$server;
		$server = $self->{ftp_gateway};
	}

	# opening connection.
	$self->do_client(
		tcp_bindaddr => $bindaddr,
		tcp_host => $server,
		tcp_port => $port
	) or carp("FTP opening connection failed"), return undef;

	# we want initial message
	if ($self->getres != 220) {
		carp("do_login: can't connect") if $LOG > 5;
		$self->quit;
		return undef;
	}

	# try to send USER command
	unless ($self->putln("USER $user")) {
		carp("do_login: putln ".$self->error) if $LOG > 5;
		$self->quit;
		return undef;
	}

	# check response for USER command
	if ($self->getres == 331) {
		unless ($self->putln("PASS $pass")) {
			carp("do_login: putln ".$self->error) if $LOG > 5;
			$self->quit;
			return undef;
		}
		$self->getres; # to catch response code.
	}

	# check response for USER or PASS command
	if ($self->{lastcode} != 230) {
		carp("do_login: PASS: ".$self->error);
		$self->quit;
		return undef;
	}

	# if we are required to setup group...
	unless ($group eq '' || $self->group($group, $gpass)) {
		carp("do_login: GROUP: ".$self->error);
		$self->quit;
		return undef;
	}

	# is passive mode prefered?
	if ($passive) {
		$self->passive(1); # no error should occur.
	}

	# shall we change idle timer?
	if ($idle > 0 || $idle == -1) {
		my($i, $maxi) = $self->idle;
		$i = $idle == -1 || $idle > $maxi ? $maxi : $idle;
		$self->idle($i); # ignore result.
	}

	# we can change initial directory.
	unless ($dir eq '' || $self->chdir($dir)) {
		carp("do_login CHDIR: ".$self->error);
		$self->quit;
		return undef;
	}

	# success code.
	1;
}

# end of Fan::FTP::do_login
1;
