# NOTE: Derived from ../blib/lib/Fan/FTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::FTP;

#line 390 "../blib/lib/Fan/FTP.pm (autosplit into ../blib/lib/auto/Fan/FTP/port.al)"
;#
;# open accept socket, and send PORT command to the server.
;#
sub port ($) {
	my $self = shift;

	$self->clearerror || return undef;
	$self->cleardataconn;	# always success

	my ($port, $addr, $family) = $self->sockname;

	my $acpt = Fan::TCP->new();
	unless (defined($acpt)) {
		warn("Fan::TCP->new failed");
		return undef;
	}

	unless ($acpt->do_server(tcp_family => $family,
				 tcp_bindaddr => $addr)) {
		warn("Fan::TCP->do_server failed");
		return undef;
	}

	($port, $addr, $family) = $acpt->sockname;
	my $command;
	if ($family == AF_INET) {
		unless ($addr =~ tr/./,/ == 3) {
			warn("ADDRESS=$addr must have just 3 dots");
			return undef;
		}
		$addr .= sprintf(",%d,%d", ($port >> 8) & 0xff, $port & 0xff);
		$command = 'PORT';
	} else {
		$addr = "|2|$addr|$port|";
		$command = 'EPRT';
	}

	unless ($self->putreq("$command $addr") =~ /^2/) {
		warn("$command command failed\n") if $LOG > 5;
		$self->error($self->{lastmesg});
		return undef;
	}

	$self->{ftp_acpt} = $acpt; # now, ready to accept
	1;
}

# end of Fan::FTP::port
1;
